/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.cmds;

import com.tridium.cloud.client.BICloudConnector;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.CloudMessageCallback;
import com.tridium.nc.CloudUtilities;
import com.tridium.nc.cmds.AlarmAckCommand;
import com.tridium.nc.cmds.BCloudCommandExecutor;
import com.tridium.nc.cmds.BCloudCommands;
import com.tridium.nc.cmds.BatchAlarmAckCommand;
import com.tridium.nc.cmds.CloudMultiPointClearCommand;
import com.tridium.nc.cmds.CloudMultiPointReadCommand;
import com.tridium.nc.cmds.CloudMultiPointReadInputsCommand;
import com.tridium.nc.cmds.CloudMultiPointWriteCommand;
import com.tridium.nc.cmds.CloudPointReadCommand;
import com.tridium.nc.cmds.CloudPointReadInputsCommand;
import com.tridium.nc.cmds.CloudPointWriteCommand;
import com.tridium.nc.cmds.CovActiveCommand;
import com.tridium.nc.cmds.CovInactiveCommand;
import com.tridium.nc.cmds.ICloudSystemCommand;
import com.tridium.nc.cmds.InvokeCommand;
import com.tridium.nc.cmds.RetrieveCloudCommandsCommand;
import com.tridium.nc.cmds.RetrieveCloudPointsCommand;
import com.tridium.nc.cmds.SubscribePointsCommand;
import com.tridium.nc.cmds.UnsubscribePointsCommand;
import com.tridium.nc.devices.CloudDecodeMsg;
import com.tridium.nc.devices.CloudEncodeMsg;
import com.tridium.nc.devices.CloudMessage;
import com.tridium.nc.devices.sentience.SentienceRegisterCmdRequestV1;
import com.tridium.nc.devices.sentience.cmds.SentienceSystemCommandRequestV1;
import com.tridium.nc.devices.sentience.events.EventData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.baja.driver.BDeviceExt;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PermissionException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="commandExecutor", type="BCloudCommandExecutor", defaultValue="new BCloudCommandExecutor()"), @NiagaraProperty(name="cloudCommands", type="BCloudCommands", defaultValue="new BCloudCommands()")})
public class BCloudCommandsDeviceExt
extends BDeviceExt {
    public static final Property enabled = BCloudCommandsDeviceExt.newProperty((int)0, (boolean)false, null);
    public static final Property commandExecutor = BCloudCommandsDeviceExt.newProperty((int)0, (BValue)new BCloudCommandExecutor(), null);
    public static final Property cloudCommands = BCloudCommandsDeviceExt.newProperty((int)0, (BValue)new BCloudCommands(), null);
    public static final Type TYPE = Sys.loadType(BCloudCommandsDeviceExt.class);
    private final Map<String, ICloudSystemCommand> registeredCommands = new ConcurrentHashMap<String, ICloudSystemCommand>();
    private final CloudCommandCallback commandCallback = new CloudCommandCallback();
    private static final Logger log = Logger.getLogger("ncloud.command");
    private static final int logPageSize = 3500;
    protected Lexicon lexicon = Lexicon.make((String)"nCloudDriver");

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BCloudCommandExecutor getCommandExecutor() {
        return (BCloudCommandExecutor)this.get(commandExecutor);
    }

    public void setCommandExecutor(BCloudCommandExecutor v) {
        this.set(commandExecutor, (BValue)v, null);
    }

    public BCloudCommands getCloudCommands() {
        return (BCloudCommands)this.get(cloudCommands);
    }

    public void setCloudCommands(BCloudCommands v) {
        this.set(cloudCommands, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        new RetrieveCloudPointsCommand(this);
        new CloudPointReadCommand(this);
        new CloudMultiPointReadCommand(this);
        new CloudPointReadInputsCommand(this);
        new CloudMultiPointReadInputsCommand(this);
        new CloudPointWriteCommand(this);
        new CloudMultiPointWriteCommand(this);
        new CloudMultiPointClearCommand(this);
        new CovActiveCommand(this);
        new CovInactiveCommand(this);
        new SubscribePointsCommand(this);
        new UnsubscribePointsCommand(this);
        new AlarmAckCommand(this);
        new BatchAlarmAckCommand(this);
        new InvokeCommand(this);
        new RetrieveCloudCommandsCommand(this);
    }

    public void registerForCommands() {
        BCloudDevice device = (BCloudDevice)this.getParent();
        ArrayList<SentienceRegisterCmdRequestV1.RegisterCommandTypes> list = new ArrayList<SentienceRegisterCmdRequestV1.RegisterCommandTypes>();
        list.add(SentienceRegisterCmdRequestV1.RegisterCommandTypes.SYSTEM_COMMAND_REQUEST);
        CloudEncodeMsg registerCmdReq = device.getFactory().createRegisterCmdRequestMsg(list);
        device.resolveConnector().sendMessage(registerCmdReq.encode(null), registerCmdReq.getProperties(null)).whenComplete((resp, err) -> {
            if (err != null) {
                log.warning("Failed to register for SYSTEM_COMMAND_REQUEST: " + err.getMessage());
            } else {
                log.fine("SYSTEM_COMMAND_REQUEST command registered successfully");
            }
        });
    }

    public void registerComponent(ICloudSystemCommand commandComponent) {
        if (this.registeredCommands.containsKey(commandComponent.getCommandName())) {
            String message = "Attempt to register system command with same name as existing command: " + commandComponent.getCommandName();
            log.warning(message);
            throw new IllegalArgumentException(message);
        }
        this.registeredCommands.put(commandComponent.getCommandName(), commandComponent);
    }

    public void unregisterComponent(ICloudSystemCommand commandComponent) {
        this.registeredCommands.remove(commandComponent.getCommandName());
    }

    Set<String> getCommandSet() {
        return this.registeredCommands.keySet();
    }

    public CloudMessageCallback getCommandCallback() {
        return this.commandCallback;
    }

    void sendResponse(Map<String, Object> properties, String messageId, String commandName) {
        BCloudDevice device = (BCloudDevice)this.getParent();
        BICloudConnector connector = device.resolveConnector();
        if (CloudUtilities.canSendMessage(device)) {
            CloudEncodeMsg resultMsg = device.getFactory().createNewEventRequestMsg();
            HashMap<String, Object> response = new HashMap<String, Object>();
            HashMap<String, Object> responseProps = new HashMap<String, Object>();
            ArrayList<EventData> events = new ArrayList<EventData>();
            JSONObject body = new JSONObject();
            for (Map.Entry<String, Object> prop : properties.entrySet()) {
                body.put(prop.getKey(), prop.getValue());
            }
            EventData event = new EventData(UUID.randomUUID().toString(), BAbsTime.now().encodeToString(), connector.getId(), messageId, commandName, body, null, "system command update");
            events.add(event);
            response.put(device.getConstant("EVENTS"), events);
            connector.sendMessage(resultMsg.encode(response), resultMsg.getProperties(responseProps)).whenComplete((resp, err) -> {
                if (err != null) {
                    log.warning(String.format("failed to send cloud system command response message with correlation ID %s: %s", messageId, err.getMessage()));
                } else {
                    log.fine("Cloud system command response message sent successfully, correlation ID " + messageId);
                }
            });
        } else {
            log.warning("Connector Ord is null or the connector is not connected while trying to ping the device " + messageId);
        }
    }

    class CloudCommandCallback
    implements CloudMessageCallback {
        CloudCommandCallback() {
        }

        @Override
        public void onMessage(String messageId, CloudMessage decodedMessage, Context cx) {
            SentienceSystemCommandRequestV1 commandRequest = (SentienceSystemCommandRequestV1)decodedMessage;
            JSONObject cloudPlatformHeaders = commandRequest.getCloudPlatformHeaders();
            String command = cloudPlatformHeaders != null && cloudPlatformHeaders.has("Command") ? JSONUtil.getString((JSONObject)cloudPlatformHeaders, (String)"Command") : (String)commandRequest.getData("Command");
            if (BCloudCommandsDeviceExt.this.getEnabled()) {
                String finalPayload;
                String finalUserName;
                String logMsg;
                String commandId = cloudPlatformHeaders != null && cloudPlatformHeaders.has("CommandId") ? JSONUtil.getString((JSONObject)cloudPlatformHeaders, (String)"CommandId") : (String)commandRequest.getData("CommandId");
                JSONObject commandParameters = (JSONObject)commandRequest.getData("CommandParameters");
                String callingIdentity = (String)commandRequest.getData("CallingIdentity");
                commandParameters.put("CallingIdentity", (Object)callingIdentity);
                String payload = "null";
                if (commandParameters.has("CommandPayload")) {
                    payload = JSONUtil.getString((JSONObject)commandParameters, (String)"CommandPayload");
                }
                Object auth = commandRequest.getAuth();
                String tmpAuth = "";
                if (auth != null) {
                    if (auth instanceof String) {
                        String authString = (String)auth;
                        int printLen = 16;
                        if (authString.length() <= 20) {
                            printLen = authString.length() / 2;
                        }
                        tmpAuth = "token ending in " + authString.substring(authString.length() - printLen);
                    } else {
                        tmpAuth = "********";
                    }
                    if (cloudPlatformHeaders != null) {
                        cloudPlatformHeaders.put("Auth", (Object)tmpAuth);
                    }
                }
                String userName = "null";
                BUser user = cx.getUser();
                if (user != null) {
                    userName = user.getName();
                }
                if ((logMsg = String.format("System Command received message id=%s, command id=%s, user=%s, calling identity=%s, command=%s, platform headers=%s, payload=%s", messageId, commandId, finalUserName = userName, callingIdentity, command, cloudPlatformHeaders, finalPayload = payload)).length() < 3500) {
                    log.info(logMsg);
                } else {
                    for (int lcv = 0; lcv < logMsg.length(); lcv += 3500) {
                        log.info(messageId + ": " + logMsg.substring(lcv, lcv + 3500 > logMsg.length() ? logMsg.length() : lcv + 3500));
                    }
                }
                if (cloudPlatformHeaders != null && auth != null) {
                    cloudPlatformHeaders.put("Auth", auth);
                }
                this.processCommand(command, commandParameters, commandId, messageId, cx);
                log.finer(() -> String.format("System Command complete message id=%s", messageId));
            } else {
                log.info(() -> String.format("Cannot process received System Command %s: System Commands Disabled %s", command, messageId));
                HashMap<String, Object> responseProps = new HashMap<String, Object>();
                responseProps.put("ResponseCode", String.valueOf(503));
                responseProps.put("ErrorMessage", "Error: Service Unavailable");
                BCloudCommandsDeviceExt.this.sendResponse(responseProps, messageId, command);
            }
        }

        @Override
        public boolean enabled() {
            return BCloudCommandsDeviceExt.this.getEnabled();
        }

        @Override
        public CloudEncodeMsg getResponse() {
            BCloudDevice device = (BCloudDevice)BCloudCommandsDeviceExt.this.getParent();
            return device.getFactory().createSystemCommandResponseMsg();
        }

        @Override
        public Map<String, Object> getResponseParams(String messageId, CloudDecodeMsg decodedMessage, int code, String message) {
            BCloudDevice device = (BCloudDevice)BCloudCommandsDeviceExt.this.getParent();
            HashMap<String, Object> rv = new HashMap<String, Object>();
            rv.put(device.getConstant("STATUS"), device.getConstant("CMD_STATUS_SUCCESS"));
            rv.put(device.getConstant("ERROR_MESSAGE"), message);
            rv.put(device.getConstant("ERROR_CODE"), code);
            rv.put(device.getConstant("CORRELATIONID"), messageId);
            rv.put(device.getConstant("RESPONSE_PARAMETERS"), new JSONObject());
            return rv;
        }

        private void processCommand(String command, JSONObject commandParameters, String commandId, String messageId, Context cx) {
            HashMap<String, Object> responseProperties = new HashMap<String, Object>();
            responseProperties.put("CorrelationId", messageId);
            try {
                ICloudSystemCommand systemCommand = (ICloudSystemCommand)BCloudCommandsDeviceExt.this.registeredCommands.get(command);
                if (systemCommand != null) {
                    commandParameters.put(((BCloudDevice)BCloudCommandsDeviceExt.this.getParent()).getConstant("COMMANDID"), (Object)commandId);
                    systemCommand.runCommand(commandParameters, responseProperties, cx);
                    BCloudCommandsDeviceExt.this.sendResponse(responseProperties, commandId, command);
                } else {
                    log.info(() -> String.format("Cannot process received System Command %s: Unknown Command %s", command, messageId));
                    responseProperties.put("CorrelationId", messageId);
                    responseProperties.put("ResponseCode", String.valueOf(400));
                    responseProperties.put("ErrorMessage", "Error: Command Not Allowed");
                    BCloudCommandsDeviceExt.this.sendResponse(responseProperties, commandId, command);
                }
            }
            catch (Exception e) {
                log.warning(() -> String.format("Error processing System Command %s: %s %s", command, e, messageId));
                responseProperties.put("CorrelationId", messageId);
                if (e instanceof PermissionException) {
                    responseProperties.put("ResponseCode", 403);
                    responseProperties.put("ErrorMessage", "Error: Access Not Allowed");
                } else {
                    responseProperties.put("ResponseCode", String.valueOf(500));
                    responseProperties.put("ErrorMessage", "Error: Bad Request");
                }
                BCloudCommandsDeviceExt.this.sendResponse(responseProperties, commandId, command);
            }
            log.info(() -> String.format("Command %s exited with response code %s and message %s %s", command, responseProperties.get("ResponseCode"), responseProperties.get("ErrorMessage"), messageId));
        }
    }
}

