/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.cmds;

import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.cmds.BCloudCommands;
import com.tridium.nc.cmds.BCloudCommandsDeviceExt;
import com.tridium.nc.cmds.ICloudSystemCommand;
import com.tridium.sys.Nre;
import com.tridium.util.ComponentTreeCursor;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BIRestrictedComponent;

@NiagaraType
@NiagaraProperty(name="enabled", type="boolean", defaultValue="true")
public abstract class BCloudCustomCommand
extends BComponent
implements ICloudSystemCommand,
BIRestrictedComponent {
    public static final Property enabled = BCloudCustomCommand.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BCloudCustomCommand.class);
    private String commandName;
    private BCloudCommandsDeviceExt ext;
    private BCloudDevice device;
    private static final Logger log = Logger.getLogger("ncloud.command");

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BCloudCustomCommand.checkForDuplicates(parent, this);
    }

    private static void checkForDuplicates(BComponent parent, BIRestrictedComponent child) {
        ComponentTreeCursor c = new ComponentTreeCursor(parent, null);
        while (c.next()) {
            BValue value = c.get();
            if (value == child || !child.getType().equals(value.getType())) continue;
            throw new IllegalChildException("baja", "DuplicateRestrictedComponent", new Object[]{parent.getType(), child.getType()});
        }
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BCloudCommands;
    }

    public void started() {
        BComplex parent = this.getParent();
        if (parent instanceof BCloudCommands && (parent = parent.getParent()) instanceof BCloudCommandsDeviceExt) {
            ((BCloudCommandsDeviceExt)parent).registerComponent(this);
            this.ext = (BCloudCommandsDeviceExt)parent;
            this.device = (BCloudDevice)this.ext.getDevice();
        }
    }

    public void stopped() {
        if (this.ext != null) {
            this.ext.unregisterComponent(this);
            this.ext = null;
            this.device = null;
        }
    }

    @Override
    public final void setCommandName(String cmdName) {
        this.commandName = cmdName;
    }

    @Override
    public final String getCommandName() {
        return this.commandName;
    }

    @Override
    public final void runCommand(JSONObject commandProperties, Map<String, Object> responseProperties, Context cx) {
        Auditor auditor;
        String messageId = (String)responseProperties.get(this.device.getConstant("CORRELATIONID"));
        log.fine(() -> String.format("BCloudCustomCommand %s executing %s", this.getCommandName(), messageId));
        String commandID = JSONUtil.getString((JSONObject)commandProperties, (String)this.device.getConstant("COMMANDID"));
        responseProperties.put(this.device.getConstant("COMMANDID"), commandID);
        if (!this.getEnabled()) {
            log.info(() -> String.format("Cannot execute command %s, command is disabled %s", this.getCommandName(), messageId));
            responseProperties.put(this.device.getConstant("RESPONSE_CODE"), String.valueOf(this.device.getNumericConstant("CMD_ERR_CODE_GENERAL")));
            responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("ERR_SYSTEM_COMMAND_NOT_ALLOWED"));
            log.fine(() -> String.format("BCloudCustomCommand %s complete %s", this.getCommandName(), messageId));
            return;
        }
        BUser user = null;
        if (cx != null && cx.getUser() != null) {
            user = cx.getUser();
            try {
                user.check((BIProtected)this, BPermissions.adminInvoke);
            }
            catch (PermissionException e) {
                log.info(() -> String.format("Insufficient permissions to execute command %s: %s %s", this.getCommandName(), e.getMessage(), messageId));
                responseProperties.put(this.device.getConstant("RESPONSE_CODE"), String.valueOf(this.device.getNumericConstant("CMD_ERR_CODE_GENERAL")));
                responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("ERR_SYSTEM_COMMAND_NOT_ALLOWED"));
                log.finer(() -> String.format("BCloudCustomCommand %s complete %s", this.getCommandName(), messageId));
                return;
            }
        }
        responseProperties.put(this.device.getConstant("RESPONSE_CODE"), this.device.getNumericConstant("CMD_RESP_CODE_OK"));
        responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("RESP_OK"));
        try {
            log.fine("Running command " + this.getCommandName() + " with props:" + commandProperties);
            this.doRun(commandProperties, responseProperties, cx);
        }
        catch (Exception ex) {
            responseProperties.put(this.device.getConstant("RESPONSE_CODE"), this.device.getNumericConstant("CMD_ERR_CODE_FAILURE"));
            responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), ex.toString());
            log.warning(String.format("BCloudCustomCommand %s failed with %s", messageId, ex));
        }
        if (user != null && (auditor = Nre.auditor) != null) {
            auditor.audit(new AuditEvent("Invoked", this.getSlotPath().getBody(), "runCommand", null, null, user.getUsername()));
        }
        log.fine(() -> String.format("BCloudCustomCommand %s complete %s", this.getCommandName(), messageId));
    }

    public abstract void doRun(JSONObject var1, Map<String, Object> var2, Context var3) throws Exception;
}

