/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.cmds;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.CloudUtilities;
import com.tridium.nc.cmds.BCloudCommandsDeviceExt;
import com.tridium.nc.cmds.ICloudSystemCommand;
import com.tridium.nc.point.BCloudPointDeviceExt;
import com.tridium.nc.point.ClearPointException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.security.PermissionException;
import javax.baja.sys.Context;

public final class CloudMultiPointClearCommand
implements ICloudSystemCommand {
    private String commandName;
    private final BCloudDevice device;
    private static final Logger log = Logger.getLogger("ncloud.command");
    private static final int BATCH_SIZE = 1024;

    public CloudMultiPointClearCommand(BCloudCommandsDeviceExt bCloudCommandsDeviceExt) {
        this.setCommandName("CloudMultiPointClearCommand");
        this.register(bCloudCommandsDeviceExt);
        this.device = (BCloudDevice)bCloudCommandsDeviceExt.getDevice();
    }

    @Override
    public void setCommandName(String cmdName) {
        this.commandName = cmdName;
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public void runCommand(JSONObject commandProperties, Map<String, Object> responseProperties, Context cx) {
        int msgTotal;
        Map<String, Object> respProperties;
        String messageId = (String)responseProperties.get(this.device.getConstant("CORRELATIONID"));
        String commandID = JSONUtil.getString((JSONObject)commandProperties, (String)this.device.getConstant("COMMANDID"));
        log.fine(() -> String.format("%s executing %s", this.commandName, messageId));
        if (!this.device.getNiagaraCloudNetwork().getPointWriteAllowed()) {
            log.warning(() -> String.format("Attempted to clear Point cloud value: access not allowed %s", messageId));
            responseProperties.put(this.device.getConstant("RESPONSE_CODE"), this.device.getNumericConstant("CMD_ERR_CODE_FORBIDDEN"));
            responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("ERR_ACCESS_NOT_ALLOWED"));
            responseProperties.put(this.device.getConstant("COMMANDID"), commandID);
            return;
        }
        JSONObject payload = new JSONObject(JSONUtil.getString((JSONObject)commandProperties, (String)this.device.getConstant("COMMAND_PAYLOAD")));
        JSONArray pointClears = payload.optJSONArray(this.device.getConstant("POINTCLEARS"));
        if (pointClears == null) {
            pointClears = new JSONArray();
            JSONArray pointIds = payload.getJSONArray(this.device.getConstant("POINTIDS"));
            for (int i = 0; i < pointIds.length(); ++i) {
                pointClears.put((Object)new JSONObject().put(this.device.getConstant("POINTID"), pointIds.get(i)).put(this.device.getConstant("PRIORITY"), 0));
            }
        }
        if (pointClears.length() <= 1024) {
            respProperties = responseProperties;
            msgTotal = 1;
        } else {
            msgTotal = pointClears.length() / 1024 + (pointClears.length() % 1024 == 0 ? 0 : 1);
            respProperties = new HashMap<String, Object>();
            respProperties.put(this.device.getConstant("CORRELATIONID"), messageId);
        }
        respProperties.put(this.device.getConstant("COMMANDID"), commandID);
        JSONObject pointResults = new JSONObject();
        for (int lcv = 0; lcv < pointClears.length(); ++lcv) {
            String status;
            JSONObject pointClear = pointClears.getJSONObject(lcv);
            String pointID = JSONUtil.getString((JSONObject)pointClear, (String)this.device.getConstant("POINTID"));
            int priority = pointClear.getInt(this.device.getConstant("PRIORITY"));
            BControlPoint point = CloudUtilities.getPoint(pointID);
            if (point != null && CloudUtilities.isPointWriteAllowed(this.device.getNiagaraCloudNetwork(), point, cx)) {
                try {
                    BCloudPointDeviceExt.clearPoint(point, priority);
                    status = "Success";
                }
                catch (PermissionException ignored) {
                    status = this.device.getConstant("ERR_ACCESS_NOT_ALLOWED");
                    log.warning(() -> String.format("Attempted to clear Point cloud value: access not allowed: %s %s", pointID, messageId));
                }
                catch (ClearPointException ignored) {
                    status = String.format("Error: Failed to clear the point value at %s priority", priority);
                    log.warning(() -> String.format("Attempt to force clear on pointId %s failed; messageId %s", pointID, messageId));
                }
            } else {
                status = this.device.getConstant("ERR_ACCESS_NOT_ALLOWED");
                log.warning(() -> String.format("Attempted to clear Point cloud value: access not allowed: %s %s", pointID, messageId));
            }
            pointResults.put(pointID, (Object)status);
            if (lcv % 1024 != 1023 || lcv == pointClears.length() - 1) continue;
            respProperties.put(this.device.getConstant("RESPONSE_CODE"), this.device.getNumericConstant("CMD_RESP_CODE_OK"));
            respProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("RESP_OK"));
            respProperties.put("sequenceNum", lcv / 1024);
            respProperties.put("segmentTotal", msgTotal);
            respProperties.put("PointClearDetails", pointResults);
            this.device.getCommands().sendResponse(respProperties, commandID, this.commandName);
            pointResults = new JSONObject();
            if (pointClears.length() - lcv <= 1024) {
                respProperties = responseProperties;
            } else {
                respProperties = new HashMap<String, Object>();
                respProperties.put(this.device.getConstant("CORRELATIONID"), messageId);
            }
            respProperties.put(this.device.getConstant("COMMANDID"), commandID);
        }
        responseProperties.put(this.device.getConstant("RESPONSE_CODE"), this.device.getNumericConstant("CMD_RESP_CODE_OK"));
        responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("RESP_OK"));
        responseProperties.put("SequenceNum", pointClears.length() / 1024);
        respProperties.put("segmentTotal", msgTotal);
        respProperties.put("PointClearDetails", pointResults);
        log.fine(() -> String.format("%s complete %s", this.commandName, messageId));
    }
}

