/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.cmds;

import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.CloudUtilities;
import com.tridium.nc.cmds.BCloudCommandsDeviceExt;
import com.tridium.nc.cmds.ICloudSystemCommand;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Context;

public final class CloudPointReadCommand
implements ICloudSystemCommand {
    private String commandName;
    private final BCloudDevice device;
    private static final Logger log = Logger.getLogger("ncloud.command");

    public CloudPointReadCommand(BCloudCommandsDeviceExt bCloudCommandsDeviceExt) {
        this.setCommandName("CloudPointReadCommand");
        this.register(bCloudCommandsDeviceExt);
        this.device = (BCloudDevice)bCloudCommandsDeviceExt.getDevice();
    }

    @Override
    public void setCommandName(String cmdName) {
        this.commandName = cmdName;
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public void runCommand(JSONObject commandProperties, Map<String, Object> responseProperties, Context cx) {
        String messageId = (String)responseProperties.get(this.device.getConstant("CORRELATIONID"));
        log.fine(() -> String.format("%s executing %s", this.commandName, messageId));
        JSONObject payload = new JSONObject(JSONUtil.getString((JSONObject)commandProperties, (String)this.device.getConstant("COMMAND_PAYLOAD")));
        String pointId = JSONUtil.getString((JSONObject)payload, (String)this.device.getConstant("POINTID"));
        BControlPoint pxPoint = CloudUtilities.getPoint(pointId);
        String commandID = JSONUtil.getString((JSONObject)commandProperties, (String)this.device.getConstant("COMMANDID"));
        responseProperties.put(this.device.getConstant("COMMANDID"), commandID);
        if (pxPoint != null) {
            if (CloudUtilities.isPointReadAllowed(this.device.getNiagaraCloudNetwork(), pxPoint, cx)) {
                BStatusValue pointValue = CloudUtilities.cloudProxy(pxPoint).getPointValue();
                JSONObject jObj = new JSONObject();
                jObj.put(this.device.getConstant("STATUS"), (Object)CloudUtilities.toStatusString(pointValue.getStatus()));
                jObj.put(this.device.getConstant("VALUE"), (Object)pointValue.getValueValue().toString());
                responseProperties.put(pointId, jObj);
                responseProperties.put(this.device.getConstant("RESPONSE_CODE"), this.device.getNumericConstant("CMD_RESP_CODE_OK"));
                responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("RESP_OK"));
            } else {
                log.warning(() -> String.format("Attempted to read from Point: access not allowed %s", messageId));
                responseProperties.put(this.device.getConstant("RESPONSE_CODE"), this.device.getNumericConstant("CMD_ERR_CODE_FORBIDDEN"));
                responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("ERR_ACCESS_NOT_ALLOWED"));
            }
        } else {
            responseProperties.put(this.device.getConstant("RESPONSE_CODE"), this.device.getNumericConstant("CMD_ERR_CODE_FORBIDDEN"));
            responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("ERR_ACCESS_NOT_ALLOWED"));
        }
        log.fine(() -> String.format("%s complete %s", this.commandName, messageId));
    }
}

