/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.cmds;

import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.CloudUtilities;
import com.tridium.nc.cmds.BCloudCommandsDeviceExt;
import com.tridium.nc.cmds.ICloudSystemCommand;
import com.tridium.nc.point.BCloudPointDeviceExt;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.security.PermissionException;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;

public final class CloudPointWriteCommand
implements ICloudSystemCommand {
    private String commandName;
    private final BCloudDevice device;
    private static final Logger log = Logger.getLogger("ncloud.command");

    public CloudPointWriteCommand(BCloudCommandsDeviceExt bCloudCommandsDeviceExt) {
        this.setCommandName("CloudPointWriteCommand");
        this.register(bCloudCommandsDeviceExt);
        this.device = (BCloudDevice)bCloudCommandsDeviceExt.getDevice();
    }

    @Override
    public void setCommandName(String cmdName) {
        this.commandName = cmdName;
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public void runCommand(JSONObject commandProperties, Map<String, Object> responseProperties, Context cx) {
        String messageId;
        block7: {
            messageId = (String)responseProperties.get(this.device.getConstant("CORRELATIONID"));
            log.fine(() -> String.format("%s executing %s", this.commandName, messageId));
            JSONObject payload = new JSONObject(JSONUtil.getString((JSONObject)commandProperties, (String)this.device.getConstant("COMMAND_PAYLOAD")));
            String pointId = JSONUtil.getString((JSONObject)payload, (String)this.device.getConstant("POINTID"));
            BControlPoint pxPoint = CloudUtilities.getPoint(pointId);
            String commandID = JSONUtil.getString((JSONObject)commandProperties, (String)this.device.getConstant("COMMANDID"));
            responseProperties.put(this.device.getConstant("COMMANDID"), commandID);
            if (pxPoint != null) {
                int priority = payload.optInt(this.device.getConstant("PRIORITY"), 0);
                BRelTime duration = BRelTime.makeMinutes((int)payload.optInt(this.device.getConstant("DURATION"), -1));
                String source = payload.optString(this.device.getConstant("SOURCE"), commandProperties.optString(this.device.getConstant("CALLINGID"), null));
                if (CloudUtilities.isPointWriteAllowed(this.device.getNiagaraCloudNetwork(), pxPoint, cx)) {
                    try {
                        if (BCloudPointDeviceExt.writePoint(pxPoint, payload.get(this.device.getConstant("VALUE")), priority, duration, source, messageId, cx)) {
                            responseProperties.put(pointId, "Success");
                            responseProperties.put(this.device.getConstant("RESPONSE_CODE"), this.device.getNumericConstant("CMD_RESP_CODE_OK"));
                            responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("RESP_OK"));
                            break block7;
                        }
                        responseProperties.put(pointId, "Fail");
                        responseProperties.put(this.device.getConstant("RESPONSE_CODE"), this.device.getNumericConstant("CMD_ERR_CODE_GENERAL"));
                        responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), "Error: Invalid point value.");
                    }
                    catch (PermissionException ignored) {
                        this.handleForbiddenResponse(responseProperties, pointId, "access not allowed", messageId);
                    }
                } else {
                    this.handleForbiddenResponse(responseProperties, pointId, "access not allowed", messageId);
                }
            } else {
                this.handleForbiddenResponse(responseProperties, pointId, "access not allowed", messageId);
            }
        }
        log.fine(() -> String.format("%s complete %s", this.commandName, messageId));
    }

    private void handleForbiddenResponse(Map<String, Object> responseProperties, String pointId, String detail, String messageId) {
        log.warning(() -> String.format("Attempted to write to Point failed: %s %s", detail, messageId));
        responseProperties.put(pointId, "Fail");
        responseProperties.put(this.device.getConstant("RESPONSE_CODE"), this.device.getNumericConstant("CMD_ERR_CODE_FORBIDDEN"));
        responseProperties.put(this.device.getConstant("ERROR_MESSAGE"), this.device.getConstant("ERR_ACCESS_NOT_ALLOWED"));
    }
}

