/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.devices.sentience;

import com.tridium.cloud.client.NiagaraMessageType;
import com.tridium.json.JSONStringer;
import com.tridium.json.JSONWriter;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.devices.CloudEncodeMsg;
import com.tridium.nc.devices.sentience.SentienceCloudUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SentienceRegisterCmdRequestV1
implements CloudEncodeMsg {
    private final BCloudDevice cloudConnectorDevice;
    private final List<RegisterCommandTypes> commands;
    public static final String command = "RegisterCommandsRequest";
    public static final String version = "1";

    SentienceRegisterCmdRequestV1(List<RegisterCommandTypes> commands, BCloudDevice cloudConnectorDevice) {
        this.commands = commands != null ? new ArrayList<RegisterCommandTypes>(commands) : new ArrayList();
        this.cloudConnectorDevice = cloudConnectorDevice;
    }

    @Override
    public String encode(Map<String, Object> properties) {
        JSONStringer writer = new JSONStringer();
        writer.object();
        writer.key("RegisterCommands");
        writer.array();
        this.commands.forEach(arg_0 -> this.lambda$encode$0((JSONWriter)writer, arg_0));
        writer.endArray();
        writer.endObject();
        return writer.toString();
    }

    @Override
    public Map<String, String> getProperties(Map<String, Object> properties) {
        Map<String, String> props = SentienceCloudUtilities.buildProperties(command, version, this.cloudConnectorDevice.resolveConnector().getId());
        props.put("NiagaraMessageType", NiagaraMessageType.cmdResp.name());
        return props;
    }

    private void getCommandFromType(JSONWriter writer, RegisterCommandTypes type) {
        switch (type) {
            case ALARM_ACK: {
                this.writeCommand(writer, "AlarmAckRequest", "2");
                break;
            }
            case POINT_READ_REQUEST: {
                this.writeCommand(writer, "PointReadCommand", version);
                break;
            }
            case POINT_WRITE_REQUEST: {
                this.writeCommand(writer, "PointWriteCommand", version);
                break;
            }
            case MULTI_POINT_READ_REQUEST: {
                this.writeCommand(writer, "MultiPointReadCommand", version);
                break;
            }
            case MULTI_POINT_WRITE_REQUEST: {
                this.writeCommand(writer, "MultiPointWriteCommand", version);
                break;
            }
            case SYSTEM_COMMAND_REQUEST: {
                this.writeCommand(writer, "SystemCommand", version);
            }
        }
    }

    private void writeCommand(JSONWriter writer, String type, String version) {
        writer.object();
        writer.key("CommandType").value((Object)type);
        writer.key("Version").value((Object)version);
        writer.endObject();
    }

    @Override
    public String getCommand() {
        return command;
    }

    private /* synthetic */ void lambda$encode$0(JSONWriter writer, RegisterCommandTypes cmd) {
        this.getCommandFromType(writer, cmd);
    }

    public static enum RegisterCommandTypes {
        ALARM_ACK,
        POINT_READ_REQUEST,
        POINT_WRITE_REQUEST,
        MULTI_POINT_READ_REQUEST,
        MULTI_POINT_WRITE_REQUEST,
        SYSTEM_COMMAND_REQUEST;

    }
}

