/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.devices.sentience.events;

import com.tridium.cloud.client.BConnectorImpl;
import com.tridium.cloud.client.BICloudConnector;
import com.tridium.cloud.client.sentience.BSentienceConnectorImpl;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.devices.sentience.events.AnnotationBody;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.baja.data.BIDataValue;
import javax.baja.event.BEvent;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;

public class EventData {
    private String createdTime;
    private String creatorId;
    private String creatorType;
    private String eventType;
    private final String generatorId;
    private final String generatorType;
    private String id;
    private String targetContext;
    private String targetId;
    private String targetType;
    private final AnnotationBody body;
    private final Map<String, String> bodyProperties = new HashMap<String, String>();
    public static final String CREATOR_ID_NIAGARA = "NiagaraFramework";
    public static final String CREATOR_TYPE_NIAGARA = "Niagara4";
    public static final String GENERATOR_TYPE_NIAGARA = "NiagaraCloudConnector";
    public static final String PROP_CREATED_TIME = "createdTime";
    public static final String PROP_CREATOR_ID = "creatorId";
    public static final String PROP_CREATOR_TYPE = "creatorType";
    public static final String PROP_EVENT_TYPE = "eventType";
    public static final String PROP_ID = "id";
    public static final String PROP_TARGET_CONTEXT = "targetContext";
    public static final String PROP_TARGET_ID = "targetId";
    public static final String PROP_TARGET_TYPE = "targetType";
    public static final Set<String> OVERRIDE_PROPS = new HashSet<String>();
    public static final String EVENT_UUID = "EventUuid";
    public static final String EVENT_TIMESTAMP = "EventTimestamp";
    public static final String EVENT_SOURCE = "EventSource";
    public static final String EVENT_VALUE = "EventValue";
    public static final String DOT = ".";
    public static final BFacets TS_FACETS;

    public EventData(BEvent event, BICloudConnector connector) {
        this.createdTime = event.getTimestamp().encodeToString();
        this.creatorId = CREATOR_ID_NIAGARA;
        this.creatorType = CREATOR_TYPE_NIAGARA;
        this.eventType = "BEvent";
        this.generatorId = connector.getId();
        this.generatorType = GENERATOR_TYPE_NIAGARA;
        this.id = event.getUuid().toString();
        this.targetContext = "BOrdList";
        this.targetId = event.getSource().toString();
        this.targetType = "BEvent";
        this.checkForExternalValues(event);
        this.body = null;
        this.buildBodyProperties(event);
    }

    public EventData(String id, String createdTime, String generatorId, String targetId, String targetContext, JSONObject body, Map<String, String> bodyProperties, String eventType) {
        this.id = id;
        this.createdTime = createdTime;
        this.creatorId = CREATOR_ID_NIAGARA;
        this.creatorType = CREATOR_TYPE_NIAGARA;
        this.generatorId = generatorId;
        this.generatorType = GENERATOR_TYPE_NIAGARA;
        this.targetId = targetId;
        this.targetType = "Device";
        this.targetContext = targetContext;
        this.body = new AnnotationBody(body);
        if (bodyProperties != null) {
            this.bodyProperties.putAll(bodyProperties);
        }
        this.eventType = eventType;
    }

    public void encode(JSONWriter writer, BCloudDevice device) {
        writer.object();
        writer.key("Id").value((Object)this.id);
        writer.key("CreatedTime").value((Object)this.createdTime);
        writer.key("CreatorId").value((Object)this.creatorId);
        writer.key("CreatorType").value((Object)this.creatorType);
        writer.key("GeneratorId").value((Object)this.generatorId);
        writer.key("GeneratorType").value((Object)this.generatorType);
        writer.key("TargetId").value((Object)this.targetId);
        writer.key("TargetType").value((Object)this.targetType);
        writer.key("TargetContext").value((Object)this.targetContext);
        writer.key("Body");
        this.writeBody(writer);
        writer.key("BodyProperties");
        this.writeBodyProperties(writer, device);
        writer.key("EventType").value((Object)this.eventType);
        writer.endObject();
    }

    private void writeBody(JSONWriter writer) {
        if (this.body != null) {
            writer.object();
            writer.key("Type").value((Object)this.getBodyType());
            writer.key("Value").value((Object)this.getBodyData());
            writer.key("Format").value((Object)this.getBodyFormat());
            writer.endObject();
        } else {
            writer.value(null);
        }
    }

    private void writeBodyProperties(JSONWriter writer, BCloudDevice device) {
        BICloudConnector connector;
        BConnectorImpl conImpl;
        writer.array();
        if (this.bodyProperties != null) {
            this.getBodyProperties().forEach((key, value) -> {
                writer.object();
                writer.key("Key").value(key);
                writer.key("Value").value(value);
                writer.endObject();
            });
        }
        if ((conImpl = (connector = device.resolveConnector()).getConnectorImpl()) instanceof BSentienceConnectorImpl) {
            writer.object();
            writer.key("Key").value((Object)"SystemType");
            writer.key("Value").value((Object)((BSentienceConnectorImpl)conImpl).getSystemType());
            writer.endObject();
        }
        writer.endArray();
    }

    private String getBodyType() {
        return this.body.getType().getType();
    }

    private String getBodyData() {
        return this.body.getBody();
    }

    private String getBodyFormat() {
        return this.body.getFormat().getFormat();
    }

    private Map<String, String> getBodyProperties() {
        return this.bodyProperties;
    }

    protected void checkForExternalValues(BEvent event) {
        BValue value = event.getValue();
        if (value.isComplex()) {
            BComplex valCpx = value.asComplex();
            Optional.ofNullable(valCpx.get(PROP_CREATED_TIME)).ifPresent(v -> {
                this.createdTime = v.toString((Context)TS_FACETS);
            });
            Optional.ofNullable(valCpx.get(PROP_CREATOR_ID)).ifPresent(v -> {
                this.creatorId = Objects.toString(v);
            });
            Optional.ofNullable(valCpx.get(PROP_CREATOR_TYPE)).ifPresent(v -> {
                this.creatorType = Objects.toString(v);
            });
            Optional.ofNullable(valCpx.get(PROP_EVENT_TYPE)).ifPresent(v -> {
                this.eventType = Objects.toString(v);
            });
            Optional.ofNullable(valCpx.get(PROP_ID)).ifPresent(v -> {
                this.id = Objects.toString(v);
            });
            Optional.ofNullable(valCpx.get(PROP_TARGET_CONTEXT)).ifPresent(v -> {
                this.targetContext = Objects.toString(v);
            });
            Optional.ofNullable(valCpx.get(PROP_TARGET_ID)).ifPresent(v -> {
                this.targetId = Objects.toString(v);
            });
            Optional.ofNullable(valCpx.get(PROP_TARGET_TYPE)).ifPresent(v -> {
                this.targetType = Objects.toString(v);
            });
        }
    }

    protected void buildBodyProperties(BEvent event) {
        this.bodyProperties.put(EVENT_UUID, event.getUuid().toString());
        this.bodyProperties.put(EVENT_TIMESTAMP, event.getTimestamp().toString((Context)TS_FACETS));
        this.bodyProperties.put(EVENT_SOURCE, event.getSource().toString());
        BValue eventValue = event.getValue();
        this.bodyProperties.put(EVENT_VALUE, Objects.toString(eventValue));
        if (eventValue.isComplex()) {
            SlotCursor props = eventValue.asComplex().getProperties();
            while (props.next()) {
                if (OVERRIDE_PROPS.contains(props.property().getName())) continue;
                BValue v = props.get();
                if (v.isComplex()) {
                    this.putComplexBodyProperty(props.property().getName(), v.asComplex());
                    continue;
                }
                this.bodyProperties.put(props.property().getName(), Objects.toString(v));
            }
        }
    }

    protected void putComplexBodyProperty(String parentName, BComplex cpx) {
        cpx.getProperties().stream().forEach(p -> {
            BValue v = cpx.get(p);
            if (v.isComplex()) {
                this.putComplexBodyProperty(parentName + DOT + p.getName(), v.asComplex());
            } else {
                this.bodyProperties.put(parentName + DOT + p.getName(), Objects.toString(v));
            }
        });
    }

    static {
        OVERRIDE_PROPS.addAll(Arrays.asList(PROP_CREATED_TIME, PROP_CREATOR_ID, PROP_CREATOR_TYPE, PROP_EVENT_TYPE, PROP_ID, PROP_TARGET_CONTEXT, PROP_TARGET_ID, PROP_TARGET_TYPE));
        TS_FACETS = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE, (String)"showMilliseconds", (BIDataValue)BBoolean.TRUE);
    }
}

