/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.devices.sentience.history;

import com.tridium.cloud.client.BICloudConnector;
import com.tridium.cloud.client.NiagaraMessageType;
import com.tridium.json.JSONStringer;
import com.tridium.json.JSONWriter;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.devices.CloudEncodeMsg;
import com.tridium.nc.devices.CloudPointData;
import com.tridium.nc.devices.sentience.history.HistorySample;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.baja.collection.TableCursor;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BTrendRecord;

public class SentienceHistoryUpdateV1
implements CloudEncodeMsg {
    public static final String command = "HistoryUpdateMessage";
    public static final String version = "1";
    private final BCloudDevice cloudConnectorDevice;
    private final NiagaraMessageType messageType;

    public SentienceHistoryUpdateV1(BCloudDevice cloudConnectorDevice, NiagaraMessageType messageType) {
        this.cloudConnectorDevice = cloudConnectorDevice;
        this.messageType = messageType;
    }

    @Override
    public String encode(Map<String, Object> properties) {
        List pointData = (List)properties.get("PointValues");
        JSONStringer writer = new JSONStringer();
        writer.object();
        writer.key("HistorySamples");
        writer.array();
        pointData.forEach(arg_0 -> SentienceHistoryUpdateV1.lambda$encode$0((JSONWriter)writer, arg_0));
        writer.endArray();
        writer.endObject();
        return writer.toString();
    }

    public String encode(TableCursor<BHistoryRecord> pointData) {
        JSONStringer writer = new JSONStringer();
        writer.object();
        writer.key("HistorySamples");
        writer.array();
        for (BHistoryRecord record : pointData) {
            if (!(record instanceof BTrendRecord)) continue;
            HistorySample historyData = new HistorySample();
            historyData.decode(record);
            historyData.encode((JSONWriter)writer);
        }
        writer.endArray();
        writer.endObject();
        return writer.toString();
    }

    @Override
    public Map<String, String> getProperties(Map<String, Object> properties) {
        BICloudConnector connector = this.cloudConnectorDevice.resolveConnector();
        HashMap<String, String> props = new HashMap<String, String>(8);
        props.put("ObjectType", command);
        props.put("ObjectVersion", version);
        props.put("SystemGuid", connector.getId());
        props.put("From", connector.getId());
        props.put("NiagaraMessageType", this.messageType.name());
        return props;
    }

    @Override
    public String getCommand() {
        return command;
    }

    private static /* synthetic */ void lambda$encode$0(JSONWriter writer, CloudPointData point) {
        point.encode(writer);
    }
}

