/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.devices.sentience.points;

import com.tridium.cloud.client.NiagaraMessageType;
import com.tridium.json.JSONStringer;
import com.tridium.json.JSONWriter;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.devices.CloudEncodeMsg;
import com.tridium.nc.devices.CloudPointData;
import com.tridium.nc.devices.sentience.SentienceCloudUtilities;
import com.tridium.nc.devices.sentience.points.CloudMultiPointData;
import java.util.List;
import java.util.Map;

public class SentienceMultiWriteResponseV1
implements CloudEncodeMsg {
    private final BCloudDevice cloudConnectorDevice;
    public static final String command = "MultiPointWriteResponse";
    public static final String version = "1";

    public SentienceMultiWriteResponseV1(BCloudDevice cloudConnectorDevice) {
        this.cloudConnectorDevice = cloudConnectorDevice;
    }

    @Override
    public String encode(Map<String, Object> properties) {
        List cloudPointDataList = (List)properties.get("PointValues");
        JSONStringer writer = new JSONStringer();
        writer.object();
        writer.key("PointWriteDetails");
        writer.array();
        for (CloudPointData data : cloudPointDataList) {
            CloudMultiPointData multiData = (CloudMultiPointData)data;
            multiData.encode((JSONWriter)writer);
        }
        writer.endArray();
        writer.endObject();
        return writer.toString();
    }

    @Override
    public Map<String, String> getProperties(Map<String, Object> properties) {
        Map<String, String> props = SentienceCloudUtilities.buildProperties(command, version, this.cloudConnectorDevice.resolveConnector().getId());
        props.put("MessageContentType", "application/json");
        props.put("CorrelationId", (String)properties.get("CorrelationId"));
        props.put("NiagaraMessageType", NiagaraMessageType.cmdResp.name());
        return props;
    }

    @Override
    public String getCommand() {
        return command;
    }
}

