/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.events;

import com.tridium.cloud.client.BICloudConnector;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.CloudUtilities;
import com.tridium.nc.devices.CloudEncodeMsg;
import com.tridium.nc.devices.sentience.events.EventData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.data.BIDataValue;
import javax.baja.event.BEvent;
import javax.baja.event.BEventRecipient;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="device", type="BOrd", defaultValue="BOrd.NULL", facets={@Facet(name="BFacets.TARGET_TYPE", value="BString.make(\"baja:Component\")")}), @NiagaraProperty(name="enableBatchEvents", type="boolean", defaultValue="false", facets={@Facet(name="BFacets.TRUE_TEXT", value="\"%lexicon(nCloudDriver:events.batch.enabled)%\""), @Facet(name="BFacets.FALSE_TEXT", value="\"%lexicon(nCloudDriver:events.batch.disabled)%\"")}), @NiagaraProperty(name="eventBatchDelay", type="BRelTime", defaultValue="BRelTime.make(30000)"), @NiagaraProperty(name="eventBatchSize", type="int", defaultValue="100", facets={@Facet(name="BFacets.MIN", value="2"), @Facet(name="BFacets.MAX", value="512")}), @NiagaraProperty(name="sendFailWarnInterval", type="BRelTime", defaultValue="BRelTime.makeHours(1)", flags=5), @NiagaraProperty(name="lastSentToCloud", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=257)})
@NiagaraAction(name="sendBatchEvents", flags=4)
public class BCloudEventRecipient
extends BEventRecipient {
    public static final Property device = BCloudEventRecipient.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"baja:Component")));
    public static final Property enableBatchEvents = BCloudEventRecipient.newProperty((int)0, (boolean)false, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)"%lexicon(nCloudDriver:events.batch.enabled)%"), (BFacets)BFacets.make((String)"falseText", (String)"%lexicon(nCloudDriver:events.batch.disabled)%")));
    public static final Property eventBatchDelay = BCloudEventRecipient.newProperty((int)0, (BValue)BRelTime.make((long)30000L), null);
    public static final Property eventBatchSize = BCloudEventRecipient.newProperty((int)0, (int)100, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)2), (BFacets)BFacets.make((String)"max", (int)512)));
    public static final Property sendFailWarnInterval = BCloudEventRecipient.newProperty((int)5, (BValue)BRelTime.makeHours((int)1), null);
    public static final Property lastSentToCloud = BCloudEventRecipient.newProperty((int)257, (BValue)BAbsTime.NULL, null);
    public static final Action sendBatchEvents = BCloudEventRecipient.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BCloudEventRecipient.class);
    private volatile AtomicReference<BICloudConnector> connector = new AtomicReference();
    private volatile AtomicReference<BCloudDevice> resolvedDevice = new AtomicReference();
    private int pendingEventCount;
    private BEvent[] pendingEvents;
    private BAbsTime lastSendFailTime;
    private Clock.Ticket eventSendTicket;
    private boolean eventSendFailLogFlag;
    private static final ReentrantLock eventBatchLock = new ReentrantLock();
    private static final BIcon icon = BIcon.make((BIcon)BIcon.make((String)"module://event/icons/eventService.png"), (BIcon)BIcon.make((String)"module://event/icons/eventBadge.png"));
    private static final Logger log = Logger.getLogger("ncloud.event");
    private static final Lexicon lexicon = Lexicon.make((String)"nCloudDriver");

    public BOrd getDevice() {
        return (BOrd)this.get(device);
    }

    public void setDevice(BOrd v) {
        this.set(device, (BValue)v, null);
    }

    public boolean getEnableBatchEvents() {
        return this.getBoolean(enableBatchEvents);
    }

    public void setEnableBatchEvents(boolean v) {
        this.setBoolean(enableBatchEvents, v, null);
    }

    public BRelTime getEventBatchDelay() {
        return (BRelTime)this.get(eventBatchDelay);
    }

    public void setEventBatchDelay(BRelTime v) {
        this.set(eventBatchDelay, (BValue)v, null);
    }

    public int getEventBatchSize() {
        return this.getInt(eventBatchSize);
    }

    public void setEventBatchSize(int v) {
        this.setInt(eventBatchSize, v, null);
    }

    public BRelTime getSendFailWarnInterval() {
        return (BRelTime)this.get(sendFailWarnInterval);
    }

    public void setSendFailWarnInterval(BRelTime v) {
        this.set(sendFailWarnInterval, (BValue)v, null);
    }

    public BAbsTime getLastSentToCloud() {
        return (BAbsTime)this.get(lastSentToCloud);
    }

    public void setLastSentToCloud(BAbsTime v) {
        this.set(lastSentToCloud, (BValue)v, null);
    }

    public void sendBatchEvents() {
        this.invoke(sendBatchEvents, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.setupConnector();
        if (this.getLastSentToCloud() == BAbsTime.NULL) {
            this.setLastSentToCloud(BAbsTime.now());
        }
        if (this.getEnableBatchEvents()) {
            this.pendingEvents = new BEvent[this.getEventBatchSize()];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(Property prop, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(device)) {
            this.resolvedDevice = new AtomicReference();
            this.setupConnector();
        }
        if (enableBatchEvents.equals(prop)) {
            if (this.getEnableBatchEvents()) {
                this.pendingEvents = new BEvent[this.getEventBatchSize()];
                this.pendingEventCount = 0;
            } else if (this.pendingEventCount > 0) {
                this.doSendBatchEvents();
                this.pendingEvents = null;
            }
        } else if (eventBatchSize.equals(prop)) {
            if (this.pendingEventCount > this.getEventBatchSize()) {
                this.doSendBatchEvents();
            }
            BEvent[] tmpEvents = new BEvent[this.getEventBatchSize()];
            eventBatchLock.lock();
            try {
                System.arraycopy(this.pendingEvents, 0, tmpEvents, 0, this.pendingEventCount);
                this.pendingEvents = tmpEvents;
            }
            finally {
                eventBatchLock.unlock();
            }
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void eventReceived(BEvent event) {
        if (this.resolvedDevice.get() == null || this.connector.get() == null) {
            this.setupConnector();
        }
        if (this.resolvedDevice.get() == null) {
            log.warning(String.format("CloudLink Event Recipient %s has no Cloud Device configured", this.getDisplayName(null)));
            this.clearPendingEvents();
            this.eventSendFailLogFlag = true;
            this.lastSendFailTime = BAbsTime.now();
            return;
        }
        if (!this.resolvedDevice.get().isFatalFault()) {
            if (this.connector.get() == null || !this.connector.get().isConnected()) {
                if (!this.eventSendFailLogFlag) {
                    log.warning("Cannot send events while the cloud connector is disconnected.");
                }
                this.clearPendingEvents();
                this.eventSendFailLogFlag = true;
                this.lastSendFailTime = BAbsTime.now();
                return;
            }
            if (this.getEnableBatchEvents()) {
                eventBatchLock.lock();
                try {
                    if (this.eventSendTicket == null) {
                        this.eventSendTicket = Clock.schedule((BComponent)this, (BRelTime)this.getEventBatchDelay(), (Action)sendBatchEvents, null);
                    }
                    this.pendingEvents[this.pendingEventCount++] = event;
                    if (this.pendingEventCount < this.getEventBatchSize()) return;
                    this.doSendBatchEvents();
                    return;
                }
                finally {
                    if (eventBatchLock.isHeldByCurrentThread()) {
                        eventBatchLock.unlock();
                    }
                }
            } else {
                this.sendEvent(event);
            }
            return;
        } else {
            log.severe(lexicon.getText("events.noLicense"));
        }
    }

    private void setupConnector() {
        this.resolvedDevice.compareAndSet(null, this.getCloudDevice());
        this.connector.set(this.resolvedDevice.get() != null ? this.resolvedDevice.get().resolveConnector() : this.connector.get());
    }

    public final BCloudDevice getCloudDevice() {
        try {
            if (!this.getDevice().isNull()) {
                return (BCloudDevice)this.getDevice().get();
            }
        }
        catch (ClassCastException | UnresolvedException cce) {
            log.warning(String.format("Cloud Event Recipient %s has an invalid ord; the ord must point to a Cloud Device.", this.getDisplayName(null)));
        }
        return null;
    }

    private void clearPendingEvents() {
        if (this.eventSendTicket != null) {
            this.eventSendTicket.cancel();
            this.eventSendTicket = null;
        }
        for (int lcv = 0; lcv < this.pendingEventCount; ++lcv) {
            this.pendingEvents[lcv] = null;
        }
        this.pendingEventCount = 0;
    }

    private void sendEvent(BEvent event) {
        if (this.connector == null) {
            this.setupConnector();
        }
        if (CloudUtilities.canSendMessage(this.getCloudDevice())) {
            CloudEncodeMsg eventMsg = this.resolvedDevice.get().getFactory().createNewEventRequestMsg();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            ArrayList<EventData> events = new ArrayList<EventData>();
            EventData eventData = new EventData(event, this.connector.get());
            events.add(eventData);
            properties.put(this.getCloudDevice().getConstant("EVENTS"), events);
            BAbsTime lastUpdate = BAbsTime.now();
            CompletionStage future = this.connector.get().sendMessage(eventMsg.encode(properties), eventMsg.getProperties(null)).whenComplete((resp, err) -> {
                if (err != null) {
                    if (this.lastSendFailTime == null || BAbsTime.now().getMillis() - this.lastSendFailTime.getMillis() > this.getSendFailWarnInterval().getMillis()) {
                        this.lastSendFailTime = BAbsTime.now();
                        log.warning("Failed to send event message to cloud.");
                    } else {
                        log.config("Failed to send event message to cloud.");
                    }
                } else {
                    this.lastSendFailTime = null;
                    this.setLastSentToCloud(lastUpdate);
                    log.fine("Event message sent to cloud successfully.");
                    this.eventSendFailLogFlag = false;
                }
            });
            if (((CompletableFuture)future).isCompletedExceptionally()) {
                try {
                    ((CompletableFuture)future).get();
                }
                catch (ExecutionException e) {
                    if ("Queue full, try again later.".equals(e.getCause().getMessage())) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ignored) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public void doSendBatchEvents() {
        BEvent[] events;
        if (this.resolvedDevice == null || this.connector == null) {
            this.setupConnector();
        }
        if (this.connector == null || !this.connector.get().isConnected()) {
            log.warning(lexicon.getText("events.noConnection"));
            this.clearPendingEvents();
            return;
        }
        if (!eventBatchLock.isHeldByCurrentThread()) {
            eventBatchLock.lock();
        }
        try {
            events = new BEvent[this.pendingEventCount];
            System.arraycopy(this.pendingEvents, 0, events, 0, this.pendingEventCount);
            this.clearPendingEvents();
        }
        finally {
            eventBatchLock.unlock();
        }
        CloudEncodeMsg eventsMsg = this.resolvedDevice.get().getFactory().createNewEventRequestMsg();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ArrayList eventDatas = Arrays.stream(events).map(event -> new EventData((BEvent)event, this.connector.get())).collect(Collectors.toCollection(ArrayList::new));
        properties.put(this.getCloudDevice().getConstant("EVENTS"), eventDatas);
        BAbsTime lastUpdate = BAbsTime.now();
        CompletionStage future = this.connector.get().sendMessage(eventsMsg.encode(properties), eventsMsg.getProperties(null)).whenComplete((resp, err) -> {
            if (err != null) {
                if (this.lastSendFailTime == null || BAbsTime.now().getMillis() - this.lastSendFailTime.getMillis() > this.getSendFailWarnInterval().getMillis()) {
                    this.lastSendFailTime = BAbsTime.now();
                    log.warning("Failed to send event message to cloud.");
                } else {
                    log.config("Failed to send event message to cloud.");
                }
            } else {
                this.lastSendFailTime = null;
                this.setLastSentToCloud(lastUpdate);
                log.fine(() -> String.format("Event message sent to cloud successfully; event count=%s", eventDatas.size()));
                this.eventSendFailLogFlag = false;
            }
        });
        if (((CompletableFuture)future).isCompletedExceptionally()) {
            try {
                ((CompletableFuture)future).get();
            }
            catch (ExecutionException e) {
                if ("Queue full, try again later.".equals(e.getCause().getMessage())) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ignored) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

