/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.history;

import com.tridium.history.audit.BAuditRecord;
import com.tridium.history.log.BLogRecord;
import com.tridium.nc.CloudUtilities;
import com.tridium.nc.devices.sentience.history.HistorySample;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.logging.Logger;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BTrendRecord;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BValue;

public final class HistoryUtil {
    private static final Logger log = Logger.getLogger("ncloud.history");
    public static final String TARGET = "Target:";
    public static final String OPERATION = ";Operation:";
    public static final String SLOT_NAME = ";SlotName:";
    public static final String OLD_VALUE = ";OldValue:";
    public static final String VALUE = ";Value:";
    public static final String USER_NAME = ";User Name:";
    public static final String LOG_NAME = "Log Name:";
    public static final String SEVERITY = ";Severity:";
    public static final String MESSAGE = ";Message:";
    public static final String EXCEPTION = ";Exception:";
    public static final String AUDIT_RECORD = "Audit Record";
    public static final String LOG_RECORD = "Log Record";

    private HistoryUtil() {
    }

    protected static HistorySample buildpointData(BHistoryRecord record, String pointId, OffsetDateTime timeStamp) {
        HistorySample pointData = null;
        if (record instanceof BTrendRecord) {
            BTrendRecord trendRecord = (BTrendRecord)record;
            BValue value = trendRecord.get("value");
            pointData = new HistorySample(pointId, CloudUtilities.toStatusString(trendRecord.getStatus()), timeStamp.toString(), HistoryUtil.getStringValue(value));
        } else if (record instanceof BAuditRecord) {
            BAuditRecord auditRecord = (BAuditRecord)record;
            String auditBuilder = TARGET + auditRecord.getTarget() + OPERATION + auditRecord.getOperation() + SLOT_NAME + auditRecord.getSlotName() + OLD_VALUE + auditRecord.getOldValue() + VALUE + auditRecord.getValue() + USER_NAME + auditRecord.getUserName();
            pointData = new HistorySample(pointId, AUDIT_RECORD, timeStamp.toString(), auditBuilder);
        } else if (record instanceof BLogRecord) {
            BLogRecord logRecord = (BLogRecord)record;
            String logBuilder = LOG_NAME + logRecord.getLogName() + SEVERITY + String.valueOf(logRecord.getSeverity()) + MESSAGE + logRecord.getMessage() + EXCEPTION + logRecord.getException();
            pointData = new HistorySample(pointId, LOG_RECORD, timeStamp.toString(), logBuilder);
        }
        return pointData;
    }

    public static String getStringValue(BValue value) {
        if (value instanceof BDouble) {
            BDouble doubleValue = (BDouble)value;
            try {
                return doubleValue.encodeToString();
            }
            catch (IOException e) {
                log.warning("Unable to encode double value to string: " + e.getMessage());
                return "";
            }
        }
        if (value instanceof BFloat) {
            BFloat floatValue = (BFloat)value;
            try {
                return floatValue.encodeToString();
            }
            catch (IOException e) {
                log.warning("Unable to encode float value to string: " + e.getMessage());
                return "";
            }
        }
        return value.toString();
    }
}

