/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.point;

import com.tridium.cloud.client.BICloudConnector;
import com.tridium.driver.util.DrUtil;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.BNiagaraCloudNetwork;
import com.tridium.nc.CloudUtilities;
import com.tridium.nc.cmds.BCloudWriteInfo;
import com.tridium.nc.devices.CloudEncodeMsg;
import com.tridium.nc.devices.CloudPointData;
import com.tridium.nc.devices.sentience.history.HistorySample;
import com.tridium.nc.history.HistoryUtil;
import com.tridium.nc.point.BCloudPointDeviceExt;
import com.tridium.nc.point.BCloudTuningPolicy;
import com.tridium.nc.point.BCloudWriteController;
import com.tridium.nc.point.BPointInputs;
import com.tridium.nc.point.BSetCovParameter;
import com.tridium.ndriver.point.BNProxyExt;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.util.CompUtil;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnitConversion;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3, facets={@Facet(value="SfUtil.incl(SfUtil.MGR_UNSEEN)")}, override=true), @NiagaraProperty(name="ordPath", type="BOrd", defaultValue="BOrd.DEFAULT", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)")}), @NiagaraProperty(name="pointId", type="String", defaultValue="", flags=3, facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT_READONLY)")}), @NiagaraProperty(name="cloudWriteValue", type="BStatusValue", defaultValue="new BStatusString(\"-\", BStatus.nullStatus)", flags=5), @NiagaraProperty(name="tuningPolicyName", type="String", defaultValue="defaultPolicy", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)"), @Facet(value="TUNING_POLICY_NAME_FACETS")}, override=true), @NiagaraProperty(name="stationPointInput", type="BPointInputs", defaultValue="BPointInputs.DEFAULT", flags=5), @NiagaraProperty(name="isCovActive", type="boolean", defaultValue="false", flags=3, facets={@Facet(value="SfUtil.incl()"), @Facet(name="BFacets.TRUE_TEXT", value="lexicon.getText(\"point.covActive\")"), @Facet(name="BFacets.FALSE_TEXT", value="lexicon.getText(\"point.covInactive\")")}), @NiagaraProperty(name="lastSentToCloud", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=65537, facets={@Facet(value="SfUtil.incl()")})})
@NiagaraAction(name="clearCloudCommand", flags=4)
public class BCloudProxyExt
extends BNProxyExt
implements BIPollable {
    private static final Lexicon lexicon = Lexicon.make((String)"nCloudDriver");
    public static final Property faultCause = BCloudProxyExt.newProperty((int)3, (String)"", (BFacets)SfUtil.incl((String)"un"));
    public static final Property ordPath = BCloudProxyExt.newProperty((int)0, (BValue)BOrd.DEFAULT, (BFacets)SfUtil.incl((String)"ed"));
    public static final Property pointId = BCloudProxyExt.newProperty((int)3, (String)"", (BFacets)SfUtil.incl((String)"ed.ro"));
    public static final Property cloudWriteValue = BCloudProxyExt.newProperty((int)5, (BValue)new BStatusString("-", BStatus.nullStatus), null);
    public static final Property tuningPolicyName = BCloudProxyExt.newProperty((int)0, (String)"defaultPolicy", (BFacets)BFacets.make((BFacets)SfUtil.incl((String)"ed"), (BFacets)TUNING_POLICY_NAME_FACETS));
    public static final Property stationPointInput = BCloudProxyExt.newProperty((int)5, (BValue)BPointInputs.DEFAULT, null);
    public static final Property isCovActive = BCloudProxyExt.newProperty((int)3, (boolean)false, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)SfUtil.incl(), (BFacets)BFacets.make((String)"trueText", (String)lexicon.getText("point.covActive"))), (BFacets)BFacets.make((String)"falseText", (String)lexicon.getText("point.covInactive"))));
    public static final Property lastSentToCloud = BCloudProxyExt.newProperty((int)65537, (BValue)BAbsTime.NULL, (BFacets)SfUtil.incl());
    public static final Action clearCloudCommand = BCloudProxyExt.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BCloudProxyExt.class);
    private BControlPoint point;
    private BCloudWriteController writeController;
    private volatile boolean batchUpdateNeeded;
    public static final int POINT_STATUS_MASK = 6;
    public static final String COV_TO_CLOUD_PROP = "covToCloudValue";
    public static final String COV_LINK_PROP = "covLink";
    private static final CloudPointSubscriber cloudPointSubscriber = new CloudPointSubscriber();
    private static final Logger log = Logger.getLogger("ncloud.point");

    public BOrd getOrdPath() {
        return (BOrd)this.get(ordPath);
    }

    public void setOrdPath(BOrd v) {
        this.set(ordPath, (BValue)v, null);
    }

    public String getPointId() {
        return this.getString(pointId);
    }

    public void setPointId(String v) {
        this.setString(pointId, v, null);
    }

    public BStatusValue getCloudWriteValue() {
        return (BStatusValue)this.get(cloudWriteValue);
    }

    public void setCloudWriteValue(BStatusValue v) {
        this.set(cloudWriteValue, (BValue)v, null);
    }

    public BPointInputs getStationPointInput() {
        return (BPointInputs)this.get(stationPointInput);
    }

    public void setStationPointInput(BPointInputs v) {
        this.set(stationPointInput, (BValue)v, null);
    }

    public boolean getIsCovActive() {
        return this.getBoolean(isCovActive);
    }

    public void setIsCovActive(boolean v) {
        this.setBoolean(isCovActive, v, null);
    }

    public BAbsTime getLastSentToCloud() {
        return (BAbsTime)this.get(lastSentToCloud);
    }

    public void setLastSentToCloud(BAbsTime v) {
        this.set(lastSentToCloud, (BValue)v, null);
    }

    public void clearCloudCommand() {
        this.invoke(clearCloudCommand, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.getPoint();
        this.getWriteController();
        this.setPointId(CloudUtilities.makePointId(this));
        if (this.point != null && !this.getOrdPath().isNull()) {
            this.resolveFacets(this.point);
        }
        this.batchUpdateNeeded = true;
        if (!this.isDisabled() && !this.isFault() && this.getCloudTuningPolicy().getSubscribeSourcePoint()) {
            this.subscribeSourcePoint();
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        this.pointDeviceExt().unregisterPoint(this.point, this);
        this.pointDeviceExt().doSetCovInactive(BSetCovParameter.make(this.getPointId()), (Context)((BUserService)Sys.getService((Type)BUserService.TYPE)).getAdmin());
        if (!this.isFault() && this.getCloudTuningPolicy().getSubscribeSourcePoint()) {
            this.unsubscribeSourcePoint();
        }
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (this.isRunning()) {
            if (p.equals(status)) {
                this.updatePointSubscription();
                this.getWriteController().propagateStatusToWriteInfos(this);
            }
            if (p.equals(enabled)) {
                this.updatePointSubscription();
            } else if (p.equals(tuningPolicyName)) {
                this.updatePointSubscription();
            } else if (p.equals(ordPath)) {
                CloudUtilities.cloudWriteController(this.getParentPoint()).removeCloudWrites();
                this.pointDeviceExt().unregisterPoint(this.point, this);
                this.getPoint();
                this.setPointId(CloudUtilities.makePointId(this));
                if (this.point != null && !this.getOrdPath().isNull()) {
                    this.resolveFacets(this.point);
                }
            } else if (p.equals(isCovActive)) {
                if (this.getIsCovActive()) {
                    this.getTuning().writeDesired();
                }
            } else if (COV_TO_CLOUD_PROP == p.getName() && this.hasValueChanged((BStatusValue)this.get(p).as(BStatusValue.class))) {
                this.getTuning().writeDesired();
            }
        }
    }

    public void doClearCloudCommand(Context cx) {
        log.warning("Deprecated action clearCloudCommand() invoked on CloudProxyExt for " + this.getParentPoint().getName() + "; ignoring...");
    }

    public String toString(Context cx) {
        return this.getPointId();
    }

    public final BNiagaraCloudNetwork getNiagaraCloudNetwork() {
        return (BNiagaraCloudNetwork)this.getNetwork();
    }

    public final BCloudDevice getCloudDevice() {
        return (BCloudDevice)DrUtil.getParent((BComplex)this, (Type)BCloudDevice.TYPE);
    }

    public final BCloudPointDeviceExt getCloudPointDeviceExt() {
        return (BCloudPointDeviceExt)this.getDeviceExt();
    }

    public final BCloudTuningPolicy getCloudTuningPolicy() {
        return (BCloudTuningPolicy)this.getTuningPolicy();
    }

    public void checkStatusValueTypes() {
        super.checkStatusValueTypes();
        BControlPoint parent = this.getParentPoint();
        if (parent == null) {
            return;
        }
        BStatusValue out = parent.getOutStatusValue();
        BCloudWriteInfo[] writeInfos = (BCloudWriteInfo[])this.getChildren(BCloudWriteInfo.class);
        Arrays.stream(writeInfos).filter(writeInfo -> out.getType() != writeInfo.getValue().getType()).forEach(writeInfo -> {
            BStatusValue sv = (BStatusValue)out.getType().getInstance();
            sv.setStatusNull(true);
            writeInfo.setValue(sv);
        });
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)cloudWriteValue)) {
            return BFacets.make((BFacets)this.getDeviceFacets(), (String)"unitConversion", (BIDataValue)BDynamicEnum.make((BEnum)BUnitConversion.none));
        }
        return super.getSlotFacets(slot);
    }

    public void readSubscribed(Context cx) throws Exception {
    }

    public void readUnsubscribed(Context cx) throws Exception {
    }

    public boolean write(Context cx) throws Exception {
        if (this.getIsCovActive()) {
            this.sendCov(cx);
            return false;
        }
        this.batchUpdateNeeded = true;
        return false;
    }

    public Type getDeviceExtType() {
        return BCloudPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return BReadWriteMode.writeonly;
    }

    void addBatchUpdate(List<CloudPointData> toCloud) {
        if (this.getPoint() != null) {
            BStatusValue value = this.point.getOutStatusValue();
            if (!this.isDisabled() && (!this.requireChangeForUpdate() || this.hasValueChanged(value) || this.getParentPoint().getOutStatusValue().getStatus().isFault())) {
                this.addPointData(toCloud, value);
            }
        }
    }

    private void addPointData(List<CloudPointData> toCloud, BStatusValue value) {
        toCloud.add(new HistorySample(this.getPointId(), CloudUtilities.toStatusString(value.getStatus()), OffsetDateTime.now().toString(), HistoryUtil.getStringValue(value.getValueValue()), this));
        this.setWriteValue((BStatusValue)value.newCopy().as(BStatusValue.class));
    }

    @Deprecated
    public void writeFromCloud(BStatusValue cloudValue, Context cx) {
        log.warning("Deprecated method writeFromCloud() called on CloudProxyExt for " + this.getParentPoint().getName() + "; ignoring...");
    }

    private void sendCov(Context cx) {
        BICloudConnector connector = this.getCloudDevice().resolveConnector();
        if (CloudUtilities.canSendMessage(this.getCloudDevice())) {
            if (!this.isDisabled() && this.point != null) {
                BStatusValue value = this.point.getOutStatusValue();
                ArrayList<CloudPointData> list = new ArrayList<CloudPointData>();
                this.addPointData(list, value);
                if (!this.sendHistoryMessages(connector, list, value) && !this.sendHistoryMessages(connector, list, value)) {
                    String failure = String.format(lexicon.getText("point.couldNotSendCov"), this.getPointId(), this.getOrdPath());
                    log.warning(failure);
                    this.writeFail(failure);
                    return;
                }
                this.writeOk(value);
            } else {
                String failure = String.format(lexicon.getText("point.notConfigured"), this.getPointId(), this.getOrdPath());
                log.warning(failure);
                this.writeFail(failure);
            }
        } else {
            String failure = lexicon.getText("point.notConnected");
            log.warning(failure);
            this.writeFail(failure);
        }
    }

    public BPollFrequency getPollFrequency() {
        return ((BCloudTuningPolicy)this.getTuningPolicy()).getUpdateGroup();
    }

    private BCloudPointDeviceExt pointDeviceExt() {
        return (BCloudPointDeviceExt)CloudUtilities.getParent((BComponent)this, BCloudPointDeviceExt.TYPE);
    }

    public BControlPoint getPoint() {
        try {
            if (!this.getOrdPath().isNull()) {
                BObject obj = this.getOrdPath().get((BObject)this);
                if (obj instanceof BControlPoint) {
                    if (this.point == null) {
                        this.writeReset();
                        this.point = (BControlPoint)obj;
                        this.getTuning().writeDesired();
                    } else {
                        this.point = (BControlPoint)obj;
                    }
                } else {
                    this.writeFail("invalid ord path to exported point");
                    this.point = null;
                }
            } else {
                this.writeFail("null ord path to exported point");
                this.point = null;
            }
        }
        catch (UnresolvedException e) {
            this.writeFail("cannot resolve export ord path");
            this.point = null;
        }
        this.pointDeviceExt().registerPoint(this.point, this);
        return this.point;
    }

    public BStatusValue getPointValue() {
        log.fine(() -> String.format("getPointValue() on cldPx %s tgt=[%s]: out=%s", this.getPointId(), this.getOrdPath(), this.point.getOutStatusValue()));
        BStatusValue statusValue = (BStatusValue)this.point.getOutStatusValue().newCopy();
        this.getWriteController().updatePointRemoteActivePriority(statusValue);
        if (!this.point.isSubscribed()) {
            BStatus status = statusValue.getStatus();
            int newStatus = status.getStatus().getBits();
            statusValue.setStatus(newStatus |= 0x10);
        }
        this.point.lease(0, this.getCloudTuningPolicy().getPointSubscriptionPeriod().getMillis());
        log.finer(String.format("pointId: %s subscribed for %s minutes", this.point.getName(), this.getCloudTuningPolicy().getPointSubscriptionPeriod().getMinutes()));
        this.writeOk(statusValue);
        return statusValue;
    }

    private boolean requireChangeForUpdate() {
        return ((BCloudTuningPolicy)this.getTuningPolicy()).getRequireChangeForUpdate();
    }

    private double changeTolerance() {
        return ((BCloudTuningPolicy)this.getTuningPolicy()).getNumericChangeTolerance();
    }

    public void tuningChanged(BCloudTuningPolicy policy, Context cx) {
        if (policy == null || policy == this.getTuningPolicy()) {
            this.updatePointSubscription();
        }
    }

    private boolean hasValueChanged(BStatusValue value) {
        if (this.batchUpdateNeeded) {
            this.batchUpdateNeeded = false;
            return true;
        }
        BStatusValue lastValue = this.getWriteValue();
        if (!value.getStatus().equals((Object)lastValue.getStatus())) {
            return true;
        }
        Type valType = value.getType();
        if (valType == lastValue.getType()) {
            if (valType.is(BStatusNumeric.TYPE)) {
                return Math.abs(((BINumeric)value).getNumeric() - ((BINumeric)lastValue).getNumeric()) > this.changeTolerance();
            }
            return !value.equivalent((Object)lastValue);
        }
        return true;
    }

    void updatePointSubscription() {
        if (this.getPoint() != null) {
            if (!this.isDisabled() && !this.isFault()) {
                if (this.getCloudTuningPolicy().getSubscribeSourcePoint()) {
                    this.subscribeSourcePoint();
                } else {
                    this.unsubscribeSourcePoint();
                }
            } else {
                this.unsubscribeSourcePoint();
            }
        }
    }

    private BCloudWriteController getWriteController() {
        BValue v = this.getParentPoint().get("cloudWriteController");
        if (v instanceof BCloudWriteController) {
            this.writeController = (BCloudWriteController)v;
        } else {
            this.writeController = new BCloudWriteController();
            CompUtil.setOrAdd((BComponent)this.getParentPoint(), (String)"cloudWriteController", (BValue)this.writeController, (int)0, (BFacets)BFacets.DEFAULT, null);
        }
        return this.writeController;
    }

    private void resolveFacets(BControlPoint pt) {
        this.getParentPoint().setFacets(pt.getFacets());
    }

    private boolean sendHistoryMessages(BICloudConnector connector, ArrayList<CloudPointData> list, BStatusValue value) {
        CloudEncodeMsg ptHistoryMsg = this.getCloudDevice().getFactory().createHistoryUpdateMsg(this.getCloudTuningPolicy().getPriorityForCov().toMessageType());
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("PointValues", list);
        CompletionStage future = connector.sendMessage(ptHistoryMsg.encode(properties), ptHistoryMsg.getProperties(properties)).whenComplete((resp, err) -> {
            if (err != null) {
                log.warning(() -> String.format("Individual point update failed for %s:%s", this.getPointId(), err.getMessage()));
                this.writeFail(err.getMessage());
            } else {
                log.fine(() -> String.format("Sent individual point update for %s", this.getPointId()));
                this.writeOk(value);
                this.setLastSentToCloud(BAbsTime.now());
            }
        });
        if (((CompletableFuture)future).isCompletedExceptionally()) {
            try {
                ((CompletableFuture)future).get();
            }
            catch (ExecutionException e) {
                if ("Queue full, try again later.".equals(e.getCause().getMessage())) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ignored) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
            return false;
        }
        return true;
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("Cloud Proxy Ext");
        out.prop((Object)"point", (Object)BCloudProxyExt.spyStr((BComponent)this.point));
        out.prop((Object)"batchUpdateNeeded", this.batchUpdateNeeded);
        out.prop((Object)"writeController", (Object)BCloudProxyExt.spyStr(this.writeController));
        out.endProps();
        this.getWriteController().spy(out, false);
        super.spy(out);
    }

    private static String spyStr(BComponent c) {
        if (c == null) {
            return "null";
        }
        return c.getName() + " : " + c.getSlotPathOrd();
    }

    void subscribeSourcePoint() {
        cloudPointSubscriber.subscribe((BComponent)this.point);
    }

    void unsubscribeSourcePoint() {
        cloudPointSubscriber.unsubscribe((BComponent)this.point);
    }

    static class CloudPointSubscriber
    extends Subscriber {
        CloudPointSubscriber() {
        }

        public void event(BComponentEvent bComponentEvent) {
        }
    }
}

