/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.security;

import com.tridium.nc.security.BAbstractTrustMapping;
import com.tridium.nc.security.BCloudTrustManager;
import com.tridium.platcrypto.core.BCertManagerService;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.keys.resolvers.X509VerificationKeyResolver;

@NiagaraType
@NiagaraProperty(name="certificateAlias", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"workbench:CertificateAliasFE\")"), @Facet(name="BFacets.UX_FIELD_EDITOR", value="BString.make(\"webEditors:CertificateAliasEditor\")")})
public class BCertTrustMapping
extends BAbstractTrustMapping {
    public static final Property certificateAlias = BCertTrustMapping.newProperty((int)0, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:CertificateAliasFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:CertificateAliasEditor"))));
    public static final Type TYPE = Sys.loadType(BCertTrustMapping.class);
    protected static final Logger log = Logger.getLogger("ncloud.security");

    public String getCertificateAlias() {
        return this.getString(certificateAlias);
    }

    public void setCertificateAlias(String v) {
        this.setString(certificateAlias, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BCloudTrustManager;
    }

    @Override
    public VerificationKeyResolver getKeyResolver() {
        try {
            BCertManagerService service = (BCertManagerService)Sys.getService((Type)BCertManagerService.TYPE);
            X509Certificate certificate = service.getUserTrustStore().getCertificate(this.getCertificateAlias());
            if (certificate != null) {
                certificate.checkValidity();
                X509VerificationKeyResolver resolver = new X509VerificationKeyResolver(new X509Certificate[]{certificate});
                resolver.setTryAllOnNoThumbHeader(true);
                return resolver;
            }
            log.warning("Trust store mapping certificate " + this.getCertificateAlias() + " not found.");
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Trust store mapping certificate verification failed for " + this.getCertificateAlias(), e);
        }
        return null;
    }
}

