/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.security;

import com.tridium.nc.CloudUtilities;
import com.tridium.nc.security.BUserMapping;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;

@NiagaraType
@NiagaraProperty(name="enabled", type="boolean", defaultValue="false", flags=1)
@NiagaraActions(value={@NiagaraAction(name="enableUserMappings", flags=128), @NiagaraAction(name="disableUserMappings")})
public class BCloudUserMappings
extends BComponent {
    public static final Property enabled = BCloudUserMappings.newProperty((int)1, (boolean)false, null);
    public static final Action enableUserMappings = BCloudUserMappings.newAction((int)128, null);
    public static final Action disableUserMappings = BCloudUserMappings.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BCloudUserMappings.class);
    private static final String USER_MAPPING_DISABLED = "User mapping disabled";
    private static final String NULL_MAPPING = "NULL";
    private Map<Property, String> byProperty = new HashMap<Property, String>();
    private Map<String, BUserMapping> mappingsByAppId = new HashMap<String, BUserMapping>();
    private static final Logger log = Logger.getLogger("ncloud.security");

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public void enableUserMappings() {
        this.invoke(enableUserMappings, null, null);
    }

    public void disableUserMappings() {
        this.invoke(disableUserMappings, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doEnableUserMappings() {
        this.setEnabled(true);
        log.warning("User Mappings have been enabled; this is not recommended as does not provide sufficient authentication of incoming requests");
    }

    public void doDisableUserMappings() {
        this.setEnabled(false);
    }

    public BUser getUser(String appId) {
        if (this.getEnabled()) {
            BUserMapping mapping = this.mappingsByAppId.get(appId);
            return mapping != null ? BUserService.getService().getUser(mapping.getUserName()) : null;
        }
        log.info("User Mappings not enabled");
        return null;
    }

    public void started() throws Exception {
        super.started();
        SlotCursor sc = this.getProperties();
        while (sc.next()) {
            BValue value = sc.get();
            if (!(value instanceof BUserMapping)) continue;
            this.map(sc.property(), (BUserMapping)value);
        }
    }

    public void changed(Property property, Context context) {
        BValue value;
        if (!this.isRunning() || context == CloudUtilities.fallbackContext) {
            return;
        }
        String oldAppId = this.byProperty.get(property);
        if (oldAppId != null) {
            this.unmap(property, oldAppId);
        }
        if ((value = this.get(property)) instanceof BUserMapping) {
            this.map(property, (BUserMapping)value);
        }
    }

    public void added(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        BValue value = this.get(property);
        if (value instanceof BUserMapping) {
            this.map(property, (BUserMapping)value);
        }
    }

    public void removed(Property property, BValue oldValue, Context context) {
        if (!this.isRunning()) {
            return;
        }
        BValue value = this.get(property);
        if (value instanceof BUserMapping) {
            this.unmap(property, ((BUserMapping)value).getAppId());
        }
    }

    private void map(Property property, BUserMapping mapping) {
        if (property != null && mapping != null && !mapping.getAppId().isEmpty()) {
            String appId = mapping.getAppId();
            BUserMapping existing = this.mappingsByAppId.get(appId);
            if (existing == null) {
                this.byProperty.put(property, mapping.getAppId());
                this.mappingsByAppId.put(mapping.getAppId(), mapping);
            } else {
                log.warning(() -> String.format("Duplicate user mapping of appId %s from %s to %s rejected", new Object[]{appId, existing, mapping}));
                mapping.set(BUserMapping.appId, (BValue)BString.make((String)""), CloudUtilities.fallbackContext);
            }
        }
    }

    private void unmap(Property property, String appId) {
        if (property != null && !appId.isEmpty()) {
            this.byProperty.remove(property);
            this.mappingsByAppId.remove(appId);
        }
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"CloudUserMappings", 2);
        out.startTable(true);
        out.trTitle((Object)"App Ids Mapped By Property", 2);
        out.w((Object)"<tr>").th((Object)"User Mapping Property").th((Object)"App Id").w((Object)"</tr>\n");
        this.byProperty.forEach((arg_0, arg_1) -> ((SpyWriter)out).tr(arg_0, arg_1));
        out.endTable();
        out.startTable(true);
        out.trTitle((Object)"App Id Mappings", 2);
        out.w((Object)"<tr>").th((Object)"App Id").th((Object)"User Name").w((Object)"</tr>\n");
        this.mappingsByAppId.forEach((key, value) -> out.tr(key, (Object)BCloudUserMappings.spyString(value.getUserName())));
        out.endTable();
        out.endProps();
    }

    private static String spyString(String username) {
        if (username == null) {
            return NULL_MAPPING;
        }
        return username.isEmpty() ? USER_MAPPING_DISABLED : username;
    }
}

