/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help;

import com.tridium.html.util.HtmlTokenizer;
import com.tridium.sys.Nre;
import com.tridium.util.Href2Ord;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.util.Iterator;
import java.util.Map;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BModule;
import javax.baja.sys.Sys;

public abstract class HtmlChecker {
    private static void checkModule(BModule module) throws Exception {
        Iterator navDescendants = module.iterateNavDescendants();
        while (navDescendants.hasNext()) {
            BINavNode navDescendant = (BINavNode)navDescendants.next();
            if (!(navDescendant instanceof BIFile) || !"html".equals(((BIFile)navDescendant).getExtension())) continue;
            InputStream entryIn = ((BIFile)navDescendant).getInputStream();
            Throwable throwable = null;
            try {
                BufferedInputStream bin = new BufferedInputStream(entryIn);
                Throwable throwable2 = null;
                try {
                    new HtmlParser(((BIFile)navDescendant).getAbsoluteOrd().toString()).parse(bin, false);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (bin == null) continue;
                    if (throwable2 != null) {
                        try {
                            bin.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    bin.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (entryIn == null) continue;
                if (throwable != null) {
                    try {
                        entryIn.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                entryIn.close();
            }
        }
        System.gc();
    }

    private static void usage() {
        System.out.println("usage: ");
        System.out.println("  HtmlChecker <module>");
        System.out.println("  use 'all' to check every module");
    }

    public static void main(String[] args) {
        System.out.println();
        if (args.length != 1) {
            HtmlChecker.usage();
            System.exit(-1);
        }
        try {
            if (args[0].equals("all")) {
                for (String moduleName : AccessController.doPrivileged(() -> Nre.getModuleManager()).getModuleNames()) {
                    HtmlChecker.checkModule(Sys.loadModule((String)moduleName));
                }
            } else {
                HtmlChecker.checkModule(Sys.loadModule((String)args[0]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static class HtmlParser
    extends HtmlTokenizer {
        private BOrd base;
        private Href2Ord conv;

        private HtmlParser(String ordStr) {
            this.base = BOrd.make((String)ordStr);
            this.conv = new Href2Ord(this.base);
        }

        public void handleStartTag(int row, String str, Map<String, String> attribs) {
            String href;
            if (str.equals("A") && (href = attribs.get("HREF")) != null) {
                if (href.startsWith("http:") || href.startsWith("mailto:")) {
                    System.out.println("WARNING in " + this.base + ": found '" + href + "', near line " + row);
                } else {
                    BOrd ord = null;
                    try {
                        ord = this.conv.hrefToOrd(href);
                    }
                    catch (Exception e) {
                        System.out.println("ERROR in " + this.base + ": could not create Ord for '" + href + "', near line " + row);
                    }
                    try {
                        ord.resolve();
                    }
                    catch (Exception e) {
                        System.out.println("ERROR in " + this.base + ": could not resolve Ord for '" + href + "', near line " + row);
                    }
                }
            }
        }

        public void handleText(String str) {
        }

        public void handleComment(String str) {
        }

        public void handleEndTag(int row, String str) {
        }
    }
}

