/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc;

import com.tridium.help.bajadoc.Annotation;
import com.tridium.help.bajadoc.ClassDoc;
import com.tridium.help.bajadoc.util.TypeNameFormatter;
import java.util.HashMap;
import java.util.Objects;
import javax.baja.nre.util.TextUtil;

public class JavaType
implements Comparable<JavaType> {
    public static final JavaType[] NONE = new JavaType[0];
    static final HashMap<String, Object> primitives = new HashMap();
    protected String profile;
    protected String qualifiedName;
    protected Annotation[] annotations;
    protected String name;
    protected String displayName;
    protected String packageName;
    protected int dimension;
    protected String dimensionString;
    protected boolean primitive;

    public JavaType(String qualifiedName, int dimension, Annotation[] annotations) {
        this.qualifiedName = qualifiedName;
        this.annotations = annotations;
        this.name = TextUtil.getClassName((String)qualifiedName).replace('$', '.');
        this.packageName = TextUtil.getPackageName((String)qualifiedName);
        if (this.packageName != null && this.packageName.length() == 0) {
            this.packageName = null;
        }
        this.primitive = primitives.get(qualifiedName) != null;
        this.dimension = dimension;
        this.dimensionString = "";
        for (int i = 0; i < dimension; ++i) {
            this.dimensionString = this.dimensionString + "[]";
        }
        this.displayName = this.name + this.dimensionString;
    }

    public JavaType(ClassDoc cls) {
        this(cls.qualifiedName(), 0, cls.annotations());
    }

    protected JavaType() {
    }

    public String name() {
        return this.name;
    }

    public String qualifiedName() {
        return this.qualifiedName;
    }

    public String packageName() {
        return this.packageName;
    }

    public Annotation[] annotations() {
        return this.annotations;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public int dimension() {
        return this.dimension;
    }

    public String dimensionString() {
        return this.dimensionString;
    }

    public String displayName() {
        return this.displayName;
    }

    public boolean isResolved() {
        return this.packageName != null;
    }

    @Override
    public int compareTo(JavaType o) {
        JavaType that = o;
        int n = this.name.compareTo(that.name);
        return n == 0 ? this.qualifiedName.compareTo(that.qualifiedName) : n;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        JavaType that = (JavaType)o;
        return this.qualifiedName.equals(that.qualifiedName) && this.dimension == that.dimension;
    }

    public int hashCode() {
        return Objects.hash(this.qualifiedName, this.dimensionString);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.packageName != null) {
            sb.append(this.packageName).append('.');
        }
        if (this.isPrimitive()) {
            sb.append(this.name);
        } else {
            TypeNameFormatter.formatPlain(new JavaType[]{this}, "", true, (s, t) -> sb.append((String)s));
        }
        for (int i = 0; i < this.dimension; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    static {
        Object dummy = new Object();
        primitives.put("boolean", dummy);
        primitives.put("byte", dummy);
        primitives.put("char", dummy);
        primitives.put("float", dummy);
        primitives.put("double", dummy);
        primitives.put("int", dummy);
        primitives.put("long", dummy);
        primitives.put("short", dummy);
        primitives.put("void", dummy);
    }
}

