/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc;

import com.tridium.help.bajadoc.Annotation;
import com.tridium.help.bajadoc.ClassSummary;
import com.tridium.help.bajadoc.DescriptionPart;
import com.tridium.help.bajadoc.Doc;
import com.tridium.help.bajadoc.PackageDoc;
import com.tridium.help.bajadoc.Tag;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BIcon;

public class ModuleDoc
extends Doc {
    public static final BIcon ICON = BIcon.std((String)"module.png");
    protected String name;
    protected String profile;
    protected String bajaVersion;
    protected String vendor;
    protected String vendorVersion;
    protected String docModule;
    protected PackageDoc[] packages;
    protected ClassSummary[] types;
    private PackageDoc[] packagesSorted;
    private ClassSummary[] typesSorted;

    public ModuleDoc(String name, String profile, String bajaVersion, String vendor, String vendorVersion, String docModule, PackageDoc[] packages, ClassSummary[] types, DescriptionPart[] description, Tag[] tags) {
        super(description, tags, Annotation.none);
        this.name = name;
        this.profile = profile;
        this.bajaVersion = bajaVersion;
        this.vendor = vendor;
        this.vendorVersion = vendorVersion;
        this.docModule = docModule;
        this.packages = packages;
        this.types = types;
    }

    @Override
    public BIcon icon() {
        return ICON;
    }

    public String name() {
        return this.name;
    }

    public String profile() {
        return this.profile;
    }

    public String modulePart() {
        return this.name + '-' + this.profile;
    }

    public String vendor() {
        return this.vendor;
    }

    public String bajaVersion() {
        return this.bajaVersion;
    }

    public String vendorVersion() {
        return this.vendorVersion;
    }

    public String docModule() {
        return this.docModule;
    }

    public PackageDoc[] packages() {
        return this.packages;
    }

    public ClassSummary[] types() {
        return this.types;
    }

    public String toString() {
        return "module " + this.name;
    }

    public PackageDoc[] packagesSorted() {
        if (this.packagesSorted == null) {
            int len = this.packages.length;
            Object[] keys = new String[len];
            this.packagesSorted = new PackageDoc[len];
            for (int i = 0; i < len; ++i) {
                keys[i] = this.packages[i].name();
                this.packagesSorted[i] = this.packages[i];
            }
            SortUtil.sort((Object[])keys, (Object[])this.packagesSorted);
        }
        return this.packagesSorted;
    }

    public ClassSummary[] typesSorted() {
        if (this.typesSorted == null) {
            int len = this.types.length;
            Object[] keys = new String[len];
            this.typesSorted = new ClassSummary[len];
            for (int i = 0; i < len; ++i) {
                keys[i] = this.types[i].name();
                this.typesSorted[i] = this.types[i];
            }
            SortUtil.sort((Object[])keys, (Object[])this.typesSorted);
        }
        return this.typesSorted;
    }
}

