/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc;

import com.tridium.help.bajadoc.Annotation;
import com.tridium.help.bajadoc.JavaType;

public class WildcardJavaType
extends JavaType {
    private BoundsType boundsType = BoundsType.noBounds;
    private final JavaType[] bounds;

    private WildcardJavaType(String qualifiedName, int dimension, BoundsType boundsType, JavaType[] bounds, Annotation[] annotations) {
        super(qualifiedName, dimension, annotations);
        this.boundsType = boundsType;
        this.bounds = bounds;
    }

    public static WildcardJavaType make(String qualifiedName, int dimension, Annotation[] annotations) {
        return new WildcardJavaType(qualifiedName, dimension, BoundsType.noBounds, null, annotations);
    }

    public static WildcardJavaType makeSuperBounded(String qualifiedName, int dimension, JavaType[] bounds, Annotation[] annotations) {
        return new WildcardJavaType(qualifiedName, dimension, BoundsType.superBounds, bounds, annotations);
    }

    public static WildcardJavaType makeExtendsBounded(String qualifiedName, int dimension, JavaType[] bounds, Annotation[] annotations) {
        return new WildcardJavaType(qualifiedName, dimension, BoundsType.extendsBounds, bounds, annotations);
    }

    public boolean hasSuperBounds() {
        return this.boundsType == BoundsType.superBounds;
    }

    public JavaType[] getSuperBounds() {
        return this.hasSuperBounds() ? this.bounds : JavaType.NONE;
    }

    public boolean hasExtendsBounds() {
        return this.boundsType == BoundsType.extendsBounds;
    }

    public JavaType[] getExtendsBounds() {
        return this.hasExtendsBounds() ? this.bounds : JavaType.NONE;
    }

    private static enum BoundsType {
        noBounds,
        superBounds,
        extendsBounds;

    }
}

