/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc.html;

import com.tridium.help.Hierarchy;
import com.tridium.help.HierarchyBuilder;
import com.tridium.help.bajadoc.ClassDoc;
import com.tridium.help.bajadoc.ClassSummary;
import com.tridium.help.bajadoc.Doc;
import com.tridium.help.bajadoc.FrameworkDoc;
import com.tridium.help.bajadoc.ModuleDoc;
import com.tridium.help.bajadoc.html.HtmlCompiler;
import com.tridium.help.bajadoc.html.UriPath;
import com.tridium.help.bajadoc.parser.BajadocParser;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.baja.file.BIFile;
import javax.baja.nre.util.FileUtil;

public class HtmlCompilerMain {
    private static String version;
    private static ArrayList<Path> sourceJarPaths;
    private static Path baseDestPath;
    private static ArrayList<ModuleDoc> parsedModules;

    public static void main(String[] args) {
        if (!HtmlCompilerMain.parseArgs(args)) {
            HtmlCompilerMain.usage();
            return;
        }
        try {
            HtmlCompilerMain.prepareOutputDirectories();
            HtmlCompilerMain.prepareHierarchy();
            HtmlCompilerMain.compileDocJars();
            HtmlCompilerMain.compileFrameworkPage();
            HtmlCompilerMain.copyResources();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean parseArgs(String[] args) {
        block10: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "-fwver": {
                    version = args[++i];
                    continue block10;
                }
                case "-src": {
                    sourceJarPaths.add(Paths.get(args[++i], new String[0]));
                    continue block10;
                }
                case "-dst": {
                    baseDestPath = Paths.get(args[++i], new String[0]);
                    continue block10;
                }
                default: {
                    HtmlCompilerMain.msg("Unexpected argument: " + args[i]);
                    return false;
                }
            }
        }
        return version != null && sourceJarPaths.size() > 0 && baseDestPath != null;
    }

    private static HtmlCompiler.BajadocHtmlCompilerOptions getCompilerOptions(UriPath htmlBaseUri) {
        HtmlCompiler.BajadocHtmlCompilerOptions opts = new HtmlCompiler.BajadocHtmlCompilerOptions(htmlBaseUri);
        opts.setFlattenInheritance(false);
        opts.setIncludeExpansionToggle(false);
        opts.setIncludeIcons(true);
        opts.setIncludeMemberIndex(true);
        opts.setIncludeSubclassHierarchy(true);
        return opts;
    }

    private static void prepareOutputDirectories() throws Exception {
        Files.createDirectories(baseDestPath, new FileAttribute[0]);
    }

    private static void prepareHierarchy() throws Exception {
        HierarchyBuilder hbuilder = new HierarchyBuilder();
        HashMap qnamesToModulePart = new HashMap();
        for (Path path : sourceJarPaths) {
            try {
                ZipFile zip = new ZipFile(path.toFile());
                zip.stream().filter(e -> e.getName().endsWith("module-index.bajadoc")).forEach(e -> {
                    try (BufferedInputStream in = new BufferedInputStream(zip.getInputStream((ZipEntry)e));){
                        ModuleDoc doc = (ModuleDoc)new BajadocParser().parse(in, "");
                        for (ClassSummary cls : doc.types()) {
                            qnamesToModulePart.put(cls.qualifiedName(), doc.modulePart());
                        }
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                });
                zip.stream().filter(e -> e.getName().endsWith(".bajadoc")).forEach(e -> {
                    try (BufferedInputStream in = new BufferedInputStream(zip.getInputStream((ZipEntry)e));){
                        Doc doc = new BajadocParser().parse(in, "");
                        if (doc instanceof ClassDoc) {
                            hbuilder.loadBajadoc(doc, qnamesToModulePart);
                        }
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                });
            }
            catch (Exception e2) {
                HtmlCompilerMain.msg("Failed to prepare " + path.toString() + ": " + e2.getMessage());
                e2.printStackTrace();
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(out));
        hbuilder.persist(w);
        ((Writer)w).flush();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        Hierarchy.instance().htmlCompilerDepersist(in);
    }

    private static void compileDocJars() {
        for (Path path : sourceJarPaths) {
            if (!Files.exists(path, new LinkOption[0])) {
                HtmlCompilerMain.msg("Could not find jar at path: " + path);
                continue;
            }
            try {
                JarFile docJar = new JarFile(path.toFile());
                Throwable throwable = null;
                try {
                    HtmlCompilerMain.msg("Compiling bajadocs in " + path);
                    HtmlCompilerMain.compileBajadocs(docJar);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (docJar == null) continue;
                    if (throwable != null) {
                        try {
                            docJar.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    docJar.close();
                }
            }
            catch (IOException e) {
                HtmlCompilerMain.msg("Failed to compile jar: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private static void compileFrameworkPage() throws IOException {
        parsedModules.sort((a, b) -> a.modulePart().compareTo(b.modulePart()));
        ModuleDoc[] modules = parsedModules.toArray(new ModuleDoc[0]);
        FrameworkDoc doc = new FrameworkDoc(modules, version);
        UriPath docBaseUri = UriPath.makeDocURI(doc);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(HtmlCompilerMain.makeCompiledHtmlOutputStream(docBaseUri)));){
            HtmlCompiler.compile(writer, doc, HtmlCompilerMain.getCompilerOptions(docBaseUri));
        }
    }

    private static void compileBajadocs(JarFile docJar) {
        docJar.stream().filter(e -> !e.isDirectory() && e.getName().endsWith(".bajadoc")).forEach(e -> HtmlCompilerMain.compileBajadocEntry(docJar, e));
    }

    private static void compileBajadocEntry(JarFile docJar, JarEntry je) {
        BajadocParser parser = new BajadocParser();
        try (InputStream in = docJar.getInputStream(je);){
            Doc doc = parser.parse(in, "");
            UriPath docBaseUri = UriPath.makeDocURI(doc);
            try (OutputStream out = HtmlCompilerMain.makeCompiledHtmlOutputStream(docBaseUri);
                 BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));){
                HtmlCompiler.compile(writer, doc, HtmlCompilerMain.getCompilerOptions(docBaseUri));
            }
            if (doc instanceof ModuleDoc) {
                parsedModules.add((ModuleDoc)doc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static OutputStream makeCompiledHtmlOutputStream(UriPath docBaseUri) throws IOException {
        Path path = HtmlCompilerMain.getCompiledDocPath(docBaseUri);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        return Files.newOutputStream(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private static Path getCompiledDocPath(UriPath docBaseUri) {
        String uriBody = docBaseUri.body();
        if (uriBody.startsWith("/")) {
            uriBody = uriBody.substring(1);
        }
        uriBody = uriBody.replace('/', File.separatorChar);
        return baseDestPath.resolve(uriBody);
    }

    private static void copyResources() throws IOException {
        HtmlCompiler.Resource[] resources;
        for (HtmlCompiler.Resource r : resources = HtmlCompiler.getResources()) {
            UriPath docBaseUri = UriPath.makeResourceURI(r.getPath());
            Path path = HtmlCompilerMain.getCompiledDocPath(docBaseUri);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (InputStream is = ((BIFile)r.getOrd().get()).getInputStream();
                 OutputStream os = HtmlCompilerMain.makeCompiledHtmlOutputStream(docBaseUri);){
                FileUtil.pipe((InputStream)is, (OutputStream)os);
            }
        }
    }

    private static void usage() {
        HtmlCompilerMain.msg("usage: java com.tridium.help.bajadoc.html.HtmlCompilerMain -fwver <ver>");
        HtmlCompilerMain.msg("           -src <srcpath> -dst <destdir>");
        HtmlCompilerMain.msg("parameters:");
        HtmlCompilerMain.msg("fwver     niagara framework version");
        HtmlCompilerMain.msg("srcpath   source path of doc jar containing bajadoc XML. May be specified multiple times.");
        HtmlCompilerMain.msg("destdir   destination directory for compiled html bajadocs");
    }

    private static void msg(String msg) {
        System.out.println(msg);
    }

    static {
        sourceJarPaths = new ArrayList();
        parsedModules = new ArrayList();
    }
}

