/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.ui;

import com.tridium.help.bajadoc.ActionDoc;
import com.tridium.help.bajadoc.ClassDoc;
import com.tridium.help.bajadoc.ConstructorDoc;
import com.tridium.help.bajadoc.FieldDoc;
import com.tridium.help.bajadoc.MethodDoc;
import com.tridium.help.bajadoc.Parameter;
import com.tridium.help.bajadoc.PropertyDoc;
import com.tridium.help.bajadoc.TopicDoc;
import com.tridium.help.bajadoc.parser.BajadocParser;
import com.tridium.help.ui.DocClassMemberNode;
import com.tridium.help.ui.HelpTreeNode;
import java.util.ArrayList;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.sys.BIcon;

public class DocClassNode
extends HelpTreeNode {
    private BImage icon;
    private String name;

    public DocClassNode(HelpTreeNode parent, BOrd contentOrd, String name, BImage icon) {
        super(parent, contentOrd);
        this.name = name;
        this.icon = icon;
    }

    public String getText() {
        return this.name;
    }

    public BImage getIcon() {
        return this.icon;
    }

    @Override
    protected HelpTreeNode[] buildChildNodes() {
        if (this.kids == null) {
            this.populate();
        }
        return this.kids;
    }

    private void populate() {
        this.kids = new HelpTreeNode[0];
        try {
            ArrayList<HelpTreeNode> kidList = new ArrayList<HelpTreeNode>();
            BIFile file = (BIFile)this.getContentOrd().resolve().get();
            BajadocParser parser = new BajadocParser();
            ClassDoc classDoc = (ClassDoc)parser.parse(file);
            this.loadProperties(classDoc, kidList);
            this.loadActions(classDoc, kidList);
            this.loadTopics(classDoc, kidList);
            this.loadConstructors(classDoc, kidList);
            this.loadMethods(classDoc, kidList);
            this.loadFields(classDoc, kidList);
            this.kids = new HelpTreeNode[kidList.size()];
            for (int i = 0; i < kidList.size(); ++i) {
                this.kids[i] = kidList.get(i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadProperties(ClassDoc classDoc, ArrayList<HelpTreeNode> kidList) {
        PropertyDoc[] props = classDoc.propertiesSorted();
        if (props.length > 0) {
            BImage icon = BImage.make((BIcon)props[0].icon());
            for (int i = 0; i < props.length; ++i) {
                PropertyDoc d = props[i];
                kidList.add(new DocClassMemberNode(this, BOrd.make((String)(this.getContentOrd().toString() + "#" + d.anchor())), d.name(), icon));
            }
        }
    }

    private void loadActions(ClassDoc classDoc, ArrayList<HelpTreeNode> kidList) {
        ActionDoc[] actions = classDoc.actionsSorted();
        if (actions.length > 0) {
            BImage icon = BImage.make((BIcon)actions[0].icon());
            for (int i = 0; i < actions.length; ++i) {
                ActionDoc d = actions[i];
                StringBuilder name = new StringBuilder();
                name.append(d.name());
                name.append(this.resolveParameter(d.parameter()));
                kidList.add(new DocClassMemberNode(this, BOrd.make((String)(this.getContentOrd().toString() + "#" + d.anchor())), name.toString(), icon));
            }
        }
    }

    private void loadTopics(ClassDoc classDoc, ArrayList<HelpTreeNode> kidList) {
        TopicDoc[] topics = classDoc.topicsSorted();
        if (topics.length > 0) {
            BImage icon = BImage.make((BIcon)topics[0].icon());
            for (int i = 0; i < topics.length; ++i) {
                TopicDoc d = topics[i];
                kidList.add(new DocClassMemberNode(this, BOrd.make((String)(this.getContentOrd().toString() + "#" + d.name())), d.name(), icon));
            }
        }
    }

    private void loadConstructors(ClassDoc classDoc, ArrayList<HelpTreeNode> kidList) {
        ConstructorDoc[] constructors = classDoc.constructors();
        if (constructors.length > 0) {
            BImage icon = BImage.make((BIcon)constructors[0].icon());
            for (int i = 0; i < constructors.length; ++i) {
                ConstructorDoc d = constructors[i];
                StringBuilder name = new StringBuilder();
                name.append(d.name());
                name.append(DocClassNode.resolveParameters(d.parameters()));
                kidList.add(new DocClassMemberNode(this, BOrd.make((String)(this.getContentOrd().toString() + "#" + d.anchor())), name.toString(), icon));
            }
        }
    }

    private void loadMethods(ClassDoc classDoc, ArrayList<HelpTreeNode> kidList) {
        MethodDoc[] methods = classDoc.methodsSorted();
        if (methods.length > 0) {
            BImage icon = BImage.make((BIcon)methods[0].icon());
            for (int i = 0; i < methods.length; ++i) {
                MethodDoc d = methods[i];
                StringBuilder name = new StringBuilder();
                name.append(d.name());
                name.append(DocClassNode.resolveParameters(d.parameters()));
                kidList.add(new DocClassMemberNode(this, BOrd.make((String)(this.getContentOrd().toString() + "#" + d.anchor())), name.toString(), icon));
            }
        }
    }

    private void loadFields(ClassDoc classDoc, ArrayList<HelpTreeNode> kidList) {
        FieldDoc[] fields = classDoc.fieldsSorted();
        if (fields.length > 0) {
            BImage icon = BImage.make((BIcon)fields[0].icon());
            for (int i = 0; i < fields.length; ++i) {
                FieldDoc d = fields[i];
                kidList.add(new DocClassMemberNode(this, BOrd.make((String)(this.getContentOrd().toString() + "#" + d.anchor())), d.name(), icon));
            }
        }
    }

    private String resolveParameter(Parameter param) {
        if (param == null) {
            return DocClassNode.resolveParameters(new Parameter[0]);
        }
        return DocClassNode.resolveParameters(new Parameter[]{param});
    }

    public static String resolveParameters(Parameter[] params) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        if (params != null && params.length > 0) {
            buf.append(params[0].type().displayName());
            buf.append(" ");
            buf.append(params[0].name());
            for (int i = 1; i < params.length; ++i) {
                buf.append(", ");
                buf.append(params[i].type().displayName());
                buf.append(" ");
                buf.append(params[i].name());
            }
        }
        buf.append(")");
        return buf.toString();
    }

    public static String makeFragment(String str) {
        StringBuilder sb = new StringBuilder(str);
        for (int i = sb.length() - 1; i >= 0; --i) {
            char c = sb.charAt(i);
            if (c != '(' && c != ')' && c != '[' && c != ']' && c != ',' && c != ' ') continue;
            sb.setCharAt(i, '_');
        }
        return sb.toString();
    }
}

