/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.ui;

import com.tridium.help.bajadoc.ClassDoc;
import com.tridium.help.bajadoc.ClassSummary;
import com.tridium.help.bajadoc.PackageDoc;
import com.tridium.help.bajadoc.parser.BajadocParser;
import com.tridium.help.ui.DocClassNode;
import com.tridium.help.ui.DocModuleNode;
import com.tridium.help.ui.HelpTreeNode;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.sys.BIcon;

public class DocPackageNode
extends HelpTreeNode {
    private static BImage icon = BImage.make((BIcon)PackageDoc.ICON);
    private static BImage classIcon = BImage.make((BIcon)ClassDoc.defaultIcon);
    private String docModule;
    private String targetModulePart;
    private String packageName;

    public DocPackageNode(HelpTreeNode parent, BOrd contentOrd, String docModule, String targetModulePart, String packageName) {
        super(parent, contentOrd);
        this.docModule = docModule;
        this.targetModulePart = targetModulePart;
        this.packageName = packageName;
    }

    public String getText() {
        return this.packageName;
    }

    public BImage getIcon() {
        return icon;
    }

    @Override
    protected HelpTreeNode[] buildChildNodes() {
        if (this.kids == null) {
            this.populate();
        }
        return this.kids;
    }

    private void populate() {
        this.kids = new HelpTreeNode[0];
        try {
            BIFile file = (BIFile)this.getContentOrd().resolve().get();
            BajadocParser parser = new BajadocParser();
            PackageDoc packageDoc = (PackageDoc)parser.parse(file);
            ClassSummary[] classDocs = packageDoc.classesSorted();
            this.kids = new HelpTreeNode[classDocs.length];
            for (int i = 0; i < classDocs.length; ++i) {
                this.kids[i] = new DocClassNode(this, DocModuleNode.getClassOrd(this.docModule, this.targetModulePart, classDocs[i]), DocModuleNode.getClassName(classDocs[i]), classIcon);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

