/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.ets;

import com.tridiumX.knxnetIp.addresses.BGroupAddress;
import com.tridiumX.knxnetIp.addresses.BKnxAddressStyleEnum;
import com.tridiumX.knxnetIp.enums.BKnxComObjectSizeEnum;
import com.tridiumX.knxnetIp.ets.job.BEtsProjectFileImportJob;
import com.tridiumX.knxnetIp.ets.project.BEtsGroupAddress;
import com.tridiumX.knxnetIp.knxDataDefs.BDataValueTypeDef;
import com.tridiumX.knxnetIp.ui.BDiscoveredPoint;
import com.tridiumX.knxnetIp.wb.BImportedPoint;
import com.tridiumX.knxnetIp.wb.BImportedPointGroup;
import com.tridiumX.knxnetIp.wb.BKnxWbService;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BValue;

public final class EtsProjectImportUtil {
    private static final String DEFAULT_GA_NAME = "GroupAddress";
    private static final String UNASSOCIATED_GA_NAME = "unknown";
    private static final String DEFAULT_UNASSOCIATED_GA_TYPE = "DPST-1-1";

    private EtsProjectImportUtil() {
    }

    public static void addDiscoveredPointToGroup(BDiscoveredPoint discoveredGroup, BDiscoveredPoint discoveredPoint, BImportedPoint importedPoint, String groupAddressName) {
        if (groupAddressName.isEmpty()) {
            groupAddressName = DEFAULT_GA_NAME;
        }
        if (discoveredGroup.get(groupAddressName) != null || DEFAULT_GA_NAME.equals(groupAddressName)) {
            groupAddressName = groupAddressName + SlotPath.escape((String)(" (" + importedPoint.getGroupAddresses().getPrimaryGroupAddress().getAddress() + ')'));
        }
        if (discoveredGroup.get(groupAddressName) != null) {
            groupAddressName = groupAddressName + SlotPath.escape((String)(" {Id = '" + importedPoint.getKnxId() + "'}"));
        }
        discoveredGroup.add(groupAddressName, (BValue)discoveredPoint);
    }

    public static void addUnassociatedGroupAddressToGroup(BImportedPointGroup importedPointGroup, BImportedPoint importedPoint, BEtsGroupAddress groupAddress, BKnxAddressStyleEnum groupAddressStyle, BEtsProjectFileImportJob job) {
        if (!"".equals(groupAddress.getDatapointType())) {
            importedPoint.setDataValueTypeId(groupAddress.getDatapointType());
        } else {
            importedPoint.setDataValueTypeId(DEFAULT_UNASSOCIATED_GA_TYPE);
        }
        importedPoint.setWriteFlag(true);
        importedPointGroup.add("unknown?", (BValue)importedPoint);
        job.logMessage(String.format("Processed Unassociated GroupAddress - '%s' (%s) (%s)", groupAddress.getGroupAddressName(), groupAddress.getGroupAddressId(), BGroupAddress.make((int)groupAddress.getAddress(), (BKnxAddressStyleEnum)groupAddressStyle).getFriendlyAddress()));
    }

    public static BKnxComObjectSizeEnum getDefaultObjectSizeForDataType(String dataValueTypeId) {
        BValue dataDefType = BKnxWbService.getService().getKnxDataDefs().getKnxDefs().get(SlotPath.escape((String)dataValueTypeId));
        if (dataDefType instanceof BDataValueTypeDef) {
            return ((BDataValueTypeDef)dataDefType.as(BDataValueTypeDef.class)).getComObjectSize();
        }
        return BKnxComObjectSizeEnum.unknownSize;
    }

    public static String interpretGroupRangeError(String method, String operation, String knxId, int depth, Object parentGroupRange) {
        return String.format("There was a problem in '%s', %s with KnxID = '%s',  where iDepth = '%s' & parentGroupRange = '%s'.", method, operation, knxId, depth, parentGroupRange);
    }
}

