/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.ui;

import com.tridiumX.knxnetIp.knxDataDefs.BKnxDataDefs;
import com.tridiumX.knxnetIp.knxDataDefs.IXmlImportableComponent;
import com.tridiumX.knxnetIp.knxDataDefs.importSpecs.BKnxDataImportSpecs;
import com.tridiumX.knxnetIp.util.CatchAll;
import com.tridiumX.knxnetIp.xml.IXmlImporterHelper;
import com.tridiumX.knxnetIp.xml.ImportProblemReports;
import com.tridiumX.knxnetIp.xml.XmlImporter;
import com.tridiumX.knxnetIp.xml.XmlPropertyImportSpec;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;

@NiagaraType
public final class BKnxExtraImportDialog
extends BProgressDialog {
    public static final Type TYPE = Sys.loadType(BKnxExtraImportDialog.class);
    private static final Lexicon lex = Lexicon.make((String)TYPE.getModule().getModuleName());
    private static final String IMPORT_KNX_EXTRA_DIALOG_BASE_LEX_KEY = "importKnxExtraDialog.";
    private static final String IMPORT_KNX_EXTRA_DIALOG_TITLE_LEX_KEY = "importKnxExtraDialog.title";
    private static final String IMPORT_KNX_EXTRA_DIALOG_TITLE_DEFAULT = "Importing 'knx_extra.xml'";

    public Type getType() {
        return TYPE;
    }

    public static ImportProblemReports doLoadKnxExtraFile(BWidget owner, BIFile defsFile, BKnxDataDefs knxDataDefs) {
        BIcon icon = BIcon.make((String)"module://icons/x32/clock.png");
        KnxExtraImportWorker importWorker = new KnxExtraImportWorker(defsFile, knxDataDefs);
        BKnxExtraImportDialog.open((BWidget)owner, (String)lex.get(IMPORT_KNX_EXTRA_DIALOG_TITLE_LEX_KEY, IMPORT_KNX_EXTRA_DIALOG_TITLE_DEFAULT), (BProgressDialog.Worker)importWorker, (BImage)BImage.make((BIcon)icon));
        return importWorker.importProblemReports;
    }

    private static class KnxExtraImportWorker
    extends BProgressDialog.Worker
    implements IXmlImporterHelper {
        private final BIFile defsFile;
        private final BKnxDataDefs knxDataDefs;
        private boolean canceled;
        private ImportProblemReports importProblemReports;

        public KnxExtraImportWorker(BIFile defsFile, BKnxDataDefs knxDataDefs) {
            this.defsFile = defsFile;
            this.knxDataDefs = knxDataDefs;
        }

        public void doRun() throws Exception {
            if (this.defsFile != null) {
                this.updateProgress(0, "Importing 'knx_extra.xml' from '" + this.defsFile.toString(null) + "'");
                try {
                    XmlImporter xmlImporter = new XmlImporter();
                    xmlImporter.loadFromInputStream(this, this.defsFile.getInputStream(), this.defsFile.getSize(), (IXmlImportableComponent)this.knxDataDefs, new BKnxDataImportSpecs());
                    if (this.canceled) {
                        this.importProblemReports.add("Import of 'knx_extra.xml' from '" + this.defsFile.toString(null) + "' was canceled.");
                    }
                }
                catch (Throwable t) {
                    CatchAll.throwable((Throwable)t);
                }
            } else {
                throw new NullPointerException("No 'KNX Data Defs' file provided to import from.");
            }
        }

        public void doCancel() throws Exception {
            this.canceled = true;
        }

        @Override
        public boolean isCancelled() {
            return !this.isAlive() || this.canceled;
        }

        @Override
        public ImportProblemReports getImportProblemReports() {
            if (this.importProblemReports == null) {
                this.importProblemReports = new ImportProblemReports();
            }
            return this.importProblemReports;
        }

        @Override
        public String preProcessEnumImport(XmlPropertyImportSpec propertySpec, String sNewVal) {
            return sNewVal;
        }
    }
}

