/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.wb;

import com.tridiumX.knxnetIp.util.CatchAll;
import com.tridiumX.knxnetIp.wb.BImportEtsProjectFilePane;
import com.tridiumX.knxnetIp.wb.BImportedEtsProjectFiles;
import com.tridiumX.knxnetIp.wb.BKnxWbDataDefs;
import com.tridiumX.knxnetIp.wb.BKnxWbServiceOptions;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;
import javax.baja.units.UnitDatabase;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.tool.BWbService;
import javax.baja.workbench.tool.WbServiceManager;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="knxDataDefs", type="BKnxWbDataDefs", defaultValue="new BKnxWbDataDefs()"), @NiagaraProperty(name="importedFiles", type="BImportedEtsProjectFiles", defaultValue="new BImportedEtsProjectFiles()", flags=8)})
@NiagaraActions(value={@NiagaraAction(name="loadService"), @NiagaraAction(name="saveService")})
public class BKnxWbService
extends BWbService {
    public static final Property knxDataDefs = BKnxWbService.newProperty((int)0, (BValue)new BKnxWbDataDefs(), null);
    public static final Property importedFiles = BKnxWbService.newProperty((int)8, (BValue)new BImportedEtsProjectFiles(), null);
    public static final Action loadService = BKnxWbService.newAction((int)0, null);
    public static final Action saveService = BKnxWbService.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BKnxWbService.class);
    private static final Object propertiesLock = new Object();
    private static final FilePath DATA_DEFS_FILE_PATH = new FilePath("!knx/datadefs.bog");
    private static final FilePath CACHE_FILE_PATH = new FilePath("!knx/cache.bog");
    private static final BIcon icon = BIcon.std((String)"database.png");
    public static final Logger log = Logger.getLogger(TYPE.getModule().getModuleName() + ".workbenchService");

    public BKnxWbDataDefs getKnxDataDefs() {
        return (BKnxWbDataDefs)this.get(knxDataDefs);
    }

    public void setKnxDataDefs(BKnxWbDataDefs v) {
        this.set(knxDataDefs, (BValue)v, null);
    }

    public BImportedEtsProjectFiles getImportedFiles() {
        return (BImportedEtsProjectFiles)this.get(importedFiles);
    }

    public void setImportedFiles(BImportedEtsProjectFiles v) {
        this.set(importedFiles, (BValue)v, null);
    }

    public void loadService() {
        this.invoke(loadService, null, null);
    }

    public void saveService() {
        this.invoke(saveService, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final CommandArtifact invoke(BWbShell shell) throws Exception {
        BKnxWbService.getService();
        return super.invoke(shell);
    }

    public final Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public final void serviceStarted() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("KNX service is starting");
        }
        UnitDatabase.getDefault();
        this.doLoadService();
        if (log.isLoggable(Level.FINE)) {
            log.fine("KNX service has started");
        }
    }

    public final void serviceStopped() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("KNX service is stopping");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("KNX service has stopped");
        }
    }

    public static BKnxWbService getService() {
        try {
            WbServiceManager wbServiceManager = BWbService.getManager();
            if (wbServiceManager != null && !wbServiceManager.isRunning(TYPE.getTypeInfo())) {
                wbServiceManager.start(TYPE.getTypeInfo());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return (BKnxWbService)BOrd.make((String)"tool:knxnetIp:KnxWbService|slot:/").get();
    }

    public static BKnxWbServiceOptions getImportSettings() {
        return BKnxWbServiceOptions.make();
    }

    public final void changed(Property property, Context context) {
        if (this.isRunning()) {
            return;
        }
        if (property.equals(knxDataDefs)) {
            this.getKnxDataDefs().doCheckDataIntegrity();
        }
    }

    public final void doLoadService() {
        this.doLoadDataDefs();
        this.doLoadImportCache();
    }

    public final void doSaveService() {
        this.doSaveDataDefs();
        BKnxWbService.doSaveSettings();
        this.doSaveImportCache();
    }

    public final void doLoadDataDefs() {
        this.loadProp(DATA_DEFS_FILE_PATH, knxDataDefs);
    }

    public final void doLoadImportCache() {
        this.loadProp(CACHE_FILE_PATH, importedFiles);
    }

    public final void doSaveDataDefs() {
        this.saveProp(DATA_DEFS_FILE_PATH, knxDataDefs);
    }

    public static void doSaveSettings() {
        BKnxWbService.getImportSettings().save();
    }

    public final void doSaveImportCache() {
        this.saveProp(CACHE_FILE_PATH, importedFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProp(FilePath filePath, Property prop) {
        Object object = propertiesLock;
        synchronized (object) {
            block11: {
                try {
                    BFileSystem localFs = BFileSystem.INSTANCE;
                    BIFile configFile = localFs.makeFile(filePath);
                    if (configFile.getSize() == 0L) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("New installation - no service information to load from : \"" + configFile.getOrdInHost() + "\"");
                        }
                        return;
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Loading service information from : \"" + configFile.getOrdInHost() + "\"");
                    }
                    ValueDocDecoder decoder = new ValueDocDecoder(configFile.getInputStream());
                    BValue value = decoder.decodeDocument(true);
                    decoder.close();
                    this.set(prop, value.newCopy(true), Context.decoding);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Loaded service information from : \"" + configFile.getOrdInHost() + "\"");
                    }
                }
                catch (Throwable t) {
                    if (log.isLoggable(Level.SEVERE)) {
                        StringBuilder sb = new StringBuilder("Failed loading '").append(this.get(prop).asComplex().getDisplayName(null)).append("' service information.");
                        log.log(Level.SEVERE, sb.toString(), t);
                    } else {
                        CatchAll.throwable((Throwable)t);
                    }
                    if (!(t instanceof ThreadDeath)) break block11;
                    throw (ThreadDeath)t;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveProp(FilePath filePath, Property prop) {
        Object object = propertiesLock;
        synchronized (object) {
            block10: {
                BValue value = this.get(prop);
                try {
                    BFileSystem localFs = BFileSystem.INSTANCE;
                    BIFile existingFile = localFs.findFile(filePath);
                    if (existingFile != null && existingFile.getSize() != 0L) {
                        localFs.makeDir(new FilePath("!knx/backups"));
                        FilePath backupPath = BKnxWbService.getBackupFilePath(existingFile);
                        localFs.move(filePath, backupPath);
                    }
                    BIFile configFile = localFs.makeFile(filePath);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Saving service '" + value.asComplex().getDisplayName(null) + "' information to : \"" + configFile.getOrdInHost() + "\"");
                    }
                    ValueDocEncoder encoder = new ValueDocEncoder(configFile.getOutputStream());
                    encoder.setEncodeComments(false);
                    encoder.setZipped(true);
                    encoder.encodeDocument(value);
                    encoder.flush();
                    encoder.close();
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Saved service '" + value.asComplex().getDisplayName(null) + "' information to : \"" + configFile.getOrdInHost() + "\"");
                    }
                }
                catch (Throwable t) {
                    if (log.isLoggable(Level.SEVERE)) {
                        log.log(Level.SEVERE, "Failed saving service '" + value.asComplex().getDisplayName(null) + "' information", t);
                    } else {
                        CatchAll.throwable((Throwable)t);
                    }
                    if (!(t instanceof ThreadDeath)) break block10;
                    throw (ThreadDeath)t;
                }
            }
        }
    }

    private static FilePath getBackupFilePath(BIFile existingFile) {
        String sFileName = existingFile.getFileName();
        StringBuffer sb = new StringBuffer(existingFile.getFileName().length() + 44 + 4);
        sb.append("!knx/backups/");
        sb.append(sFileName, 0, sFileName.lastIndexOf(".bog"));
        sb.append("_backup ");
        BAbsTime now = BAbsTime.make();
        BImportEtsProjectFilePane.appendTime(sb, now);
        sb.append('-');
        sb.append(TextUtil.padZeros((String)String.valueOf(now.getMillisecond()), (int)3));
        sb.append(".bog");
        return new FilePath(sb.toString().replace(':', '-'));
    }

    public BIcon getIcon() {
        return icon;
    }
}

