/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.wb;

import com.tridiumX.knxnetIp.ets.EtsImportException;
import com.tridiumX.knxnetIp.ets.EtsUtil;
import com.tridiumX.knxnetIp.ets.enums.BEtsProjectFileImportStateEnum;
import com.tridiumX.knxnetIp.ets.job.BEtsProjectFileImportJob;
import com.tridiumX.knxnetIp.ui.BKnxPointManager;
import com.tridiumX.knxnetIp.wb.BEtsProjectFilePasswordPane;
import com.tridiumX.knxnetIp.wb.BImportEtsProjectFileOptions;
import com.tridiumX.knxnetIp.wb.BImportEtsProjectFilePane;
import com.tridiumX.knxnetIp.wb.BImportedEtsProjectFile;
import com.tridiumX.knxnetIp.wb.BImportedEtsProjectFiles;
import com.tridiumX.knxnetIp.wb.BKnxWbService;
import com.tridiumX.knxnetIp.wb.IImportEtsProjectFilesManager;
import com.tridiumX.knxnetIp.wb.IKnxDeviceManager;
import com.tridiumX.knxnetIp.xml.ImportProblemReports;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BIFile;
import javax.baja.job.BJob;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrLearn;

public final class ImportEtsProjectFilesController {
    private static final Logger log = Logger.getLogger("knxnetIp.etsImportController");

    public static char[] doPromptForPassword(BWidget parent) throws Exception {
        String dialogTitle = "Password protected ETS project file";
        BEtsProjectFilePasswordPane passwordPane = new BEtsProjectFilePasswordPane();
        boolean bFinished = false;
        while (!bFinished) {
            int dialogResult = BDialog.open((BWidget)parent, (String)"Password protected ETS project file", (Object)((Object)passwordPane), (int)3);
            if (dialogResult == 2) {
                bFinished = true;
                continue;
            }
            if (dialogResult == 1) {
                try {
                    char[] password = passwordPane.getPassword();
                    return password;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    continue;
                }
            }
            throw new Exception("The \"Password protected ETS project file\" dialog returned a value (" + dialogResult + ") other than \"BDialog.OK\" (" + 1 + ") or \"BDialog.CANCEL\" (" + 2 + ").");
        }
        return null;
    }

    private static void promptToCheckInFuture(BAbstractManager manager, BImportedEtsProjectFile etsProjectFile, String dialogTitle) {
        int checkInFuture;
        if (etsProjectFile.getCheckForSourceFileChanges() && (checkInFuture = BDialog.confirm((BWidget)manager, (String)dialogTitle, (Object)"Continue checking this file in future?")) == 8) {
            etsProjectFile.setCheckForSourceFileChanges(false);
        }
    }

    public CommandArtifact doImport(BAbstractManager manager, String dialogTitle, boolean importOnly, Context cx) throws Exception {
        if (!(manager instanceof IImportEtsProjectFilesManager)) {
            throw new IllegalArgumentException("'manager' must implement the 'IImportEtsProjectFilesManager' interface.");
        }
        BImportEtsProjectFilePane importPane = new BImportEtsProjectFilePane(importOnly);
        boolean bFinished = false;
        while (!bFinished) {
            int dialogResult = BDialog.open((BWidget)manager, (String)dialogTitle, (Object)((Object)importPane), (int)3);
            if (dialogResult == 2) {
                bFinished = true;
                continue;
            }
            if (dialogResult == 1) {
                try {
                    BImportEtsProjectFileOptions importOptions = importPane.getImportOptions();
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("User clicked OK with options : " + importOptions.toDebugString());
                    }
                    bFinished = this.processImportOptions(manager, importOptions, cx);
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, "Could not import the selected file.\n\r" + ex.getMessage(), ex);
                    BDialog.error((BWidget)manager, (String)"Could not import the selected file.", (Object)ex.getMessage(), (Throwable)ex);
                }
                continue;
            }
            throw new Exception("The \"" + dialogTitle + "\" dialog returned a value (" + dialogResult + ") other than \"BDialog.OK\" (" + 1 + ") or \"BDialog.CANCEL\" (" + 2 + ").");
        }
        return null;
    }

    boolean processImportOptions(BAbstractManager manager, BImportEtsProjectFileOptions importOptions, Context cx) throws Exception {
        boolean bFinished;
        block33: {
            BOrd fileOrd;
            BIFile fileRef;
            String extension;
            BKnxWbService wbKnxSrv;
            block30: {
                boolean fromCache;
                BImportedEtsProjectFile etsProjectFile;
                block32: {
                    block31: {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Processing Import Options : " + importOptions.toString(cx));
                        }
                        bFinished = false;
                        wbKnxSrv = BKnxWbService.getService();
                        if (importOptions.getLoadFromFile()) break block30;
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Importing from cache against name \"" + importOptions.getNameInCache() + "\"");
                        }
                        if ((etsProjectFile = (BImportedEtsProjectFile)wbKnxSrv.getImportedFiles().get(importOptions.getNameInCache())) == null) {
                            throw new Exception("Cached item with name \"" + SlotPath.unescape((String)importOptions.getNameInCache()) + "\" not found in cache");
                        }
                        if (BKnxWbService.getImportSettings().getCheckForSourceFileChanges() && etsProjectFile.getCheckForSourceFileChanges()) {
                            etsProjectFile.verifyEtsProjectFile();
                        }
                        fromCache = true;
                        if (!etsProjectFile.getImportState().equals((Object)BEtsProjectFileImportStateEnum.importComplete)) break block31;
                        switch (etsProjectFile.getLastVerificationResult().getOrdinal()) {
                            case 2: {
                                ImportEtsProjectFilesController.promptToCheckInFuture(manager, etsProjectFile, "Source File Not Found");
                                break block32;
                            }
                            case 3: {
                                int reimport = BDialog.confirm((BWidget)manager, (String)"Source File Has Changed", (Object)"Do you want to re-import the file?", (int)14);
                                switch (reimport) {
                                    case 4: {
                                        fromCache = false;
                                        break block32;
                                    }
                                    case 8: {
                                        break block32;
                                    }
                                    case 2: {
                                        return true;
                                    }
                                    default: {
                                        throw new Exception("'Source File Has Changed' dialog returned an unexpected result - " + reimport);
                                    }
                                }
                            }
                            case 1: {
                                ImportEtsProjectFilesController.promptToCheckInFuture(manager, etsProjectFile, "Source File Verification Failed");
                                break block32;
                            }
                            case 0: {
                                BDialog.warning((BWidget)manager, (String)"Source File Has Not Been Verified", (Object)"The Source File has not been verified.");
                                break block32;
                            }
                            case 4: {
                                break block32;
                            }
                            default: {
                                throw new Exception("Unknown 'LastVerificationResult' - " + etsProjectFile.getLastVerificationResult().getOrdinal());
                            }
                        }
                    }
                    fromCache = false;
                }
                bFinished = this.processImportRequest((IImportEtsProjectFilesManager)manager, fromCache, etsProjectFile, cx);
                break block33;
            }
            if (log.isLoggable(Level.FINE)) {
                String charset = importOptions.getProjectFilenameCharset();
                log.fine("Importing from file [\"" + importOptions.getSourceFileOrd() + "\"] with cache name: [" + importOptions.getNameInCache() + "], with charset: [" + (charset.isEmpty() ? "default" : charset) + ']');
            }
            if (!EtsUtil.validEtsProjectFileExtension(extension = (fileRef = (BIFile)(fileOrd = BOrd.make((BOrd)BLocalHost.INSTANCE.getAbsoluteOrd(), (BOrd)importOptions.getSourceFileOrd())).get()).getExtension())) {
                BDialog.error((BWidget)manager, (String)"Unsupported File Extension", (Object)("The file extension \"" + extension + "\" is not supported, only \"knxproj\" file extensions are supported."));
            } else {
                BImportedEtsProjectFiles cachedProjects = wbKnxSrv.getImportedFiles();
                BImportedEtsProjectFile etsProjectFile = cachedProjects.getEntryForFile(fileOrd.relativizeToHost());
                if (etsProjectFile == null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Not found in cache");
                    }
                    etsProjectFile = new BImportedEtsProjectFile();
                    etsProjectFile.setEtsProjectFileOrd(fileOrd.relativizeToHost());
                    Property existingProject = cachedProjects.getProperty(SlotPath.escape((String)importOptions.getNameInCache()));
                    if (existingProject != null) {
                        int replacePrevious = BDialog.confirm((BWidget)manager, (String)"'Name' already exists in Import Cache", (Object)"There is already an entry with the same 'Name' in the Imported Files Cache, but it was imported from a different folder.\n\rDo you want to over-write it with this new file?", (int)14);
                        switch (replacePrevious) {
                            case 4: {
                                cachedProjects.remove(SlotPath.escape((String)importOptions.getNameInCache()));
                                break;
                            }
                            case 8: {
                                return false;
                            }
                            case 2: {
                                return true;
                            }
                            default: {
                                throw new Exception("'\"Name\" already exists in Import Cache' dialog returned an unexpected result - " + replacePrevious);
                            }
                        }
                    }
                    cachedProjects.add(SlotPath.escape((String)importOptions.getNameInCache()), (BValue)etsProjectFile);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Added to cached projects as -> " + etsProjectFile.getName());
                    }
                } else {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Located in cache under \"" + SlotPath.escape((String)etsProjectFile.getName()) + "\"");
                    }
                    cachedProjects.rename(etsProjectFile.getPropertyInParent(), SlotPath.escape((String)importOptions.getNameInCache()));
                }
                etsProjectFile.setProjectFilenameCharset(importOptions.getProjectFilenameCharset());
                etsProjectFile.verifyEtsProjectFile();
                bFinished = this.processImportRequest((IImportEtsProjectFilesManager)manager, false, etsProjectFile, cx);
                BKnxWbService.getImportSettings().setLastUsedKNXFileOrd(BOrd.make((String)importOptions.getSourceFileOrd().toString()));
                wbKnxSrv.doSaveImportCache();
            }
        }
        BKnxWbService.getImportSettings().setLastPointsDiscoveryFromCache(!importOptions.getLoadFromFile());
        BKnxWbService.getImportSettings().setLastUsedCachedFile(SlotPath.unescape((String)importOptions.getNameInCache()));
        BKnxWbService.getImportSettings().setLastAltProjectFilenameCharset(importOptions.getProjectFilenameCharset());
        BKnxWbService.doSaveSettings();
        return bFinished;
    }

    private boolean processImportRequest(IImportEtsProjectFilesManager manager, boolean fromCache, BImportedEtsProjectFile etsProjectFile, Context cx) throws Exception {
        try {
            manager.clearDiscoveredRows();
            String filePath = etsProjectFile.getEtsProjectFileOrd().encodeToString();
            if (EtsUtil.validEtsProjectFilename(filePath)) {
                return this.processEtsProjectImportRequest(manager, fromCache, etsProjectFile, cx);
            }
            throw new EtsImportException(EtsUtil.invalidEtsProjectFileName(filePath));
        }
        catch (Exception ex) {
            throw new Exception("An Exception occurred in " + this.getClass().getName() + ":processImportRequest(...)." + "\n\r" + ex.getMessage(), ex);
        }
    }

    private boolean processEtsProjectImportRequest(IImportEtsProjectFilesManager manager, boolean fromCache, BImportedEtsProjectFile etsProjectFile, Context cx) throws Exception {
        try {
            BJob job;
            MgrLearn learn;
            BEtsProjectFileImportJob knxImportJob = BEtsProjectFileImportJob.make(etsProjectFile, manager instanceof IKnxDeviceManager, BKnxWbService.getImportSettings());
            knxImportJob.setEtsProjectFileOrd(etsProjectFile.getSlotPathOrd());
            knxImportJob.setUseCachedData(fromCache);
            if (!fromCache) {
                ImportProblemReports importProblemReports;
                if (manager instanceof BKnxPointManager) {
                    knxImportJob.setDiscoveredPoints(((BKnxPointManager)manager).discoveredPoints);
                }
                if (manager instanceof IKnxDeviceManager) {
                    knxImportJob.setDiscoveredDevices(((IKnxDeviceManager)manager).getDiscoveredDevices());
                }
                if (!knxImportJob.validateEtsProjectFile()) {
                    if (knxImportJob.isPasswordNeeded()) {
                        char[] password = ImportEtsProjectFilesController.doPromptForPassword((BWidget)manager.asComponent());
                        if (password == null) {
                            return false;
                        }
                        knxImportJob.setPassword(password);
                        knxImportJob.validateEtsProjectFile();
                    } else {
                        knxImportJob.getImportProblemReports().add("Project file could not be validated, file may be invalid or corrupted, or contain filenames in a non-default encoding");
                    }
                }
                if (!(importProblemReports = knxImportJob.getImportProblemReports()).isEmpty()) {
                    BDialog.error((BWidget)((BWidget)manager), (String)"Cannot validate source file", (Object)importProblemReports.getImportProblemReportString());
                    return false;
                }
            }
            if ((learn = ((BAbstractManager)manager).getLearn()) != null && (job = learn.getJob()) != null) {
                if (job.getJobState().isRunning()) {
                    job.cancel();
                }
                job.dispose();
            }
            BOrd jobOrd = knxImportJob.submit(cx);
            if (learn != null) {
                learn.setJob(jobOrd);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Submitted ETS project file import job.");
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception("An Exception occurred in " + this.getClass().getName() + ":processEtsProjectImportRequest(...).", ex);
        }
    }
}

