/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator.baja;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.migrator.BBogMigrator;
import com.tridium.migrator.MigReportUtil;
import com.tridium.migrator.Migrate;
import com.tridium.migrator.MigrationUtils;
import com.tridium.nre.security.AESDecryptFunction;
import com.tridium.nre.security.EncryptionKeySource;
import com.tridium.security.AxPasswordUtil;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import javax.baja.io.ValueDocDecoder;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.security.PasswordEncodingContext;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

@NiagaraType
public class BClientPasswordConverter
extends BComponent
implements BIBogElementConverter {
    @Generated
    public static final Type TYPE = Sys.loadType(BClientPasswordConverter.class);
    private static final List<String> convertTypes = new ArrayList<String>();
    private static final String OLD_USERNAME_PROP = "username";
    private static final String OLD_PASSWORD_PROP = "password";
    private static final String DEFAULT_AX_PASSKEY = "niagara";
    private static final String TYPE_BPASSWORD = "b:Password";
    private static final PasswordEncodingContext NO_PASSWORD_TRANSCODING;
    private static final Lexicon lex;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public List<String> getConvertTypes() {
        return convertTypes;
    }

    public XElem convertXElem(XElem x, String typeSpecName, Version sourceVersion) throws Exception {
        String[] moduleAndType = typeSpecName.split(":");
        String moduleName = moduleAndType[0];
        String typeName = moduleAndType[1];
        switch (moduleName) {
            case "baja": {
                switch (typeName) {
                    case "UsernameAndPassword": {
                        BClientPasswordConverter.findAndConvert(x, OLD_PASSWORD_PROP, typeSpecName);
                        break;
                    }
                    case "Password": {
                        try {
                            BClientPasswordConverter.convertPasswordProp(x);
                            MigrationUtils.logInfo("clientPasswordConverter.convertedPassword", MigReportUtil.getReportName(x));
                        }
                        catch (Exception e) {
                            MigrationUtils.logWarning("clientPasswordConverter.couldNotDecryptPassword", typeSpecName, MigReportUtil.getReportName(x), e);
                            BBogMigrator.addConverterMessage(lex.getText("clientPasswordConverter.passwordDecryptionFailed"));
                        }
                        break;
                    }
                    case "PasswordHistory": {
                        try {
                            BClientPasswordConverter.convertPasswordHistoryProp(x);
                            MigrationUtils.logInfo("clientPasswordConverter.convertedPasswordHistory", MigReportUtil.getReportName(x));
                            break;
                        }
                        catch (Exception e) {
                            MigrationUtils.logWarning("clientPasswordConverter.couldNotDecryptPasswordHistory", typeSpecName, MigReportUtil.getReportName(x), e);
                        }
                    }
                }
                break;
            }
            case "email": {
                if (!typeName.equals("IncomingAccount") && !typeName.equals("OutgoingAccount")) break;
                BClientPasswordConverter.findAndConvert(x, OLD_PASSWORD_PROP, typeSpecName);
                break;
            }
            case "fox": {
                if (!typeName.equals("FoxClientConnection")) break;
                BClientPasswordConverter.addUsernameType(x, typeSpecName);
                BClientPasswordConverter.findAndConvert(x, OLD_PASSWORD_PROP, typeSpecName);
                break;
            }
            case "naxisVideo": {
                if (typeName.equals("AxisUserNameAndPassword")) {
                    BClientPasswordConverter.findAndConvert(x, OLD_PASSWORD_PROP, typeSpecName);
                    break;
                }
                if (!typeName.equals("AxisVideoCamera")) break;
                BClientPasswordConverter.findAndConvert(x, "rtspPassword", typeSpecName);
                break;
            }
            case "nmilestone": {
                if (!typeName.equals("MilestoneImageServerUserNameAndPassword")) break;
                BClientPasswordConverter.findAndConvert(x, OLD_PASSWORD_PROP, typeSpecName);
                break;
            }
            case "obixDriver": {
                if (!typeName.equals("ObixClient") && !typeName.equals("R2ObixClient")) break;
                BClientPasswordConverter.findAndConvert(x, "authPass", typeSpecName);
                break;
            }
            case "opc": {
                if (!typeName.equals("OpcDASecurity")) break;
                BClientPasswordConverter.findAndConvert(x, "loginPassword", typeSpecName);
                break;
            }
            case "rdb": {
                if (typeName.equals("RdbmsHistoryExport")) {
                    BClientPasswordConverter.findAndConvert(x, OLD_PASSWORD_PROP, typeSpecName);
                }
                if (!typeName.equals("RdbSecuritySettings")) break;
                BClientPasswordConverter.findAndConvertOrAddDefault(x, "passkey", BPassword.make((String)DEFAULT_AX_PASSKEY).encodeToString(null), typeSpecName);
                break;
            }
            case "rdbHsqlDb": {
                if (!typeName.equals("HsqlDatabase")) break;
                BClientPasswordConverter.findAndConvertOrAddDefault(x, OLD_PASSWORD_PROP, BPassword.make((String)"").encodeToString(null), typeSpecName);
                break;
            }
            case "rdbMySQL": {
                if (!typeName.equals("MySQLDatabase")) break;
                BClientPasswordConverter.findAndConvert(x, OLD_PASSWORD_PROP, typeSpecName);
                break;
            }
            case "rdbOracle": {
                if (!typeName.equals("OracleDatabase")) break;
                BClientPasswordConverter.findAndConvert(x, OLD_PASSWORD_PROP, typeSpecName);
                break;
            }
            case "rdbSqlServer": {
                if (!typeName.equals("SqlServerDatabase")) break;
                BClientPasswordConverter.findAndConvert(x, OLD_PASSWORD_PROP, typeSpecName);
            }
        }
        return x;
    }

    public static void findAndConvert(XElem x, String pwdPropName, String typeSpecName) throws Exception {
        try {
            for (XElem p : x.elems("p")) {
                String n = p.get("n", "");
                if (!n.equals(pwdPropName)) continue;
                BClientPasswordConverter.convertPasswordProp(p);
                MigrationUtils.logInfo("clientPasswordConverter.convertedPasswordProp", n, MigReportUtil.getReportName(x), typeSpecName);
            }
        }
        catch (Exception e) {
            MigrationUtils.logWarning("clientPasswordConverter.couldNotDecryptPasswordProp", pwdPropName, typeSpecName, MigReportUtil.getReportName(x), e);
        }
    }

    public static void findAndConvertOrAddDefault(XElem x, String pwdPropName, String pwdPropValue, String typeSpecName) throws Exception {
        try {
            boolean propFound = false;
            for (XElem p : x.elems("p")) {
                String n = p.get("n", "");
                if (!n.equals(pwdPropName)) continue;
                BClientPasswordConverter.convertPasswordProp(p);
                propFound = true;
                MigrationUtils.logInfo("clientPasswordConverter.convertedPasswordProp", n, MigReportUtil.getReportName(x), typeSpecName);
            }
            if (!propFound) {
                XElem elem = new XElem("p");
                elem.setAttr("n", pwdPropName);
                elem.setAttr("t", TYPE_BPASSWORD);
                elem.setAttr("v", pwdPropValue);
                x.addContent((XContent)elem);
            }
        }
        catch (Exception e) {
            MigrationUtils.logWarning("clientPasswordConverter.couldNotDecryptPasswordProp", pwdPropName, typeSpecName, MigReportUtil.getReportName(x), e);
        }
    }

    private static void convertPasswordProp(XElem x) throws Exception {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Decoding password...");
        }
        BPassword toEncode = AxPasswordUtil.decodeAxPassword((String)x.get("v", ""), (AESDecryptFunction)Migrate.getPasswordDecryptFunction());
        x.setAttr("v", toEncode.encodeToString(null));
    }

    private static void convertPasswordHistoryProp(XElem x) throws Exception {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Decoding password history...");
        }
        ArrayList<String> n4EncodedPasswords = new ArrayList<String>();
        for (String axEncodedPassword : TextUtil.split((String)new String(Base64.getDecoder().decode(x.get("v", "")), StandardCharsets.UTF_8), (char)'|')) {
            n4EncodedPasswords.add(AxPasswordUtil.decodeAxPassword((String)axEncodedPassword, (AESDecryptFunction)Migrate.getPasswordDecryptFunction()).encodeToString(null));
        }
        x.setAttr("v", Base64.getEncoder().encodeToString(String.join((CharSequence)"|", n4EncodedPasswords).getBytes(StandardCharsets.UTF_8)));
    }

    private static void addUsernameType(XElem x, String typeSpecName) {
        for (XElem p : x.elems("p")) {
            String t;
            String n = p.get("n", "");
            if (!n.equals(OLD_USERNAME_PROP) || !(t = p.get("t", "")).equals("")) continue;
            p.setAttr("t", "b:String");
            MigrationUtils.logInfo("clientPasswordConverter.addedTypeToProp", n, MigReportUtil.getReportName(x), typeSpecName);
        }
    }

    public void convertComplex(BComponent root, ValueDocDecoder.ITypeResolver resolver, BComplex toConvert, Version sourceVersion) throws Exception {
        if (toConvert instanceof BFoxClientConnection) {
            BFoxClientConnection conn = (BFoxClientConnection)toConvert;
            BString username = (BString)conn.get(OLD_USERNAME_PROP);
            BPassword password = (BPassword)conn.get(OLD_PASSWORD_PROP);
            if (username != null) {
                conn.remove(OLD_USERNAME_PROP);
                log.info(String.format("BFoxClientConnection: removing %s from component %s [%s]. Moving to new credentials property.", OLD_USERNAME_PROP, conn, conn.getType()));
            }
            if (password != null) {
                conn.remove(OLD_PASSWORD_PROP);
                log.info(String.format("BFoxClientConnection: removing %s from component %s [%s]. Moving to new credentials property.", OLD_PASSWORD_PROP, conn, conn.getType()));
            }
            String userStr = username != null ? username.getString() : "";
            password = password != null ? password : BPassword.DEFAULT;
            conn.setCredentials((BIUserCredentials)new BUsernameAndPassword(userStr, password));
        }
    }

    static {
        convertTypes.add("baja:Password");
        convertTypes.add("baja:PasswordHistory");
        convertTypes.add("baja:UsernameAndPassword");
        convertTypes.add("email:EmailAccount");
        convertTypes.add("fox:FoxClientConnection");
        convertTypes.add("naxisVideo:AxisUserNameAndPassword");
        convertTypes.add("naxisVideo:AxisVideoCamera");
        convertTypes.add("nmilestone:MilestoneImageServerUserNameAndPassword");
        convertTypes.add("obixDriver:ObixClient");
        convertTypes.add("opc:OpcDASecurity");
        convertTypes.add("rdb:RdbmsHistoryExport");
        convertTypes.add("rdb:RdbSecuritySettings");
        convertTypes.add("rdb:Rdbms");
        NO_PASSWORD_TRANSCODING = new PasswordEncodingContext(null, EncryptionKeySource.none, EncryptionKeySource.none, Optional.empty(), Optional.empty());
        lex = Lexicon.make((String)"migrator");
    }
}

