/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator.baja;

import com.tridium.migrator.MigConst;
import com.tridium.migrator.MigrationUtils;
import com.tridium.util.CompUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.baja.category.BCategoryMask;
import javax.baja.file.BIFile;
import javax.baja.file.BITemplate;
import javax.baja.io.ValueDocDecoder;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.FileUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BServiceContainer;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

@NiagaraType
public class BServiceContainerConverter
extends BObject
implements BIBogElementConverter,
MigConst {
    @Generated
    public static final Type TYPE = Sys.loadType(BServiceContainerConverter.class);
    private static final List<String> convertTypes = new ArrayList<String>();
    static BCategoryMask ADMIN;
    private static Lexicon lex;
    private BIFile migrationTemplate = null;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public List<String> getConvertTypes() {
        return convertTypes;
    }

    public void convertComplex(BComponent root, ValueDocDecoder.ITypeResolver resolver, BComplex toConvert, Version sourceVersion) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("BServiceContainerConverter.convertComplex(): root=" + root + "; toConvert=" + toConvert);
        }
        if (!(toConvert instanceof BServiceContainer)) {
            return;
        }
        BServiceContainer services = (BServiceContainer)toConvert;
        if (root.getComponentSpace() != null && root.getType().is(BStation.TYPE)) {
            try {
                services.checkParentForRestrictedComponent(services.getParent().asComponent(), (Context)null);
            }
            catch (Throwable t) {
                try {
                    services.fw(15, (Object)log, null, null, null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            if (services != ((BStation)root).getServices()) {
                return;
            }
        }
        if (this.migrationTemplate == null) {
            this.migrationTemplate = BServiceContainerConverter.promptUserForStationType();
            log.info(MessageFormat.format(lex.getText("serviceContainerConverter.templateSelected"), this.migrationTemplate));
        }
        List<BIService> templateServices = this.getServices(this.migrationTemplate);
        templateServices.stream().filter(service -> ((BIService[])CompUtil.getDescendants((BComponent)services, service.getClass())).length == 0).forEach(service -> services.add(((BComponent)service.as(BComponent.class)).getName(), (BValue)service.as(BComponent.class)));
        this.forceCat(services, "RoleService");
        this.forceCat(services, "AuditHistory");
        this.forceCat(services, "AuthenticationService");
        this.forceCat(services, "LoggingService");
    }

    private void forceCat(BServiceContainer services, String service) {
        BComponent v = (BComponent)services.get(service);
        if (v != null) {
            v.setCategoryMask(ADMIN, null);
        }
    }

    List<BIService> getServices(BIFile migTemplate) {
        ArrayList<BIService> services = new ArrayList<BIService>();
        try {
            BIService[] templateServices;
            BITemplate template = (BITemplate)migTemplate;
            BComponent root = template.getBaseComponent();
            if (!root.getType().is(BStation.TYPE)) {
                throw new IllegalArgumentException("Migration template " + migTemplate + " is not a station template");
            }
            BStation station = (BStation)root;
            BServiceContainer serviceContainer = ((BServiceContainer[])station.getChildren(BServiceContainer.class))[0];
            for (BIService service : templateServices = (BIService[])serviceContainer.getChildren(BIService.class)) {
                services.add((BIService)((BComponent)service.as(BComponent.class)).newCopy(true).as(BIService.class));
            }
        }
        catch (Exception e) {
            log.warning(MessageFormat.format(lex.getText("serviceContainerConverter.migTemplateMisconfig"), migTemplate, e));
        }
        return services;
    }

    public void setMigrationTemplate(BIFile migrationTemplate) {
        this.migrationTemplate = migrationTemplate;
    }

    public BIFile getMigrationTemplate() {
        return this.migrationTemplate;
    }

    public static BIFile promptUserForStationType() {
        BIFile selection;
        BIFile[] templates = MigrationUtils.getMigStationTemplates();
        if (templates == null || templates.length == 0) {
            throw new IllegalStateException("No migration templates found!");
        }
        if (templates.length == 1) {
            return templates[0];
        }
        BServiceContainerConverter.printStationTemplateTypes();
        while (true) {
            System.out.println(lex.getText("serviceContainerConverter.systemShortcuts"));
            System.out.print(lex.getText("serviceContainerConverter.selectMigrationTemplate") + " ");
            try {
                String userSel = MigrationUtils.getUserInput();
                if (userSel.equals("c")) {
                    selection = templates[0];
                    break;
                }
                if (userSel.equals("s")) {
                    selection = templates[1];
                    break;
                }
                int selectBase1 = Integer.parseInt(userSel);
                BIFile selectedTemplate = templates[selectBase1 - 1];
                System.out.println(MessageFormat.format(lex.getText("serviceContainerConverter.templateSelected"), selectedTemplate.getFileName()));
                selection = templates[selectBase1 - 1];
            }
            catch (Exception ignored) {
                System.out.println(MessageFormat.format(lex.getText("serviceContainerConverter.invalidSelection"), templates.length));
                System.out.println();
                continue;
            }
            break;
        }
        return selection;
    }

    public static void printStationTemplateTypes() {
        int i;
        BIFile[] migrationTemplates = MigrationUtils.getMigStationTemplates();
        String[] friendlies = new String[migrationTemplates.length];
        System.out.println(lex.getText("serviceContainerConverter.migrationTemplates"));
        int max = 0;
        for (i = 0; i < migrationTemplates.length; ++i) {
            friendlies[i] = "   " + (i + 1) + ": " + TextUtil.toFriendly((String)FileUtil.getBase((String)migrationTemplates[i].getFileName()));
            if (friendlies[i].length() <= max) continue;
            max = friendlies[i].length();
        }
        for (i = 0; i < migrationTemplates.length; ++i) {
            System.out.println(TextUtil.pad((String)friendlies[i], (int)max) + "  (" + migrationTemplates[i].getFileName() + ")");
        }
    }

    static {
        convertTypes.add("baja:ServiceContainer");
        ADMIN = BCategoryMask.make((String)"2");
        lex = Lexicon.make((String)"migrator");
    }
}

