/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator.history;

import com.tridium.migrator.baja.BRestrictedServiceConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.baja.io.ValueDocDecoder;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;
import javax.baja.xml.XElem;

@NiagaraType
public class BLogHistoryServiceConverter
extends BObject
implements BIBogElementConverter {
    @Generated
    public static final Type TYPE = Sys.loadType(BLogHistoryServiceConverter.class);
    private static final List<String> convertTypes = new ArrayList<String>();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public List<String> getConvertTypes() {
        return convertTypes;
    }

    public XElem convertXElem(XElem x, String typeName, Version sourceVersion) {
        XElem[] els;
        for (XElem element : els = x.elems()) {
            if (!element.get("n", "").equals("minimumSeverity")) continue;
            String oldSeverityValue = element.get("v", "");
            String newSeverityValue = this.updateSeverityValue(oldSeverityValue);
            if (newSeverityValue == null) {
                log.info("No matching severity level(java's severity level) was found for baja's severity level while migrating to N4.Setting it to default(info)");
                element.setAttr("v", "info");
                continue;
            }
            element.setAttr("v", newSeverityValue);
        }
        return x;
    }

    public void convertComplex(BComponent root, ValueDocDecoder.ITypeResolver resolver, BComplex toConvert, Version sourceVersion) {
        BRestrictedServiceConverter.checkRestrictedService(root, toConvert);
    }

    private String updateSeverityValue(String oldSeverityValue) {
        switch (oldSeverityValue) {
            case "message": {
                return Level.INFO.toString().toLowerCase();
            }
            case "trace": {
                return Level.FINE.toString().toLowerCase();
            }
            case "warning": {
                return Level.WARNING.toString().toLowerCase();
            }
            case "error": {
                return Level.SEVERE.toString().toLowerCase();
            }
        }
        return null;
    }

    public String toString(Context c) {
        return "LogHistoryServiceConverter";
    }

    static {
        convertTypes.add("history:LogHistoryService");
    }
}

