/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator.ldap;

import com.tridium.migrator.Migrate;
import com.tridium.nre.security.AESDecryptFunction;
import com.tridium.nre.security.SecretBytes;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Optional;
import javax.baja.migration.BFileMigrator;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BKeytabMigrator
extends BFileMigrator {
    @Generated
    public static final Type TYPE = Sys.loadType(BKeytabMigrator.class);
    private static final String ENCRYPTION_PREFIX = "[aes]";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public String[] getMigrateDirs() {
        return new String[]{"ldap"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> migrate() throws Exception {
        File[] srcFiles = this.source.listFiles();
        if (srcFiles == null || srcFiles.length == 0) {
            return Optional.empty();
        }
        AESDecryptFunction decryptFunction = Migrate.getPasswordDecryptFunction();
        if (decryptFunction == null) {
            this.log.warning("Cannot decrypt keytabs, decrypt function unavailable.");
            FileUtil.copyDir((File)this.source, (File)this.target);
            return Optional.empty();
        }
        if (!this.target.exists() && !this.target.mkdirs()) {
            this.log.warning("Cannot decrypt keytabs, failed to create the migration target parent directory.");
            return Optional.empty();
        }
        for (File f : srcFiles) {
            if (f.isDirectory()) continue;
            String contents = FileUtil.readString((File)f);
            if (contents.startsWith(ENCRYPTION_PREFIX)) {
                try (SecretBytes raw = null;){
                    contents = contents.replace(ENCRYPTION_PREFIX, "");
                    String[] ivCipher = contents.split(":");
                    byte[] ivBytes = ByteArrayUtil.hexStringToBytes((String)ivCipher[0]);
                    byte[] cipherBytes = ByteArrayUtil.hexStringToBytes((String)ivCipher[1]);
                    raw = decryptFunction.decrypt(cipherBytes, ivBytes, "AES/CBC/PKCS5Padding");
                    try (FileOutputStream out = new FileOutputStream(new File(this.target, f.getName()));){
                        ((OutputStream)out).write(raw.get());
                        this.log.info("Keytab file " + f.getPath() + " successfully decrypted.");
                        continue;
                    }
                }
            }
            FileUtil.copy((File)f, (File)new File(this.target, f.getName()));
        }
        return Optional.empty();
    }
}

