/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.discover;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.nd.discover.HistoryLearnNodeInfo;
import java.util.ArrayList;
import java.util.List;
import javax.baja.history.BHistoryId;
import javax.baja.util.BNameList;

public class HistoryDeviceLearnNodeInfo
implements Comparable<HistoryDeviceLearnNodeInfo> {
    private final String deviceName;
    private final List<HistoryLearnNodeInfo> histories = new ArrayList<HistoryLearnNodeInfo>();

    public HistoryDeviceLearnNodeInfo(String deviceName) {
        if (deviceName == null) {
            throw new IllegalArgumentException("deviceName required");
        }
        this.deviceName = deviceName;
    }

    public void addDiscoveredHistory(BHistoryId historyId, BNameList systemTags) {
        this.histories.add(new HistoryLearnNodeInfo(historyId, systemTags));
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public HistoryLearnNodeInfo[] getHistories() {
        return this.histories.toArray(new HistoryLearnNodeInfo[0]);
    }

    public String toString() {
        return this.deviceName;
    }

    public JSONObject toJson() {
        JSONArray historiesJson = new JSONArray();
        for (HistoryLearnNodeInfo history : this.histories) {
            historiesJson.put((Object)history.toJson());
        }
        return new JSONObject().put("n", (Object)this.deviceName).put("h", (Object)historiesJson);
    }

    @Override
    public int compareTo(HistoryDeviceLearnNodeInfo o) {
        return this.deviceName.compareTo(o.deviceName);
    }
}

