/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.history;

import com.tridium.driver.util.DrUtil;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.history.fox.BHistoryChannel;
import com.tridium.nd.BNiagaraEdgeLiteStation;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.history.BArchiveChannel;
import com.tridium.nd.history.BNiagaraHistoryDeviceExt;
import com.tridium.sys.metrics.BISubLicenseable;
import javax.baja.driver.BDevice;
import javax.baja.driver.history.BHistoryExport;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BHistorySummary;
import javax.baja.history.BIHistory;
import javax.baja.history.HistoryNotFoundException;
import javax.baja.history.HistoryQuery;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
public class BNiagaraHistoryExport
extends BHistoryExport
implements BFoxClientConnection.Interest,
BISubLicenseable {
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraHistoryExport.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        BNiagaraStation station = (BNiagaraStation)this.getDevice();
        if (station != null) {
            station.getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
        }
        return null;
    }

    public boolean isUnoperational() {
        return this.isFatalFault() || this.isDisabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute() {
        this.executeInProgress();
        BNiagaraHistoryDeviceExt devicelet = (BNiagaraHistoryDeviceExt)this.getDeviceExt();
        try {
            devicelet.getClientConnection().engageNoRetry((BFoxClientConnection.Interest)this);
        }
        catch (Exception e) {
            this.executeFail(e);
            if (devicelet.getClientConnection().isEngaged((BFoxClientConnection.Interest)this)) {
                devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
            }
            return;
        }
        try {
            if (this.getHistoryId().isNull()) {
                this.executeFail();
                return;
            }
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase db = service.getDatabase();
            if (db == null) {
                this.executeFail();
                return;
            }
            BArchiveChannel archiveChannel = devicelet.getClientArchiveChannel();
            BHistoryChannel historyChannel = devicelet.getClientHistoryChannel();
            BHistoryId id = this.getHistoryId().fromShorthand(Sys.getStation().getStationName());
            try (HistoryDatabaseConnection conn = db.getDbConnection(HistoryQuery.makeExcludeArchiveDataContext(null));){
                BIHistory history = conn.getHistory(id);
                if (history == null) {
                    throw new HistoryNotFoundException();
                }
                BHistorySummary summary = historyChannel.getSummary(id);
                if (summary == null) {
                    archiveChannel.createHistory(history.getConfig());
                } else {
                    archiveChannel.updateConfig(history.getConfig());
                }
                Object startTime = null;
                if (summary != null) {
                    startTime = summary.getLastTimestamp();
                    startTime = startTime.isNull() ? null : startTime.add(BRelTime.make((long)1L));
                }
                historyChannel.append(id, (Cursor)conn.timeQuery(history, startTime, null).cursor());
            }
            this.executeOk();
        }
        catch (Exception e) {
            this.executeFail(e);
        }
        finally {
            devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
        }
    }

    public final String getLicenseKeyPrefix() {
        BDevice parentDevice = null;
        try {
            parentDevice = this.getDevice();
        }
        catch (Exception e) {
            parentDevice = (BDevice)DrUtil.getParent((BComplex)this, (Type)BDevice.TYPE);
        }
        if (BISubLicenseable.isSubLicenseable((BObject)parentDevice)) {
            if (parentDevice instanceof BNiagaraEdgeLiteStation) {
                return "edgeLite1";
            }
            return ((BISubLicenseable)parentDevice).getLicenseKeyPrefix();
        }
        return null;
    }
}

