/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.point;

import com.tridium.dataRecovery.BDataRecoveryComponentRecorder;
import com.tridium.driver.util.DrUtil;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.data.BDataChannel;
import com.tridium.fox.sys.spy.FoxLog;
import com.tridium.nd.BNiagaraEdgeLiteStation;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BNiagaraPointDeviceExt;
import com.tridium.nd.point.BNiagaraTuningPolicy;
import com.tridium.nd.point.BPointChannel;
import com.tridium.nv.NiagaraVirtualUtil;
import com.tridium.nv.point.BSubscriptionState;
import com.tridium.nv.point.BVirtualAction;
import com.tridium.nv.point.INiagaraProxyExt;
import com.tridium.nv.point.IProxyActionParent;
import com.tridium.nv.point.NiagaraProxyExtSupport;
import com.tridium.sys.metrics.BISubLicenseable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Flags;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="writeValue", type="BStatusValue", defaultValue="BProxyExt.writeValue.getDefaultValue()", flags=4, override=true), @NiagaraProperty(name="pointId", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="subscriptionStatus", type="String", defaultValue="-", flags=3)})
@NiagaraActions(value={@NiagaraAction(name="forceUpdate"), @NiagaraAction(name="getProxyActionDefault", parameterType="BString", defaultValue="BString.DEFAULT", returnType="BValue", flags=260), @NiagaraAction(name="updateSubscriptionStatus", flags=20)})
public class BNiagaraProxyExt
extends BProxyExt
implements BISubLicenseable,
INiagaraProxyExt,
IProxyActionParent {
    @Generated
    public static final Property writeValue = BNiagaraProxyExt.newProperty((int)4, (BValue)BProxyExt.writeValue.getDefaultValue(), null);
    @Generated
    public static final Property pointId = BNiagaraProxyExt.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property subscriptionStatus = BNiagaraProxyExt.newProperty((int)3, (String)"-", null);
    @Generated
    public static final Action forceUpdate = BNiagaraProxyExt.newAction((int)0, null);
    @Generated
    public static final Action getProxyActionDefault = BNiagaraProxyExt.newAction((int)260, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Action updateSubscriptionStatus = BNiagaraProxyExt.newAction((int)20, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraProxyExt.class);
    private static final List<String> N_HISTORY_TAG_LIST = Collections.singletonList("n:history");
    static final String ESCAPED_N_HISTORY_TAG = SlotPath.escape((String)"n:history");
    public static final Version VER_4_2 = new Version("4.2");
    public static final String PERSIST_FETCHED_TAGS_PROP_NAME = "persistFetchedTags";
    private static FoxLog defaultLog = FoxLog.make((String)"fox.point");
    private FoxLog log = defaultLog;
    private final int messageId = NiagaraProxyExtSupport.newMessageId();
    private volatile BSubscriptionState subscriptionState = BSubscriptionState.unsubscribed;
    private volatile String subscriptionError;
    private boolean actionFetchRequired = true;
    private volatile String proxyExtSubStatus = "-";

    @Generated
    public String getPointId() {
        return this.getString(pointId);
    }

    @Generated
    public void setPointId(String v) {
        this.setString(pointId, v, null);
    }

    @Generated
    public String getSubscriptionStatus() {
        return this.getString(subscriptionStatus);
    }

    @Generated
    public void setSubscriptionStatus(String v) {
        this.setString(subscriptionStatus, v, null);
    }

    @Generated
    public void forceUpdate() {
        this.invoke(forceUpdate, null, null);
    }

    @Generated
    public BValue getProxyActionDefault(BString parameter) {
        return this.invoke(getProxyActionDefault, (BValue)parameter, null);
    }

    @Generated
    public void updateSubscriptionStatus() {
        this.invoke(updateSubscriptionStatus, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type getDeviceExtType() {
        return BNiagaraPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return BReadWriteMode.readonly;
    }

    public final BNiagaraPointDeviceExt getNiagaraPoints() {
        return (BNiagaraPointDeviceExt)this.getDeviceExt();
    }

    public final BNiagaraTuningPolicy getNiagaraTuningPolicy() {
        return (BNiagaraTuningPolicy)this.getTuningPolicy();
    }

    public final String getPointType() {
        BComplex parent = this.getParent();
        if (parent instanceof BBooleanPoint) {
            return "b";
        }
        if (parent instanceof BNumericPoint) {
            return "n";
        }
        if (parent instanceof BEnumPoint) {
            return "e";
        }
        return "s";
    }

    public Logger getLog() {
        return this.log.log();
    }

    public BNiagaraStation getNiagaraStation() {
        return (BNiagaraStation)this.getDevice();
    }

    public String getStationName() {
        return this.getNiagaraStation().getStationName();
    }

    public Object getStateLock() {
        return this.getNiagaraPointDeviceExt().stateLock;
    }

    public final BSubscriptionState getSubscriptionState() {
        return this.subscriptionState;
    }

    public final void setSubscriptionState(BSubscriptionState subscriptionState) {
        this.subscriptionState = subscriptionState;
    }

    public final String getSubscriptionError() {
        return this.subscriptionError;
    }

    public final void setSubscriptionError(String error) {
        NiagaraProxyExtSupport.setSubscriptionError((INiagaraProxyExt)this, (String)error);
    }

    public final void commitSubscriptionError(String error) {
        this.subscriptionError = error;
    }

    private void forceUnsubscribe() {
        if (!this.isRunning()) {
            return;
        }
        NiagaraProxyExtSupport.unsubscribed((INiagaraProxyExt)this);
    }

    public boolean isPointSubscribed() {
        return this.isParentPointSubscribed();
    }

    public int getMessageId() {
        return this.messageId;
    }

    public BNiagaraPointDeviceExt getNiagaraPointDeviceExt() {
        return this.getNiagaraPoints();
    }

    public void setProxySubscriptionStatus(String status) {
        this.proxyExtSubStatus = status;
        this.updateSubscriptionStatus();
    }

    void sessionClosed() {
        NiagaraProxyExtSupport.close((INiagaraProxyExt)this);
    }

    public final void sendingSubscribe() {
        NiagaraProxyExtSupport.sendingSubscribe((INiagaraProxyExt)this);
    }

    public final void sentSubscribe() {
        NiagaraProxyExtSupport.sentSubscribe((INiagaraProxyExt)this);
    }

    public final void sendingUnsubscribe() {
        NiagaraProxyExtSupport.sendingUnsubscribe((INiagaraProxyExt)this);
    }

    public final void sentUnsubscribe() {
        NiagaraProxyExtSupport.sentUnsubscribe((INiagaraProxyExt)this);
    }

    public final void pendingSubscribe() {
        NiagaraProxyExtSupport.pendingSubscribe((INiagaraProxyExt)this);
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (prop == pointId) {
            this.forceUnsubscribe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void started() throws Exception {
        super.started();
        ((BNiagaraStation)this.getDevice()).getPoints().registerProxyExt(this);
        BNiagaraPointDeviceExt points = null;
        try {
            points = this.getNiagaraPoints();
            this.log = points.getClientChannel().log;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (points == null) {
            return;
        }
        BControlPoint point = this.getParentPoint();
        if (point == null) {
            return;
        }
        Object object = points.stateLock;
        synchronized (object) {
            if (point.isWritablePoint()) {
                this.setSubscriptionError("Cannot use writable point");
                NiagaraProxyExtSupport.proxyError((INiagaraProxyExt)this);
            } else {
                NiagaraProxyExtSupport.unsubscribed((INiagaraProxyExt)this);
            }
        }
        if (Sys.isStationStarted() && this.persistFetchedTags() && !"n:history".equals(this.tagsToFetch()) && !point.isSubscribed()) {
            point.lease();
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        ((BNiagaraStation)this.getDevice()).getPoints().unregisterProxyExt(this);
        BNiagaraPointDeviceExt points = null;
        try {
            points = this.getNiagaraPoints();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (points == null) {
            return;
        }
        if (points.clientWorker != null) {
            points.clientWorker.stopped(this);
        }
    }

    public boolean write(Context cx) {
        return false;
    }

    public void readSubscribed(Context cx) {
        NiagaraProxyExtSupport.subscribed((INiagaraProxyExt)this);
    }

    public void readUnsubscribed(Context cx) {
        NiagaraProxyExtSupport.unsubscribed((INiagaraProxyExt)this);
    }

    public final void readValueOk(BValue newValue) {
        this.readOk((BStatusValue)newValue);
    }

    public boolean isActionFetchRequired() {
        return this.actionFetchRequired;
    }

    public void doForceUpdate(Context cx) {
        this.log.message("Force update " + NiagaraProxyExtSupport.toTraceString((INiagaraProxyExt)this));
        this.actionFetchRequired = true;
        NiagaraProxyExtSupport.unsubscribed((INiagaraProxyExt)this);
        BControlPoint point = this.getParentPoint();
        if (point != null) {
            point.lease();
        }
        if (this.persistFetchedTags() && this.getNiagaraPointDeviceExt().getClientConnection().getRemoteVersion().compareTo(VER_4_2) < 0) {
            this.fetchRemoteTags(N_HISTORY_TAG_LIST, cx);
        }
    }

    public BValue doGetProxyActionDefault(BString actionName) throws Exception {
        if (this.log.isTraceOn()) {
            this.log.trace("getProxyActionDefault " + actionName);
        }
        BVirtualAction action = (BVirtualAction)this.getParentPoint().get(actionName.toString());
        return this.getNiagaraPointDeviceExt().getClientChannel().getActionDefault(this, action);
    }

    public void updateActions(BVirtualAction[] actions) {
        BComponent actionParent = (BComponent)this.getParent();
        if (this.getLog().isLoggable(Level.FINE)) {
            this.getLog().fine("updateActions " + actionParent.getSlotPathOrd());
        }
        Property[] props = actionParent.getPropertiesArray();
        BNameMap origDisplayNames = null;
        for (Property prop : props) {
            BValue value = actionParent.get(prop);
            if (value instanceof BNameMap) {
                actionParent.remove(prop, BDataRecoveryComponentRecorder.SKIP_CRITICAL_CX);
                if (prop.getName().equals("displayNames")) {
                    origDisplayNames = (BNameMap)value;
                }
            }
            if (!(value instanceof BVirtualAction)) continue;
            actionParent.remove(prop, BDataRecoveryComponentRecorder.SKIP_CRITICAL_CX);
        }
        HashMap<String, BFormat> names = new HashMap<String, BFormat>();
        for (BVirtualAction a : actions) {
            String proxyActionName;
            String friendlyProxyActionName;
            String proxyActionDisplayName = a.getProxyActionDisplayName();
            if (!proxyActionDisplayName.equals(friendlyProxyActionName = TextUtil.toFriendly((String)(proxyActionName = a.getProxyActionName())))) {
                names.put(proxyActionName, BFormat.make((String)proxyActionDisplayName));
            } else {
                BFormat existing = null;
                if (origDisplayNames != null) {
                    existing = origDisplayNames.get(proxyActionName);
                }
                if (existing != null && existing.equals((Object)BFormat.make((String)proxyActionDisplayName))) {
                    origDisplayNames = BNameMap.remove((BNameMap)origDisplayNames, (String)proxyActionName);
                }
            }
            try {
                actionParent.add(a.getProxyActionName(), (BValue)a, a.getProxyActionFlags() | 0x10000);
            }
            catch (DuplicateSlotException e) {
                if (!this.getLog().isLoggable(Level.FINE)) continue;
                this.getLog().fine("Duplicate Slot detected when adding action \"" + a.getProxyActionName() + "\" on " + this.toPathString());
            }
            catch (Exception e) {
                this.getLog().log(Level.SEVERE, "Cannot add action \"" + a.getProxyActionName() + "\" on " + this.toPathString(), e);
            }
        }
        int nameMapFlags = 65797;
        actionParent.add("displayNames", (BValue)this.mergeDisplayNames(names, origDisplayNames), nameMapFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BValue invokeAction(BVirtualAction action, BValue arg) throws Exception {
        BPointChannel pointChannel = this.getNiagaraPoints().getClientChannel();
        if (pointChannel == null) {
            return null;
        }
        BFoxClientConnection connection = this.getNiagaraStation().getClientConnection();
        if (connection == null) {
            return null;
        }
        BFoxClientConnection.Interest interest = new BFoxClientConnection.Interest(){

            public String toString() {
                return "NiagaraProxyExt - invokeAction";
            }
        };
        BValue val = null;
        try {
            connection.engageNoRetry(interest);
            val = pointChannel.invoke(this, action, arg);
        }
        finally {
            connection.disengage(interest);
        }
        return val;
    }

    private BNameMap mergeDisplayNames(HashMap<String, BFormat> newNames, BNameMap origNames) {
        if (origNames == null) {
            return BNameMap.make(newNames);
        }
        if (newNames == null) {
            return origNames;
        }
        String[] keys = origNames.list();
        if (keys != null) {
            for (String key : keys) {
                newNames.put(key, origNames.get(key));
            }
        }
        return BNameMap.make(newNames);
    }

    public void doUpdateSubscriptionStatus() {
        this.setSubscriptionStatus(this.proxyExtSubStatus);
    }

    public String toString(Context cx) {
        return this.getPointId();
    }

    protected LinkCheck doCheckParentLink(BComponent source, Slot sourceSlot, Slot targetSlot, Context cx) {
        BValue val;
        if (this.isMounted()) {
            this.lease();
        }
        if (targetSlot.isProperty() && (val = this.get(targetSlot.asProperty())) != null && val instanceof BVirtualAction) {
            return LinkCheck.makeInvalid((String)Lexicon.make(((Object)((Object)this)).getClass()).get("cannotLinkToAction"));
        }
        return LinkCheck.makeValid();
    }

    public final String tagsToFetch() {
        String additionalTags;
        BString tagList = (BString)NiagaraVirtualUtil.lookupPropertyFromAncestry((BComplex)this, (String)"tagsToFetch", (Type)BString.TYPE, (Type)BNiagaraNetwork.TYPE);
        if (tagList != null && !(additionalTags = tagList.toString().trim()).isEmpty()) {
            return additionalTags + ';' + "n:history";
        }
        return "n:history";
    }

    public final boolean persistFetchedTags() {
        BBoolean persistTags = (BBoolean)NiagaraVirtualUtil.lookupPropertyFromAncestry((BComplex)this, (String)PERSIST_FETCHED_TAGS_PROP_NAME, (Type)BBoolean.TYPE, (Type)BNiagaraNetwork.TYPE);
        return persistTags != null && persistTags.getBoolean();
    }

    public final BComponent getProxyComponentToTag() {
        return this.getParentPoint();
    }

    @NiagaraRpc(permissions="r", transports={@Transport(type=TransportType.web), @Transport(type=TransportType.box), @Transport(type=TransportType.fox)})
    public Map<String, String> fetchRemoteTags(List<String> requestedTags, Context cx) {
        return BNiagaraProxyExt.doFetchRemoteTags(requestedTags, this, this.getNiagaraStation(), cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> doFetchRemoteTags(List<String> requestedTags, INiagaraProxyExt ext, BNiagaraStation station, Context cx) {
        Map<String, BIDataValue> tMap = BNiagaraProxyExt.doFetchRawRemoteTags(requestedTags, ext, station);
        if (tMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HistorySpaceConnection conn = null;
        try {
            if (tMap.containsKey("n:history")) {
                BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
                conn = service.getDatabase().getConnection(cx);
            }
        }
        catch (Throwable service) {
            // empty catch block
        }
        HistorySpaceConnection connRef = conn;
        try {
            Map<String, String> map = tMap.entrySet().stream().filter(e -> {
                if (connRef != null && ((String)e.getKey()).equals("n:history")) {
                    try {
                        BIHistory history = connRef.getHistory(BHistoryId.make((String)((BIDataValue)e.getValue()).encodeToString()));
                        return history.getPermissions(cx).hasOperatorRead();
                    }
                    catch (Throwable t) {
                        return false;
                    }
                }
                return true;
            }).collect(Collectors.toMap(Map.Entry::getKey, e -> {
                try {
                    return ((BIDataValue)e.getValue()).encodeToString();
                }
                catch (Throwable throwable) {
                    return null;
                }
            }));
            return map;
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, BIDataValue> doFetchRawRemoteTags(List<String> requestedTags, INiagaraProxyExt ext, BNiagaraStation station) {
        block34: {
            ArrayList<String> copy;
            List<String> validTagNames;
            if (!station.isRunning()) {
                throw new NotRunningException();
            }
            if (requestedTags == null || requestedTags.isEmpty()) {
                return Collections.emptyMap();
            }
            BComponent parentPoint = ext.getProxyComponentToTag();
            String interest = Integer.toString(ext.getMessageId());
            try {
                Property prop;
                if (station.isDisabled() || station.isFatalFault() || station.isDown() || ext.isDisabled()) {
                    throw new NotRunningException();
                }
                station.engageNoRetry(interest);
                if (station.getClientConnection().getRemoteVersion().compareTo(VER_4_2) >= 0) {
                    BPointChannel pointChannel = station.getPoints().getClientChannel();
                    if (pointChannel != null) {
                        validTagNames = Arrays.asList(ext.tagsToFetch().split(";"));
                        copy = new ArrayList<String>(requestedTags);
                        copy.retainAll(validTagNames);
                        if (!copy.isEmpty()) {
                            Map<String, BIDataValue> map = pointChannel.fetchRemoteTags(ext, String.join((CharSequence)";", copy));
                            return map;
                        }
                    }
                    break block34;
                }
                if (!requestedTags.contains("n:history")) break block34;
                String remoteId = null;
                BOrd ord = BOrd.make((String)("station:|" + ext.getComponentId() + "|bql:select historyConfig.id.encodeToString from history:HistoryExt depth = 1 where enabled"));
                BDataChannel channel = (BDataChannel)station.getClientConnection().getChannels().get("data", BDataChannel.TYPE);
                BITable table = (BITable)channel.resolve(ord, new String[0]);
                ColumnList columns = table.getColumns();
                Column idColumn = columns.get(0);
                try (Object cursor = table.cursor();){
                    if (cursor.next()) {
                        BHistoryId foundId = (BHistoryId)BHistoryId.DEFAULT.decodeFromString(cursor.cell(idColumn).toString());
                        if (foundId.isShorthand()) {
                            foundId = foundId.fromShorthand(station.getStationName());
                        }
                        remoteId = foundId.toString();
                    }
                }
                if (remoteId != null) {
                    if (ext.persistFetchedTags()) {
                        BPointChannel.addProxyTag((Entity)parentPoint, "n:history", (BIDataValue)BString.make(remoteId), 0, BFacets.NULL);
                    }
                    cursor = Collections.singletonMap("n:history", BString.make(remoteId));
                    return cursor;
                }
                if (ext.persistFetchedTags() && (prop = parentPoint.getProperty(ESCAPED_N_HISTORY_TAG)) != null && Flags.isReadonly((BComplex)parentPoint, (Slot)prop)) {
                    parentPoint.remove(prop);
                }
            }
            catch (Throwable t) {
                ext.getLog().log(Level.FINE, "Could not fetch remote tags for " + NiagaraProxyExtSupport.toTraceString((INiagaraProxyExt)ext), t);
                if (ext.persistFetchedTags()) {
                    validTagNames = Arrays.asList(ext.tagsToFetch().split(";"));
                    copy = new ArrayList<String>(requestedTags);
                    copy.retainAll(validTagNames);
                    if (!copy.isEmpty()) {
                        HashMap<String, BIDataValue> tagMap = new HashMap<String, BIDataValue>();
                        copy.forEach(tagName -> {
                            BValue val;
                            Property prop = parentPoint.getProperty(SlotPath.escape((String)tagName));
                            if (prop != null && Flags.isReadonly((BComplex)parentPoint, (Slot)prop) && Flags.isMetadata((BComplex)parentPoint, (Slot)prop) && (val = parentPoint.get(prop)).getType().is(BIDataValue.TYPE)) {
                                tagMap.put((String)tagName, (BIDataValue)val);
                            }
                        });
                        if (!tagMap.isEmpty()) {
                            ext.getLog().log(Level.FINE, "Using cached remote tags for " + NiagaraProxyExtSupport.toTraceString((INiagaraProxyExt)ext));
                        }
                        HashMap<String, BIDataValue> hashMap = tagMap;
                        return hashMap;
                    }
                }
            }
            finally {
                if (station != null) {
                    station.disengage(interest);
                }
            }
        }
        return Collections.emptyMap();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean localHistoryExists(String historyId) {
        try {
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            try (HistoryDatabaseConnection conn = service.getDatabase().getDbConnection(null);){
                BHistoryId id = BHistoryId.make((String)historyId);
                boolean bl = conn.exists(id);
                return bl;
            }
        }
        catch (Throwable throwable6) {
            return false;
        }
    }

    public final String getLicenseKeyPrefix() {
        BDevice parentDevice = null;
        try {
            parentDevice = this.getDevice();
        }
        catch (Exception e) {
            parentDevice = (BDevice)DrUtil.getParent((BComplex)this, (Type)BDevice.TYPE);
        }
        if (BISubLicenseable.isSubLicenseable((BObject)parentDevice)) {
            if (parentDevice instanceof BNiagaraEdgeLiteStation) {
                return "edgeLite1";
            }
            return ((BISubLicenseable)parentDevice).getLicenseKeyPrefix();
        }
        return null;
    }
}

