/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.sysdef;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxServerConnection;
import com.tridium.nd.BINiagaraDeviceExt;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BReachableStations;
import com.tridium.nd.sysdef.BRoleManager;
import com.tridium.nd.sysdef.BSyncTask;
import com.tridium.nd.sysdef.BSysDefChannel;
import java.util.logging.Logger;
import javax.baja.driver.BDeviceExt;
import javax.baja.nd.BStationRole;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=3), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3), @NiagaraProperty(name="roleManager", type="BRoleManager", defaultValue="new BRoleManager()"), @NiagaraProperty(name="syncTask", type="BSyncTask", defaultValue="new BSyncTask()"), @NiagaraProperty(name="reachableStations", type="BReachableStations", defaultValue="new BReachableStations()")})
public class BNiagaraSysDefDeviceExt
extends BDeviceExt
implements BINiagaraDeviceExt {
    @Generated
    public static final Property enabled = BNiagaraSysDefDeviceExt.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property status = BNiagaraSysDefDeviceExt.newProperty((int)3, (BValue)BStatus.ok, null);
    @Generated
    public static final Property faultCause = BNiagaraSysDefDeviceExt.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property roleManager = BNiagaraSysDefDeviceExt.newProperty((int)0, (BValue)new BRoleManager(), null);
    @Generated
    public static final Property syncTask = BNiagaraSysDefDeviceExt.newProperty((int)0, (BValue)new BSyncTask(), null);
    @Generated
    public static final Property reachableStations = BNiagaraSysDefDeviceExt.newProperty((int)0, (BValue)new BReachableStations(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraSysDefDeviceExt.class);
    private static BIcon icon = BIcon.std((String)"navOnly/sysDef.png");
    private static final Logger log = Logger.getLogger("niagara.sysdef");
    private BStatus prevStatus = BStatus.ok;
    private Version remoteSysDefVersion = Version.NULL;
    private boolean remoteIsCompatible = true;

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public BRoleManager getRoleManager() {
        return (BRoleManager)this.get(roleManager);
    }

    @Generated
    public void setRoleManager(BRoleManager v) {
        this.set(roleManager, (BValue)v, null);
    }

    @Generated
    public BSyncTask getSyncTask() {
        return (BSyncTask)this.get(syncTask);
    }

    @Generated
    public void setSyncTask(BSyncTask v) {
        this.set(syncTask, (BValue)v, null);
    }

    @Generated
    public BReachableStations getReachableStations() {
        return (BReachableStations)this.get(reachableStations);
    }

    @Generated
    public void setReachableStations(BReachableStations v) {
        this.set(reachableStations, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BStationRole getRole() {
        return this.getRoleManager().getActualRole();
    }

    public void setRole(BStationRole role) {
        this.getRoleManager().setDesiredRole(role);
    }

    protected BNiagaraNetwork getNiagaraNetwork() {
        return ((BNiagaraStation)this.getDevice()).getNiagaraNetwork();
    }

    public boolean isOperational() {
        return this.isOperational(this.getStatus());
    }

    private boolean isOperational(BStatus status) {
        return !status.isDisabled() && !status.isDown() && !status.isFault();
    }

    public final BFoxClientConnection getClientConnection() {
        return ((BNiagaraStation)this.getParent()).getClientConnection();
    }

    public final BFoxServerConnection getServerConnection() {
        return ((BNiagaraStation)this.getParent()).getServerConnection();
    }

    public final BSysDefChannel getSysDefChannel() {
        return (BSysDefChannel)this.getClientConnection().getChannels().get("sysdef", BSysDefChannel.TYPE);
    }

    @Override
    public void clientClosed() {
    }

    @Override
    public void clientOpened() {
        FoxMessage hello = this.getClientConnection().session().getRemoteHello();
        this.remoteSysDefVersion = new Version(hello.getString("sysDefVersion", "0"));
        this.remoteIsCompatible = this.getNiagaraNetwork().getSysDefProvider().isCompatible(this.remoteSysDefVersion);
        this.updateStatus();
    }

    @Override
    public void serverClosed() {
    }

    @Override
    public void serverOpened() {
        FoxMessage hello = this.getServerConnection().session().getRemoteHello();
        this.remoteSysDefVersion = new Version(hello.getString("sysDefVersion", "0"));
        this.remoteIsCompatible = this.getNiagaraNetwork().getSysDefProvider().isCompatible(this.remoteSysDefVersion);
        this.updateStatus();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            this.updateStatus();
        } else if (property == status) {
            if (this.becameOperational()) {
                log.fine(this.getDevice().getName() + " SysDef extension became operational.");
                if (this.getRoleManager().isRetryCondition()) {
                    this.getRoleManager().execute();
                } else {
                    this.getSyncTask().execute();
                }
            }
            this.prevStatus = this.getStatus();
        }
    }

    private boolean becameOperational() {
        return !this.isOperational(this.prevStatus) && this.isOperational(this.getStatus());
    }

    public void updateStatus() {
        BStatus devStatus = this.getDevice().getStatus();
        BStatus newStatus = this.getStatus();
        newStatus = BStatus.makeDisabled((BStatus)newStatus, (devStatus.isDisabled() || !this.getEnabled() ? 1 : 0) != 0);
        newStatus = BStatus.makeDown((BStatus)newStatus, (boolean)devStatus.isDown());
        newStatus = BStatus.makeFault((BStatus)newStatus, (!this.remoteIsCompatible ? 1 : 0) != 0);
        if (this.remoteIsCompatible) {
            this.setFaultCause("");
        } else {
            this.setFaultCause("Fault: " + this.getDevice().getName() + " SysDef version " + this.remoteSysDefVersion + " is not compatible with this station's SysDef version: " + Sys.getBajaVersion());
        }
        this.setStatus(newStatus);
        this.getReachableStations().updateStatus();
    }

    public BIcon getIcon() {
        return icon;
    }

    public SysDefInterest makeInterest(String diagnostic) {
        return new SysDefInterest(this.getDevice().getName() + ": " + diagnostic);
    }

    public static final class SysDefInterest
    implements BFoxClientConnection.Interest {
        String s;
        BAbsTime creation;

        public SysDefInterest(String s) {
            this.s = s;
            this.creation = BAbsTime.now();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.creation == null ? 0 : this.creation.hashCode());
            result = 31 * result + (this.s == null ? 0 : this.s.hashCode());
            return result;
        }

        public String toString() {
            return this.s + ". Created: " + this.creation;
        }
    }
}

