/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jx.browser;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.event.BrowserBecameUnresponsive;
import com.teamdev.jxbrowser.browser.event.RenderProcessTerminated;
import com.teamdev.jxbrowser.engine.Engine;
import com.teamdev.jxbrowser.engine.EngineOptions;
import com.teamdev.jxbrowser.engine.Language;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.engine.event.EngineCrashed;
import com.teamdev.jxbrowser.net.HttpHeader;
import com.teamdev.jxbrowser.net.HttpStatus;
import com.teamdev.jxbrowser.net.Scheme;
import com.teamdev.jxbrowser.net.UrlRequest;
import com.teamdev.jxbrowser.net.UrlRequestJob;
import com.teamdev.jxbrowser.net.callback.InterceptUrlRequestCallback;
import com.teamdev.jxbrowser.view.swing.BrowserView;
import com.tridium.jx.browser.WbJxBrowserUtil;
import java.awt.Component;
import java.io.IOException;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.stage.Stage;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class StandaloneJxBrowser
extends Application {
    private static final String LOAD_HTML_URL = "https://workbench/standaloneTest.html";
    private static final Logger LOGGER = Logger.getLogger(StandaloneJxBrowser.class.getName());

    public void start(Stage primaryStage) throws Exception {
        AccessController.doPrivileged(() -> {
            JFrame frame = new JFrame();
            frame.setDefaultCloseOperation(3);
            JTabbedPane jtp = new JTabbedPane();
            frame.getContentPane().add(jtp);
            frame.add(jtp);
            frame.setSize(1200, 720);
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
            Engine engine = AccessController.doPrivileged(() -> Engine.newInstance((EngineOptions)EngineOptions.newBuilder((RenderingMode)RenderingMode.OFF_SCREEN).language(Language.ENGLISH_US).licenseKey(WbJxBrowserUtil.getLicenseKey()).addScheme(Scheme.HTTPS, params -> {
                try {
                    return StandaloneJxBrowser.loadModuleResource(params);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    return InterceptUrlRequestCallback.Response.proceed();
                }
            }).build()));
            engine.on(EngineCrashed.class, event -> {
                String errorMessage = "EngineCrashed detected: " + event;
                LOGGER.severe(errorMessage);
            });
            Browser browser = engine.newBrowser();
            browser.on(BrowserBecameUnresponsive.class, event -> {
                String errorMessage = "Web Browser Unresponsive: " + event;
                LOGGER.severe(errorMessage);
            });
            browser.on(RenderProcessTerminated.class, event -> {
                if (event.exitCode() == 0) {
                    return;
                }
                String errorMessage = "RenderProcessTerminated: " + event;
                LOGGER.severe(errorMessage);
            });
            BrowserView browserView = BrowserView.newInstance((Browser)browser);
            JPanel jp1 = new JPanel();
            jp1.add((Component)browserView);
            jtp.addTab("Browser", (Component)browserView);
            browser.navigation().loadUrl(LOAD_HTML_URL);
            return null;
        });
    }

    private static InterceptUrlRequestCallback.Response loadModuleResource(InterceptUrlRequestCallback.Params params) {
        UrlRequest request = params.urlRequest();
        if (!"GET".equalsIgnoreCase(request.method())) {
            return InterceptUrlRequestCallback.Response.proceed();
        }
        String url = request.url();
        if (url.startsWith(LOAD_HTML_URL)) {
            UrlRequestJob job = params.newUrlRequestJob(UrlRequestJob.Options.newBuilder((HttpStatus)HttpStatus.OK).addHttpHeader(HttpHeader.of((String)"Content-Type", (String)"text/html")).build());
            try {
                String htmlToLoad = "<!DOCTYPE html><html><head></head><body><div>JxBrowser standalone test has booted JxBrowser successfully.</div></body></html>";
                job.write(htmlToLoad.getBytes());
                job.complete();
                return InterceptUrlRequestCallback.Response.intercept((UrlRequestJob)job);
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "Cannot intercept URL:" + url, t);
            }
        }
        return InterceptUrlRequestCallback.Response.proceed();
    }

    public static void main(String[] args) throws IOException {
        Application.launch(StandaloneJxBrowser.class, (String[])new String[0]);
    }
}

