/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion;

import com.tridium.orion.BIOrionDatabaseObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionModule;
import com.tridium.orion.BOrionScheme;
import com.tridium.orion.BOrionService;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.category.BCategoryMask;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BPermissions;
import javax.baja.space.BSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
public final class BOrionType
extends BComponent
implements BIOrionDatabaseObject {
    @Generated
    public static final Type TYPE = Sys.loadType(BOrionType.class);
    private static final BIcon icon = BIcon.std((String)"shapes/squareBlue.png");
    private String moduleName;
    private String typeName;
    private OrionType orionType;
    private BPermissions permissions;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BOrionType() {
    }

    public BOrionType(OrionType orionType) {
        this(orionType, null);
    }

    public BOrionType(OrionType orionType, BPermissions permissions) {
        this.orionType = orionType;
        this.permissions = permissions;
        this.moduleName = orionType.getModule().getModuleName();
        this.typeName = orionType.getTypeName();
    }

    public BOrionType(String moduleName, String typeName, BPermissions permissions) {
        this.moduleName = moduleName;
        this.typeName = typeName;
        this.permissions = permissions;
    }

    @Override
    public BOrionDatabase getOrionDatabase() {
        BOrionModule module = this.getModule();
        if (module == null) {
            return null;
        }
        return module.getOrionDatabase();
    }

    public BOrionModule getModule() {
        return (BOrionModule)this.getParent();
    }

    public String getModuleName() {
        if (this.isMounted()) {
            return this.getParent().getName();
        }
        return this.moduleName;
    }

    public String getTypeName() {
        if (this.isMounted()) {
            return this.getName();
        }
        return this.typeName;
    }

    public OrionType resolveOrionType() {
        if (this.orionType == null) {
            BTypeSpec typeSpec = BTypeSpec.make((String)this.getModuleName(), (String)this.getTypeName());
            try {
                this.orionType = (OrionType)typeSpec.getResolvedType();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.orionType == null) {
                throw new OrionException("Cannot resolve type: " + typeSpec);
            }
        }
        return this.orionType;
    }

    public OrionType getOrionType() {
        if (this.orionType == null) {
            this.resolveOrionType();
        }
        return this.orionType;
    }

    public BOrionTypeId getOrionTypeId() {
        return this.getOrionType().getOrionTypeId();
    }

    public BOrd getNavOrd() {
        BSpace space = this.getSpace();
        if (space == null) {
            return null;
        }
        return BOrd.make((BOrd)space.getNavOrd(), (BOrd)this.getOrdInSpace()).normalize();
    }

    public Object getHandle() {
        return this.getHandleOrd();
    }

    public BOrd getHandleOrd() {
        return this.getOrdInSpace();
    }

    public BOrd getOrdInSession() {
        return this.getOrdInSpace();
    }

    public BOrd getOrdInSpace() {
        return BOrionScheme.getOrdInSpace(this);
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents = agents.filter((AgentFilter)new OrionAgentFilter());
        return agents;
    }

    public BPermissions getPermissions(Context cx) {
        if (this.permissions != null) {
            return this.permissions;
        }
        return super.getPermissions(cx);
    }

    public void setCategoryMask(BCategoryMask catMask, Context cx) {
        if (cx != Context.decoding) {
            try {
                BOrionService.getService().setCategoryMask(this.getOrdInSession(), catMask);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.setCategoryMask(catMask, cx);
    }

    public BIcon getIcon() {
        return icon;
    }

    private static class OrionAgentFilter
    extends AgentFilter {
        private OrionAgentFilter() {
        }

        public boolean include(AgentInfo info) {
            TypeInfo agentType = info.getAgentType();
            String moduleName = agentType.getModuleName();
            if (moduleName.equals("orion") || moduleName.equals("orionAdmin")) {
                return true;
            }
            TypeInfo viewType = Sys.getRegistry().getType("workbench:WbPlugin");
            return !agentType.is(viewType);
        }
    }
}

