/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion;

import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.OrionException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BTypeDependency
extends BSimple {
    public static final BTypeDependency NULL;
    public static final BTypeDependency DEFAULT;
    public static final Type TYPE;
    private BOrionTypeId fromId;
    private String fromProp;
    private BOrionTypeId toId;
    private String toProp;
    private Integer hashCode;

    public static BTypeDependency make(BOrionTypeId fromId, String fromProp, BOrionTypeId toId, String toProp) {
        BTypeDependency d = new BTypeDependency(fromId, fromProp, toId, toProp);
        return d.equals((Object)NULL) ? NULL : d;
    }

    public static BTypeDependency makeSelf(BOrionTypeId self) {
        return new BTypeDependency(self, "", BOrionTypeId.NULL, "");
    }

    private BTypeDependency(BOrionTypeId fromId, String fromProp, BOrionTypeId toId, String toProp) {
        this.fromId = fromId;
        this.fromProp = fromProp;
        this.toId = toId;
        if (toId.isTemporary()) {
            throw new OrionException("Cannot create dependency on temporary type.");
        }
        this.toProp = toProp;
    }

    public boolean isSelf() {
        return this.fromProp.length() == 0;
    }

    public BOrionTypeId getFromTypeId() {
        return this.fromId;
    }

    public String getFromProperty() {
        return this.fromProp;
    }

    public BOrionTypeId getToTypeId() {
        return this.toId;
    }

    public String getToProperty() {
        return this.toProp;
    }

    public String getFromDisplay() {
        if (this.fromProp.length() == 0) {
            return this.fromId.toString();
        }
        return this.fromId.toString() + " (" + this.fromProp + ")";
    }

    public boolean isNull() {
        return this.equals((Object)NULL);
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.fromId.encodeToString());
        out.writeUTF(this.fromProp);
        out.writeUTF(this.toId.encodeToString());
        out.writeUTF(this.toProp);
    }

    public BObject decode(DataInput in) throws IOException {
        BOrionTypeId fromId = (BOrionTypeId)BOrionTypeId.DEFAULT.decodeFromString(in.readUTF());
        String fromProp = in.readUTF();
        BOrionTypeId toId = (BOrionTypeId)BOrionTypeId.DEFAULT.decodeFromString(in.readUTF());
        String toProp = in.readUTF();
        return new BTypeDependency(fromId, fromProp, toId, toProp);
    }

    public String encodeToString() throws IOException {
        StringBuilder s = new StringBuilder();
        s.append(this.fromId.encodeToString()).append(',');
        s.append(this.fromProp).append(',');
        s.append(this.toId.encodeToString()).append(',');
        s.append(this.toProp);
        return s.toString();
    }

    public BObject decodeFromString(String s) throws IOException {
        String[] split = TextUtil.split((String)s, (char)',');
        BOrionTypeId fromId = (BOrionTypeId)BOrionTypeId.DEFAULT.decodeFromString(split[0]);
        String fromProp = split[1];
        BOrionTypeId toId = (BOrionTypeId)BOrionTypeId.DEFAULT.decodeFromString(split[2]);
        String toProp = split[3];
        return new BTypeDependency(fromId, fromProp, toId, toProp);
    }

    public String toString(Context cx) {
        if (this.isNull()) {
            return "null";
        }
        StringBuilder s = new StringBuilder(128);
        s.append((Object)this.fromId).append('.').append(this.fromProp);
        s.append(" -> ");
        s.append((Object)this.toId).append('.').append(this.toProp);
        return s.toString();
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = (this.fromId.encodeToString() + this.fromProp + this.toId.encodeToString() + this.toProp).hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BTypeDependency)) {
            return false;
        }
        BTypeDependency d = (BTypeDependency)((Object)o);
        return this.fromId.equals((Object)d.fromId) && this.fromProp.equals(d.fromProp) && this.toId.equals((Object)d.toId) && this.toProp.equals(d.toProp);
    }

    public Type getType() {
        return TYPE;
    }

    static {
        DEFAULT = NULL = new BTypeDependency(BOrionTypeId.NULL, "", BOrionTypeId.NULL, "");
        TYPE = Sys.loadType(BTypeDependency.class);
    }
}

