/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion;

import com.tridium.sys.schema.Utils;
import java.lang.reflect.Modifier;
import javax.baja.naming.SlotPath;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class InverseRefProperty
implements Property {
    private Type declaringType;
    private String name;
    private Type type;
    private BValue def;
    private BFacets facets;
    private int flags;
    private String displayName;
    private Class<?> typeClass;
    private int typeAccess;
    private boolean typeFinal;

    public InverseRefProperty(Type declaringType, String name, Type type, BValue def, BFacets facets, int flags) {
        this.declaringType = declaringType;
        this.name = name;
        this.type = type;
        this.def = def;
        this.facets = facets;
        this.flags = flags;
        this.typeClass = def.getClass();
        this.typeAccess = Utils.getTypeAccess(this.typeClass);
        this.typeFinal = Modifier.isFinal(this.typeClass.getModifiers());
    }

    public Type getDeclaringType() {
        return this.declaringType;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public BFacets getFacets() {
        return this.facets;
    }

    public int getDefaultFlags() {
        return this.flags;
    }

    public final boolean isProperty() {
        return true;
    }

    public boolean isAction() {
        return false;
    }

    public boolean isTopic() {
        return false;
    }

    public final Property asProperty() {
        return this;
    }

    public Action asAction() {
        throw new ClassCastException();
    }

    public Topic asTopic() {
        throw new ClassCastException();
    }

    public final int getTypeAccess() {
        return this.typeAccess;
    }

    public final BValue getDefaultValue() {
        return this.def.newCopy(true);
    }

    public final boolean isEquivalentToDefaultValue(BValue obj) {
        return this.def.equivalent((Object)obj);
    }

    public boolean isTypeFinal() {
        return this.typeFinal;
    }

    public boolean isDynamic() {
        return false;
    }

    public boolean isFrozen() {
        return true;
    }

    public String getDefaultDisplayName(Context cx) {
        try {
            String module = this.declaringType.getModule().getModuleName();
            String n = Lexicon.make((String)module, (Context)cx).get(this.name);
            if (n != null) {
                return n;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (this.displayName == null) {
            this.displayName = SlotPath.unescape((String)this.name);
        }
        return this.displayName;
    }

    public String toString() {
        return this.name + ": " + this.type;
    }
}

