/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.ColumnDefinition;
import com.tridium.orion.priv.db.DbBatch;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.db.sql.Insert;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;

public class DbBatchInsert
extends DbBatch {
    RdbmsPreparedStatement prep = null;

    public DbBatchInsert(DbOrionSession session, OrionType type) {
        super(session, type);
    }

    @Override
    public void execute() {
        BIOrionObject obj;
        int i;
        if (this.arr.size() == 0) {
            return;
        }
        for (i = 0; i < this.arr.size(); ++i) {
            obj = (BIOrionObject)this.arr.get(i);
            if (obj.beforeInsert(this.session)) continue;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.log(Level.FINE, "VETOED BATCH INSERT: index " + i + ", object " + obj);
            }
            return;
        }
        try {
            switch (this.dialect.getInsertionMode()) {
                case 1: {
                    this.executeIdentity();
                    break;
                }
                case 2: {
                    this.executeIdentityLookup();
                    break;
                }
                case 0: {
                    this.executeSequence();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (SQLException e) {
            throw new OrionException(e);
        }
        for (i = 0; i < this.arr.size(); ++i) {
            obj = (BIOrionObject)this.arr.get(i);
            obj.afterInsert(this.session);
        }
        this.clear();
    }

    private void executeIdentity() throws SQLException {
        ColumnDefinition identCol = this.tableDef.getIdentityColumn();
        if (this.prep == null) {
            this.prep = this.session.makeAutoKeyStatement(this.db, this.conn, Insert.buildInsertSql(this.tableDef, false), identCol == null ? 2 : 1);
        }
        if (this.dialect.supportsBatchInsert()) {
            int chunk = this.getChunkSize();
            int n = 0;
            int from = 0;
            int to = 0;
            for (int i = 0; i < this.arr.size(); ++i) {
                BIOrionObject obj = (BIOrionObject)this.arr.get(i);
                Insert.loadInsertStatement(this.prep, this.tableDef, false, obj);
                this.prep.addBatch();
                ++to;
                if (chunk <= 0 || ++n < chunk) continue;
                this.prep.executeBatch();
                Insert.retrieveIdentityKeys(this.prep, identCol, (BIOrionObject[])this.arr.slice(from, to).trim());
                n = 0;
                from = to;
            }
            if (chunk == 0 || n > 0) {
                this.prep.executeBatch();
                Insert.retrieveIdentityKeys(this.prep, identCol, (BIOrionObject[])this.arr.slice(from, to).trim());
            }
        } else {
            for (int i = 0; i < this.arr.size(); ++i) {
                BIOrionObject obj = (BIOrionObject)this.arr.get(i);
                Insert.loadInsertStatement(this.prep, this.tableDef, false, obj);
                this.prep.executeUpdate();
                Insert.retrieveIdentityKeys(this.prep, identCol, new BIOrionObject[]{obj});
            }
        }
    }

    private void executeIdentityLookup() throws SQLException {
        ColumnDefinition identCol = this.tableDef.getIdentityColumn();
        if (this.prep == null) {
            this.prep = this.session.makeStatement(this.db, this.conn, Insert.buildInsertSql(this.tableDef, false));
        }
        if (this.dialect.supportsBatchInsert()) {
            int chunk = this.getChunkSize();
            int n = 0;
            int from = 0;
            int to = 0;
            for (int i = 0; i < this.arr.size(); ++i) {
                BIOrionObject obj = (BIOrionObject)this.arr.get(i);
                Insert.loadInsertStatement(this.prep, this.tableDef, false, obj);
                this.prep.addBatch();
                ++to;
                if (chunk <= 0 || ++n < chunk) continue;
                this.prep.executeBatch();
                Insert.retrieveIdentityLookupKeys(this.dialect, this.conn, identCol, (BIOrionObject[])this.arr.slice(from, to).trim());
                n = 0;
                from = to;
            }
            if (chunk == 0 || n > 0) {
                this.prep.executeBatch();
                Insert.retrieveIdentityLookupKeys(this.dialect, this.conn, identCol, (BIOrionObject[])this.arr.slice(from, to).trim());
            }
        } else {
            for (int i = 0; i < this.arr.size(); ++i) {
                BIOrionObject obj = (BIOrionObject)this.arr.get(i);
                Insert.loadInsertStatement(this.prep, this.tableDef, false, obj);
                this.prep.executeUpdate();
                Insert.retrieveIdentityLookupKeys(this.dialect, this.conn, identCol, new BIOrionObject[]{obj});
            }
        }
    }

    private void executeSequence() throws SQLException {
        ColumnDefinition identCol = this.tableDef.getIdentityColumn();
        if (this.prep == null) {
            this.prep = this.session.makeStatement(this.db, this.conn, Insert.buildInsertSql(this.tableDef, true));
        }
        if (this.dialect.supportsBatchInsert()) {
            int chunk = this.getChunkSize();
            int n = 0;
            for (int i = 0; i < this.arr.size(); ++i) {
                BIOrionObject obj = (BIOrionObject)this.arr.get(i);
                Insert.lookupSequenceKey(this.dialect, this.conn, this.tableDef, identCol, obj);
                Insert.loadInsertStatement(this.prep, this.tableDef, true, obj);
                this.prep.addBatch();
                if (chunk <= 0 || ++n < chunk) continue;
                this.prep.executeBatch();
                n = 0;
            }
            if (chunk == 0 || n > 0) {
                this.prep.executeBatch();
            }
        } else {
            for (int i = 0; i < this.arr.size(); ++i) {
                BIOrionObject obj = (BIOrionObject)this.arr.get(i);
                Insert.lookupSequenceKey(this.dialect, this.conn, this.tableDef, identCol, obj);
                Insert.loadInsertStatement(this.prep, this.tableDef, true, obj);
                this.prep.executeUpdate();
            }
        }
    }
}

