/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.DbBatch;
import com.tridium.orion.priv.db.DbBatchInsert;
import com.tridium.orion.priv.db.DbBatchUpdate;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.db.TableDefinition;
import com.tridium.orion.priv.db.sql.Fetch;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DbBatchPersist
extends DbBatch {
    private final Fetch fetch;
    private final DbBatchUpdate batchUpdate;
    private final DbBatchInsert batchInsert;

    public DbBatchPersist(DbOrionSession session, OrionType type) {
        super(session, type);
        this.fetch = new Fetch(session);
        this.batchUpdate = new DbBatchUpdate(session, type);
        this.batchInsert = new DbBatchInsert(session, type);
    }

    @Override
    public void execute() {
        if (this.arr.size() == 0) {
            return;
        }
        TableDefinition tableDef = TableDefinition.get(this.db, this.type);
        try {
            BIOrionObject obj = (BIOrionObject)this.arr.get(0);
            PropertyValue[] propValues = PropertyValue.makeKeys(obj);
            RdbmsPreparedStatement prep = this.session.makeStatement(this.db, this.conn, this.fetch.buildPreparedSelect(tableDef, propValues));
            for (int i = 0; i < this.arr.size(); ++i) {
                obj = (BIOrionObject)this.arr.get(i);
                propValues = PropertyValue.makeKeys(obj);
                this.fetch.loadPreparedSelect(tableDef, propValues, prep);
                ResultSet rs = prep.executeQuery();
                boolean exists = rs.next();
                if (exists) {
                    this.batchUpdate.add(obj);
                    continue;
                }
                this.batchInsert.add(obj);
            }
            this.batchUpdate.execute();
            this.batchInsert.execute();
        }
        catch (SQLException e) {
            throw new OrionException(e);
        }
    }
}

