/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db.sql;

import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.DbCursor;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.db.EmptyOrionCursor;
import com.tridium.orion.priv.db.QueryResolveCursor;
import com.tridium.orion.priv.db.TableDefinition;
import com.tridium.orion.priv.db.sql.AutoResolveVisitor;
import com.tridium.orion.priv.db.sql.Fetch;
import com.tridium.orion.priv.db.sql.PaginatedCursor;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import java.sql.SQLException;
import javax.baja.query.BQuery;
import javax.baja.security.BPermissions;
import javax.baja.sys.BSimple;

public class Select
extends Fetch {
    public Select(DbOrionSession session) {
        super(session);
    }

    public OrionCursor select(BQuery query) {
        BSqlQuery sql;
        BPermissions permissions = this.getPermissionsForQuery(query);
        if (!permissions.hasOperatorRead()) {
            AutoResolveVisitor visitor = new AutoResolveVisitor(this.db, this);
            visitor.visit(query);
            OrionType resultType = visitor.getResultType();
            return new EmptyOrionCursor(this.session, resultType);
        }
        if (query.getExtent().list().length > 1) {
            throw new OrionException("Orion does not support BQuerys with multiple base extents. Use BSqlQuery and add join statements.");
        }
        AutoResolveVisitor visitor = new AutoResolveVisitor(this.db, this);
        visitor.visit(query);
        this.logBQuery(visitor);
        OrionCursor cursor = null;
        try {
            cursor = new QueryResolveCursor(this.session, visitor, this.makeQueryResultSet(visitor.getQueryString(), visitor.getParameters()));
        }
        catch (SQLException e) {
            throw new OrionException(e);
        }
        if (query instanceof BSqlQuery && (sql = (BSqlQuery)query).hasPage() && !visitor.dbSupportsPagination()) {
            cursor = new PaginatedCursor(cursor, sql.getPage());
        }
        return cursor;
    }

    public OrionCursor select(OrionType type, String sql, BSimple[] paramValues) {
        if (type.isDynamic() && !this.db.getPermissions(this.session).hasAdminRead()) {
            throw new OrionException("Admin permissions required.");
        }
        String word = Select.firstWord(sql.trim()).toUpperCase();
        if (!word.equals("SELECT")) {
            throw new OrionException("Invalid SELECT statement: " + sql);
        }
        try {
            DbCursor cursor = new DbCursor(this.session, type, this.makeQueryResultSet(sql, paramValues), true, true);
            return cursor;
        }
        catch (SQLException e) {
            throw new OrionException(e);
        }
    }

    public OrionCursor select(OrionType type, PropertyValue propValue) {
        return this.select(type, new PropertyValue[]{propValue});
    }

    public OrionCursor select(OrionType type, PropertyValue[] propValues) {
        TableDefinition tableDef = TableDefinition.get(this.db, type);
        String sql = this.buildPreparedSelect(tableDef, propValues);
        try {
            RdbmsPreparedStatement prep = this.session.makeStatement(this.db, this.conn, sql);
            this.loadPreparedSelect(tableDef, propValues, prep);
            return new DbCursor(this.session, type, prep.executeQuery(), false, false);
        }
        catch (SQLException e) {
            throw new OrionException(e);
        }
    }
}

