/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.fox;

import com.tridium.fox.encoding.BogCodec;
import com.tridium.fox.encoding.DecoderFactory;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BNameFactory;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionService;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.BOrionType;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BTypeDependency;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.fox.BFoxOrionDatabase;
import com.tridium.orion.priv.fox.BOrionChannel;
import com.tridium.orion.priv.fox.FoxOrionSession;
import com.tridium.orion.priv.fox.OrionInput;
import com.tridium.orion.priv.fox.OrionOutput;
import com.tridium.orion.priv.sys.OrionSyncBuffer;
import com.tridium.orion.priv.util.OrionObjectCursor;
import com.tridium.orion.sql.BatchStatement;
import com.tridium.orion.sql.PropertyValue;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.query.BQuery;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class OrionCircuit {
    private BOrionChannel channel;

    OrionCircuit(BOrionChannel channel) {
        this.channel = channel;
    }

    public void circuitOpened(FoxCircuit circuit) throws Exception {
        String command = circuit.command;
        if (command == "depTypes") {
            this.getDependentTypes(circuit);
            return;
        }
        if (command == "getType") {
            this.getType(circuit);
            return;
        }
        if (command == "getNameFactory") {
            this.getNameFactory(circuit);
            return;
        }
        if (command == "scan") {
            this.scan(circuit);
            return;
        }
        if (command == "linkedScan") {
            this.linkedScan(circuit);
            return;
        }
        if (command == "insert") {
            this.insert(circuit);
            return;
        }
        if (command == "read") {
            this.read(circuit);
            return;
        }
        if (command == "readRaw") {
            this.readRaw(circuit);
            return;
        }
        if (command == "preadRaw") {
            this.preadRaw(circuit);
            return;
        }
        if (command == "update") {
            this.update(circuit);
            return;
        }
        if (command == "persist") {
            this.persist(circuit);
            return;
        }
        if (command == "delete") {
            this.delete(circuit);
            return;
        }
        if (command == "select") {
            this.select(circuit);
            return;
        }
        if (command == "qselect") {
            this.qselect(circuit);
            return;
        }
        if (command == "pselect") {
            this.pselect(circuit);
            return;
        }
        if (command == "commitSyncBuffer") {
            this.commitSyncBuffer(circuit);
            return;
        }
        if (command == "sendSyncBufferToClient") {
            this.receiveSyncBufferFromServer(circuit);
            return;
        }
        if (command == "batchInsert") {
            this.batchInsert(circuit);
            return;
        }
        if (command == "batchUpdate") {
            this.batchUpdate(circuit);
            return;
        }
        if (command == "batchPersist") {
            this.batchPersist(circuit);
            return;
        }
        if (command == "batchDelete") {
            this.batchDelete(circuit);
            return;
        }
        throw new InvalidCommandException(command);
    }

    public BTypeDependency[] getDependentTypes(BFoxOrionDatabase db, OrionType baseType) throws Exception {
        FoxCircuit circuit = this.channel.openCircuit("depTypes");
        FoxMessage req = new FoxMessage();
        req.add("dbId", db.getId());
        req.add("baseTypeId", baseType.getOrionTypeId().encodeToString());
        circuit.writeMessage(req);
        FoxMessage resp = circuit.readMessage();
        if (resp.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException(resp);
        }
        String[] list = resp.listStrings("d");
        BTypeDependency[] dependencies = new BTypeDependency[list.length];
        for (int i = 0; i < list.length; ++i) {
            dependencies[i] = (BTypeDependency)BTypeDependency.DEFAULT.decodeFromString(list[i]);
        }
        return dependencies;
    }

    private void getDependentTypes(FoxCircuit circuit) throws Exception {
        try {
            FoxMessage req = circuit.readMessage();
            BOrionService service = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
            BOrionDatabase db = service.getOrionDatabase(req.getString("dbId"));
            BOrionTypeId baseTypeId = (BOrionTypeId)BOrionTypeId.DEFAULT.decodeFromString(req.getString("baseTypeId"));
            OrionType baseType = db.getType(baseTypeId);
            BTypeDependency[] dependencies = db.getDependentTypes(baseType);
            FoxMessage resp = new FoxMessage("resp");
            for (int i = 0; i < dependencies.length; ++i) {
                resp.add("d", dependencies[i].encodeToString());
            }
            circuit.writeMessage(resp);
            circuit.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            circuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrionType getType(BFoxOrionDatabase db, BOrionTypeId typeId) throws Exception {
        try (FoxCircuit circuit = this.channel.openCircuit("getType");){
            FoxMessage req = new FoxMessage("getType");
            req.add("dbId", db.getId());
            req.add("typeId", typeId.encodeToString());
            circuit.writeMessage(req);
            circuit.flush();
            OrionInput in = new OrionInput(circuit.getInputStream(), this.channel.makeOrionEncryptionContext(null, false));
            in.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            OrionType type = in.readType();
            in.close();
            OrionType orionType = type;
            return orionType;
        }
    }

    private void getType(FoxCircuit circuit) throws Exception {
        FoxMessage req = circuit.readMessage();
        BOrionService service = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
        BOrionDatabase db = service.getOrionDatabase(req.getString("dbId"));
        BOrionTypeId typeId = BOrionTypeId.decode(req.getString("typeId"));
        OrionType type = db.getType(typeId);
        OrionOutput out = new OrionOutput(circuit.getOutputStream(), this.channel.makeOrionEncryptionContext(null, true));
        out.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
        out.writeType(type);
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BNameFactory getNameFactory(BFoxOrionDatabase db, OrionType type) throws Exception {
        try (FoxCircuit circuit = this.channel.openCircuit("getNameFactory");){
            FoxMessage req = new FoxMessage("getNameFactory");
            req.add("dbId", db.getId());
            req.add("typeId", type.getOrionTypeId().encodeToString());
            circuit.writeMessage(req);
            circuit.flush();
            FoxMessage resp = circuit.readMessage();
            if (resp.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(resp);
            }
            BNameFactory bNameFactory = (BNameFactory)((Object)DecoderFactory.decode((FoxMessage)resp, (String)"factory", null));
            return bNameFactory;
        }
    }

    private void getNameFactory(FoxCircuit circuit) throws Exception {
        try {
            BOrionService service = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
            FoxMessage req = circuit.readMessage();
            BOrionDatabase db = service.getOrionDatabase(req.getString("dbId"));
            BOrionTypeId typeId = BOrionTypeId.decode(req.getString("typeId"));
            OrionType type = db.getType(typeId);
            FoxMessage resp = new FoxMessage();
            BogCodec.add((FoxMessage)resp, (String)"factory", (BValue)db.getNameFactory(type), null);
            circuit.writeMessage(resp);
        }
        catch (Exception e) {
            e.printStackTrace();
            circuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)e));
        }
    }

    public OrionCursor scan(FoxOrionSession session, OrionType type) throws Exception {
        FoxCircuit circuit = this.channel.openCircuit("scan");
        try {
            this.channel.setSession(session, circuit);
            FoxMessage req = new FoxMessage("type");
            req.add("typeId", type.getOrionTypeId().encodeToString());
            circuit.writeMessage(req);
            circuit.flush();
            FoxMessage resp = circuit.readMessage();
            if (resp.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(resp);
            }
            this.channel.assignSessionId(session, resp);
        }
        catch (Exception e) {
            circuit.close();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new OrionException("Operation failed.", e);
        }
        return new OrionObjectCursor(session, new OrionInput(session, circuit.getInputStream(), this.channel.makeOrionEncryptionContext(null, false)), null, this.channel.getConnection().session().isLegacyConnection());
    }

    private void scan(FoxCircuit circuit) throws Exception {
        try {
            FoxMessage resp = new FoxMessage();
            OrionSession session = this.channel.getSession(circuit, resp, true);
            circuit.writeMessage(resp);
            FoxMessage req = circuit.readMessage();
            BOrionTypeId typeId = BOrionTypeId.decode(req.getString("typeId"));
            OrionType type = session.getOrionDatabase().getType(typeId);
            OrionCursor result = session.scan(type);
            OrionOutput out = new OrionOutput(circuit.getOutputStream(), this.channel.makeOrionEncryptionContext(null, true));
            out.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            out.writeType(result.getOrionType());
            while (result.next()) {
                out.writeObject((BIOrionObject)result.get());
            }
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            circuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)e));
        }
    }

    public OrionCursor linkedScan(FoxOrionSession session, BIOrionObject object, OrionType linkType, OrionType scanType) throws Exception {
        FoxCircuit circuit = this.channel.openCircuit("linkedScan");
        try {
            this.channel.setSession(session, circuit);
            FoxMessage req = new FoxMessage("linkedScan");
            req.add("linkTypeId", linkType.getOrionTypeId().encodeToString());
            req.add("scanTypeId", scanType.getOrionTypeId().encodeToString());
            circuit.writeMessage(req);
            OrionOutput out = new OrionOutput(circuit.getOutputStream(), this.channel.makeOrionEncryptionContext(null, true));
            out.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            out.writeObject(object);
            out.flush();
            circuit.flush();
            FoxMessage resp = circuit.readMessage();
            if (resp.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(resp);
            }
            this.channel.assignSessionId(session, resp);
        }
        catch (Exception e) {
            circuit.close();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new OrionException("Operation failed.", e);
        }
        return new OrionObjectCursor(session, new OrionInput(session, circuit.getInputStream(), this.channel.makeOrionEncryptionContext(null, false)), null, this.channel.getConnection().session().isLegacyConnection());
    }

    private void linkedScan(FoxCircuit circuit) throws Exception {
        try {
            FoxMessage resp = new FoxMessage();
            OrionSession session = this.channel.getSession(circuit, resp, true);
            circuit.writeMessage(resp);
            FoxMessage req = circuit.readMessage();
            BOrionTypeId linkTypeId = BOrionTypeId.decode(req.getString("linkTypeId"));
            OrionType linkType = session.getOrionDatabase().getType(linkTypeId);
            BOrionTypeId scanTypeId = BOrionTypeId.decode(req.getString("scanTypeId"));
            OrionType scanType = session.getOrionDatabase().getType(scanTypeId);
            OrionInput in = new OrionInput(session, circuit.getInputStream(), this.channel.makeOrionEncryptionContext(null, false));
            in.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            BIOrionObject object = in.readObject();
            OrionCursor result = session.linkedScan(object, linkType, scanType);
            OrionOutput out = new OrionOutput(circuit.getOutputStream(), this.channel.makeOrionEncryptionContext(null, true));
            out.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            out.writeType(result.getOrionType());
            while (result.next()) {
                out.writeObject((BIOrionObject)result.get());
            }
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            circuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIOrionObject insert(FoxOrionSession session, BIOrionObject obj) throws Exception {
        try (FoxCircuit circuit = this.channel.openCircuit("insert");){
            this.channel.setSession(session, circuit);
            OrionOutput out = new OrionOutput(circuit.getOutputStream(), this.channel.makeOrionEncryptionContext(null, true));
            out.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            out.writeObject(obj);
            out.flush();
            FoxMessage resp = circuit.readMessage();
            if (resp.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(resp);
            }
            this.channel.assignSessionId(session, resp);
            OrionInput in = new OrionInput(session, circuit.getInputStream(), this.channel.makeOrionEncryptionContext(null, false));
            in.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            this.readClientInsert(in, session.getOrionDatabase(), obj);
            BIOrionObject bIOrionObject = obj;
            return bIOrionObject;
        }
    }

    private void readClientInsert(OrionInput in, BOrionDatabase db, BIOrionObject obj) throws Exception {
        BIOrionObject result = in.readObject();
        Property[] props = result.getOrionType().getProperties();
        for (int i = 0; i < props.length; ++i) {
            if (!BOrionObject.isIdentity(props[i])) continue;
            obj.init(props[i], result.get(props[i]));
        }
        obj.setOrionDatabase(db);
    }

    private void insert(FoxCircuit circuit) throws Exception {
        try {
            FoxMessage resp = new FoxMessage();
            OrionSession session = this.channel.getSession(circuit, resp, true);
            OrionInput in = new OrionInput(circuit.getInputStream(), this.channel.makeOrionEncryptionContext(null, false));
            in.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            BIOrionObject obj = in.readObject();
            BOrionDatabase db = session.getOrionDatabase();
            BOrionType type = db.getType(obj.getOrionType());
            BPermissions permissions = this.channel.getPermissionsFor(type);
            if (!permissions.hasAdminWrite()) {
                throw new PermissionException("Insufficient Permission");
            }
            session.insert(obj);
            circuit.writeMessage(resp);
            OrionOutput out = new OrionOutput(circuit.getOutputStream(), this.channel.makeOrionEncryptionContext(null, true));
            out.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            out.writeObject(obj);
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            circuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIOrionObject read(FoxOrionSession session, BIOrionObject obj) throws Exception {
        OrionType type = obj.getOrionType();
        this.channel.setSession(session, circuit);
        try (FoxCircuit circuit = this.channel.openCircuit("read");){
            FoxMessage req = new FoxMessage("params");
            req.add("typeId", type.getOrionTypeId().encodeToString());
            PropertyValue[] keys = PropertyValue.makeKeys(obj);
            for (int i = 0; i < keys.length; ++i) {
                FoxMessage keyMsg = new FoxMessage("key");
                keyMsg.add("name", keys[i].getProperty().getName());
                keyMsg.add("type", keys[i].getProperty().getType().getTypeSpec().encodeToString());
                keyMsg.add("value", PropertyValue.encodeValueToString(keys[i].getValue()));
                req.add("key", keyMsg);
            }
            circuit.writeMessage(req);
            circuit.flush();
            FoxMessage resp = circuit.readMessage();
            if (resp.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(resp);
            }
            this.channel.assignSessionId(session, resp);
            OrionInput in = new OrionInput(session, circuit.getInputStream(), this.channel.makeOrionEncryptionContext(null, false));
            in.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            BIOrionObject result = in.readObject();
            if (result != null) {
                result.setOrionDatabase(session.getOrionDatabase());
            }
            BIOrionObject bIOrionObject = result;
            return bIOrionObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIOrionObject read(FoxOrionSession session, OrionType type, BSimple key) throws Exception {
        this.channel.setSession(session, circuit);
        try (FoxCircuit circuit = this.channel.openCircuit("read");){
            FoxMessage req = new FoxMessage("params");
            req.add("typeId", type.getOrionTypeId().encodeToString());
            Property[] keys = type.getKey();
            if (keys.length != 1) {
                throw new OrionException("Single key required.");
            }
            FoxMessage keyMsg = new FoxMessage("key");
            keyMsg.add("name", keys[0].getName());
            keyMsg.add("type", key.getType().getTypeSpec().encodeToString());
            keyMsg.add("value", key.encodeToString());
            req.add("key", keyMsg);
            circuit.writeMessage(req);
            circuit.flush();
            FoxMessage resp = circuit.readMessage();
            if (resp.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(resp);
            }
            this.channel.assignSessionId(session, resp);
            OrionInput in = new OrionInput(session, circuit.getInputStream(), this.channel.makeOrionEncryptionContext(null, false));
            in.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            BIOrionObject result = in.readObject();
            if (result != null) {
                result.setOrionDatabase(session.getOrionDatabase());
            }
            BIOrionObject bIOrionObject = result;
            return bIOrionObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIOrionObject read(FoxOrionSession session, OrionType type, PropertyValue pval) throws Exception {
        this.channel.setSession(session, circuit);
        try (FoxCircuit circuit = this.channel.openCircuit("read");){
            FoxMessage req = new FoxMessage("params");
            req.add("typeId", type.getOrionTypeId().encodeToString());
            FoxMessage keyMsg = new FoxMessage("key");
            keyMsg.add("name", pval.getProperty().getName());
            keyMsg.add("type", pval.getProperty().getType().getTypeSpec().encodeToString());
            keyMsg.add("value", PropertyValue.encodeValueToString(pval.getValue()));
            req.add("key", keyMsg);
            circuit.writeMessage(req);
            circuit.flush();
            FoxMessage resp = circuit.readMessage();
            if (resp.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(resp);
            }
            this.channel.assignSessionId(session, resp);
            OrionInput in = new OrionInput(session, circuit.getInputStream(), this.channel.makeOrionEncryptionContext(null, false));
            in.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            BIOrionObject result = in.readObject();
            if (result != null) {
                result.setOrionDatabase(session.getOrionDatabase());
            }
            BIOrionObject bIOrionObject = result;
            return bIOrionObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIOrionObject read(FoxOrionSession session, OrionType type, PropertyValue[] pvals) throws Exception {
        this.channel.setSession(session, circuit);
        try (FoxCircuit circuit = this.channel.openCircuit("read");){
            FoxMessage req = new FoxMessage("params");
            req.add("typeId", type.getOrionTypeId().encodeToString());
            for (int i = 0; i < pvals.length; ++i) {
                FoxMessage keyMsg = new FoxMessage("key");
                keyMsg.add("name", pvals[i].getProperty().getName());
                keyMsg.add("type", pvals[i].getProperty().getType().getTypeSpec().encodeToString());
                keyMsg.add("value", PropertyValue.encodeValueToString(pvals[i].getValue()));
                req.add("key", keyMsg);
            }
            circuit.writeMessage(req);
            circuit.flush();
            FoxMessage resp = circuit.readMessage();
            if (resp.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(resp);
            }
            this.channel.assignSessionId(session, resp);
            OrionInput in = new OrionInput(session, circuit.getInputStream(), this.channel.makeOrionEncryptionContext(null, false));
            in.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            BIOrionObject result = in.readObject();
            if (result != null) {
                result.setOrionDatabase(session.getOrionDatabase());
            }
            BIOrionObject bIOrionObject = result;
            return bIOrionObject;
        }
    }

    private void read(FoxCircuit circuit) throws Exception {
        try {
            FoxMessage resp = new FoxMessage();
            OrionSession session = this.channel.getSession(circuit, resp, true);
            FoxMessage req = circuit.readMessage();
            OrionType type = session.getOrionDatabase().getType(BOrionTypeId.make(req.getString("typeId")));
            FoxTuple[] keyMsgs = req.list("key");
            PropertyValue[] keys = new PropertyValue[keyMsgs.length];
            for (int i = 0; i < keyMsgs.length; ++i) {
                FoxMessage keyMsg = (FoxMessage)keyMsgs[i];
                String keyName = keyMsg.getString("name");
                Type keyType = ((BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(keyMsg.getString("type"))).getResolvedType();
                BValue keyValue = PropertyValue.decodeValueFromString(keyType, keyMsg.getString("value"));
                keys[i] = new PropertyValue(type.getProperty(keyName), keyValue);
            }
            BIOrionObject result = session.read(type, keys);
            circuit.writeMessage(resp);
            if (result != null && !this.channel.getPermissionsFor(result).hasOperatorRead()) {
                result = null;
            }
            OrionOutput out = new OrionOutput(circuit.getOutputStream(), this.channel.makeOrionEncryptionContext(null, true));
            out.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            out.writeObject(result);
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            circuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIOrionObject readRaw(FoxOrionSession session, OrionType type, String sql) throws Exception {
        this.channel.setSession(session, circuit);
        try (FoxCircuit circuit = this.channel.openCircuit("readRaw");){
            FoxMessage req = new FoxMessage("params");
            req.add("typeId", type.getOrionTypeId().encodeToString());
            req.add("sql", sql);
            circuit.writeMessage(req);
            circuit.flush();
            FoxMessage resp = circuit.readMessage();
            if (resp.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(resp);
            }
            this.channel.assignSessionId(session, resp);
            OrionInput in = new OrionInput(session, circuit.getInputStream(), this.channel.makeOrionEncryptionContext(null, false));
            in.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            BIOrionObject result = in.readObject();
            if (result != null) {
                result.setOrionDatabase(session.getOrionDatabase());
            }
            BIOrionObject bIOrionObject = result;
            return bIOrionObject;
        }
    }

    private void readRaw(FoxCircuit circuit) throws Exception {
        try {
            FoxMessage resp = new FoxMessage();
            OrionSession session = this.channel.getSession(circuit, resp, true);
            FoxMessage req = circuit.readMessage();
            OrionType type = session.getOrionDatabase().getType(BOrionTypeId.make(req.getString("typeId")));
            String sql = req.getString("sql");
            BIOrionObject result = session.read(type, sql);
            circuit.writeMessage(resp);
            if (result != null && !this.channel.getPermissionsFor(result).hasOperatorRead()) {
                result = null;
            }
            OrionOutput out = new OrionOutput(circuit.getOutputStream(), this.channel.makeOrionEncryptionContext(null, true));
            out.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            out.writeObject(result);
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            circuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIOrionObject preadRaw(FoxOrionSession session, OrionType type, String sql, BSimple[] paramValues) throws Exception {
        this.channel.setSession(session, circuit);
        try (FoxCircuit circuit = this.channel.openCircuit("preadRaw");){
            FoxMessage req = new FoxMessage("params");
            req.add("typeId", type.getOrionTypeId().encodeToString());
            req.add("sql", sql);
            if (paramValues != null) {
                this.channel.encodeParameters(req, paramValues);
            }
            circuit.writeMessage(req);
            circuit.flush();
            FoxMessage resp = circuit.readMessage();
            if (resp.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(resp);
            }
            this.channel.assignSessionId(session, resp);
            OrionInput in = new OrionInput(session, circuit.getInputStream(), this.channel.makeOrionEncryptionContext(null, false));
            in.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            BIOrionObject result = in.readObject();
            if (result != null) {
                result.setOrionDatabase(session.getOrionDatabase());
            }
            BIOrionObject bIOrionObject = result;
            return bIOrionObject;
        }
    }

    private void preadRaw(FoxCircuit circuit) throws Exception {
        try {
            FoxMessage resp = new FoxMessage();
            OrionSession session = this.channel.getSession(circuit, resp, true);
            FoxMessage req = circuit.readMessage();
            OrionType type = session.getOrionDatabase().getType(BOrionTypeId.make(req.getString("typeId")));
            String sql = req.getString("sql");
            BSimple[] paramValues = this.channel.decodeParameters(req);
            BIOrionObject result = session.read(type, sql);
            circuit.writeMessage(resp);
            if (result != null && !this.channel.getPermissionsFor(result).hasOperatorRead()) {
                result = null;
            }
            OrionOutput out = new OrionOutput(circuit.getOutputStream(), this.channel.makeOrionEncryptionContext(null, true));
            out.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            out.writeObject(result);
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            circuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(FoxOrionSession session, BIOrionObject obj, boolean forceUpdate) throws Exception {
        this.channel.setSession(session, circuit);
        try (FoxCircuit circuit = this.channel.openCircuit("update");){
            OrionOutput out = new OrionOutput(circuit.getOutputStream(), this.channel.makeOrionEncryptionContext(null, true));
            out.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            out.writeUpdate(obj);
            out.flush();
            FoxMessage resp = circuit.readMessage();
            if (resp.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(resp);
            }
            this.channel.assignSessionId(session, resp);
        }
    }

    private void update(FoxCircuit circuit) throws Exception {
        try {
            FoxMessage resp = new FoxMessage();
            OrionSession session = this.channel.getSession(circuit, resp, true);
            OrionInput in = new OrionInput(circuit.getInputStream(), this.channel.makeOrionEncryptionContext(null, false));
            in.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            BIOrionObject obj = in.readUpdate();
            OrionType type = obj.getOrionType();
            Property[] keys = type.getKey();
            for (int i = 0; i < keys.length; ++i) {
                obj.setModified(keys[i], false);
            }
            BPermissions permissions = null;
            BIOrionObject orig = session.read(type, PropertyValue.makeKeys(obj));
            permissions = orig == null ? this.channel.getPermissionsFor(session.getOrionDatabase()) : this.channel.getPermissionsFor(orig);
            if (!permissions.hasAdminWrite()) {
                throw new PermissionException("Insufficient Permission");
            }
            session.update(obj);
            circuit.writeMessage(resp);
        }
        catch (Exception e) {
            e.printStackTrace();
            circuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIOrionObject persist(FoxOrionSession session, BIOrionObject obj) throws Exception {
        try (FoxCircuit circuit = this.channel.openCircuit("persist");){
            this.channel.setSession(session, circuit);
            OrionOutput out = new OrionOutput(circuit.getOutputStream(), this.channel.makeOrionEncryptionContext(null, true));
            out.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            out.writeObject(obj);
            out.flush();
            FoxMessage resp = circuit.readMessage();
            if (resp.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(resp);
            }
            OrionInput in = new OrionInput(session, circuit.getInputStream(), this.channel.makeOrionEncryptionContext(null, false));
            in.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            BIOrionObject result = in.readObject();
            Property[] props = result.getOrionType().getProperties();
            for (int i = 0; i < props.length; ++i) {
                if (!BOrionObject.isIdentity(props[i])) continue;
                obj.init(props[i], result.get(props[i]));
            }
            BIOrionObject bIOrionObject = obj;
            return bIOrionObject;
        }
    }

    private void persist(FoxCircuit circuit) throws Exception {
        try {
            FoxMessage resp = new FoxMessage();
            OrionSession session = this.channel.getSession(circuit, resp, true);
            OrionInput in = new OrionInput(circuit.getInputStream(), this.channel.makeOrionEncryptionContext(null, false));
            in.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            BIOrionObject obj = in.readObject();
            BPermissions permissions = null;
            BIOrionObject orig = session.read(obj.getOrionType(), PropertyValue.makeKeys(obj));
            permissions = orig == null ? this.channel.getPermissionsFor(session.getOrionDatabase()) : this.channel.getPermissionsFor(orig);
            if (!permissions.hasAdminWrite()) {
                throw new PermissionException("Insufficient Permission");
            }
            session.persist(obj);
            circuit.writeMessage(resp);
            OrionOutput out = new OrionOutput(circuit.getOutputStream(), this.channel.makeOrionEncryptionContext(null, true));
            out.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            out.writeObject(obj);
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            circuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(FoxOrionSession session, BIOrionObject obj) throws Exception {
        this.channel.setSession(session, circuit);
        try (FoxCircuit circuit = this.channel.openCircuit("delete");){
            OrionOutput out = new OrionOutput(circuit.getOutputStream(), this.channel.makeOrionEncryptionContext(null, true));
            out.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            out.writeUpdate(obj);
            out.flush();
            FoxMessage resp = circuit.readMessage();
            if (resp.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(resp);
            }
            this.channel.assignSessionId(session, resp);
            boolean bl = resp.getBoolean("found");
            return bl;
        }
    }

    private void delete(FoxCircuit circuit) throws Exception {
        try {
            FoxMessage resp = new FoxMessage("deleteResp");
            OrionSession session = this.channel.getSession(circuit, resp, true);
            BOrionService service = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
            OrionInput in = new OrionInput(circuit.getInputStream(), this.channel.makeOrionEncryptionContext(null, false));
            in.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            BIOrionObject obj = in.readObject();
            BPermissions permissions = null;
            BIOrionObject orig = session.read(obj.getOrionType(), PropertyValue.makeKeys(obj));
            permissions = orig == null ? this.channel.getPermissionsFor(session.getOrionDatabase()) : this.channel.getPermissionsFor(orig);
            boolean found = false;
            if (!permissions.hasAdminWrite()) {
                throw new PermissionException("Insufficient Permission");
            }
            found = session.delete(obj);
            resp.add("found", found);
            circuit.writeMessage(resp);
        }
        catch (Exception e) {
            e.printStackTrace();
            circuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)e));
        }
    }

    public OrionCursor qselect(FoxOrionSession session, BQuery query) throws Exception {
        FoxCircuit circuit = this.channel.openCircuit("qselect");
        this.channel.setSession(session, circuit);
        FoxMessage req = new FoxMessage("query");
        if (query != null) {
            req.add("bquery", ValueDocEncoder.marshal((BValue)query));
        }
        circuit.writeMessage(req);
        circuit.flush();
        FoxMessage resp = circuit.readMessage();
        if (resp.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException(resp);
        }
        this.channel.assignSessionId(session, resp);
        circuit.readMessage();
        return new OrionObjectCursor(session, new OrionInput(session, circuit.getInputStream(), this.channel.makeOrionEncryptionContext(null, false)), null, this.channel.getConnection().session().isLegacyConnection());
    }

    private void qselect(FoxCircuit circuit) throws Exception {
        try {
            FoxMessage resp = new FoxMessage();
            OrionSession session = this.channel.getSession(circuit, resp, true);
            circuit.writeMessage(resp);
            BQuery query = null;
            FoxMessage req = circuit.readMessage();
            String marshalled = req.getString("bquery", null);
            if (marshalled == null) {
                throw new OrionException("BQuery is null.");
            }
            query = (BQuery)ValueDocDecoder.unmarshal((String)marshalled);
            OrionCursor result = session.select(query);
            resp = new FoxMessage("resp");
            resp.add("status", "ok");
            circuit.writeMessage(resp);
            circuit.flush();
            OrionOutput out = new OrionOutput(circuit.getOutputStream(), this.channel.makeOrionEncryptionContext(null, true));
            out.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            out.writeType(result.getOrionType());
            while (result.next()) {
                out.writeObject((BIOrionObject)result.get());
            }
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            circuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)e));
        }
    }

    public OrionCursor select(FoxOrionSession session, OrionType type, String sql) throws Exception {
        FoxCircuit circuit = this.channel.openCircuit("select");
        this.channel.setSession(session, circuit);
        FoxMessage req = new FoxMessage("select");
        if (type != null) {
            req.add("typeId", type.getOrionTypeId().encodeToString());
        }
        if (sql != null) {
            req.add("sql", sql);
        }
        circuit.writeMessage(req);
        if (type != null && type.getOrionTypeId().isTemporary()) {
            OrionOutput out = new OrionOutput(circuit.getOutputStream(), this.channel.makeOrionEncryptionContext(null, true));
            out.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            out.writeType(type);
            out.flush();
        }
        circuit.flush();
        FoxMessage resp = circuit.readMessage();
        if (resp.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException(resp);
        }
        this.channel.assignSessionId(session, resp);
        circuit.readMessage();
        return new OrionObjectCursor(session, new OrionInput(session, circuit.getInputStream(), this.channel.makeOrionEncryptionContext(null, false)), null, this.channel.getConnection().session().isLegacyConnection());
    }

    public OrionCursor select(FoxOrionSession session, OrionType type, PropertyValue[] values) throws Exception {
        if (type.getOrionTypeId().isTemporary()) {
            throw new OrionException("Unsupported for temporary type.");
        }
        FoxCircuit circuit = this.channel.openCircuit("select");
        this.channel.setSession(session, circuit);
        FoxMessage req = new FoxMessage("select");
        req.add("typeId", type.getOrionTypeId().encodeToString());
        this.channel.encodePropertyValues(req, "value", values);
        circuit.writeMessage(req);
        circuit.flush();
        FoxMessage resp = circuit.readMessage();
        if (resp.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException(resp);
        }
        this.channel.assignSessionId(session, resp);
        circuit.readMessage();
        return new OrionObjectCursor(session, new OrionInput(session, circuit.getInputStream(), this.channel.makeOrionEncryptionContext(null, false)), null, this.channel.getConnection().session().isLegacyConnection());
    }

    private void select(FoxCircuit circuit) throws Exception {
        try {
            BOrionType dbType;
            BPermissions typePermissions;
            OrionCursor result = null;
            OrionType type = null;
            FoxMessage resp = new FoxMessage();
            OrionSession session = this.channel.getSession(circuit, resp, true);
            circuit.writeMessage(resp);
            String sql = null;
            PropertyValue[] values = null;
            FoxMessage req = circuit.readMessage();
            String typeIdString = req.getString("typeId", null);
            if (typeIdString != null) {
                BOrionTypeId typeId = BOrionTypeId.decode(typeIdString);
                if (typeId.isTemporary()) {
                    OrionInput in = new OrionInput(circuit.getInputStream(), this.channel.makeOrionEncryptionContext(null, false));
                    in.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
                    type = in.readType();
                } else {
                    type = session.getOrionDatabase().getType(typeId);
                }
            }
            if (!(typePermissions = this.channel.getPermissionsFor(dbType = session.getOrionDatabase().getType(type))).hasOperatorRead()) {
                throw new OrionException("Access denied");
            }
            sql = req.getString("sql", null);
            if (sql == null) {
                values = this.channel.decodePropertyValues(type, req, "value");
            }
            if (sql != null) {
                result = session.select(type, sql);
            } else if (values != null) {
                result = session.select(type, values);
            } else {
                throw new OrionException("Invalid select request.");
            }
            resp = new FoxMessage("resp");
            resp.add("status", "ok");
            circuit.writeMessage(resp);
            circuit.flush();
            OrionOutput out = new OrionOutput(circuit.getOutputStream(), this.channel.makeOrionEncryptionContext(null, true));
            out.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            out.writeType(result.getOrionType());
            while (result.next()) {
                out.writeObject((BIOrionObject)result.get());
            }
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            circuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)e));
        }
    }

    public OrionCursor pselect(FoxOrionSession session, OrionType type, String sql, BSimple[] paramValues) throws Exception {
        FoxCircuit circuit = this.channel.openCircuit("pselect");
        this.channel.setSession(session, circuit);
        FoxMessage req = new FoxMessage("pselect");
        if (type != null) {
            req.add("typeId", type.getOrionTypeId().encodeToString());
        }
        if (paramValues != null) {
            this.channel.encodeParameters(req, paramValues);
        }
        if (sql != null) {
            req.add("sql", sql);
        }
        circuit.writeMessage(req);
        if (type != null && type.getOrionTypeId().isTemporary()) {
            OrionOutput out = new OrionOutput(circuit.getOutputStream(), this.channel.makeOrionEncryptionContext(null, true));
            out.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            out.writeType(type);
            out.flush();
        }
        circuit.flush();
        FoxMessage resp = circuit.readMessage();
        if (resp.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException(resp);
        }
        this.channel.assignSessionId(session, resp);
        return new OrionObjectCursor(session, new OrionInput(session, circuit.getInputStream(), this.channel.makeOrionEncryptionContext(null, false)), null, this.channel.getConnection().session().isLegacyConnection());
    }

    private void pselect(FoxCircuit circuit) throws Exception {
        try {
            BOrionType dbType;
            BPermissions typePermissions;
            FoxMessage resp = new FoxMessage();
            OrionSession session = this.channel.getSession(circuit, resp, true);
            circuit.writeMessage(resp);
            OrionType type = null;
            String sql = null;
            BSimple[] paramValues = null;
            FoxMessage req = circuit.readMessage();
            String typeIdString = req.getString("typeId", null);
            if (typeIdString != null) {
                BOrionTypeId typeId = BOrionTypeId.decode(typeIdString);
                if (typeId.isTemporary()) {
                    OrionInput in = new OrionInput(circuit.getInputStream(), this.channel.makeOrionEncryptionContext(null, false));
                    in.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
                    type = in.readType();
                } else {
                    type = session.getOrionDatabase().getType(typeId);
                }
            }
            if (!(typePermissions = this.channel.getPermissionsFor(dbType = session.getOrionDatabase().getType(type))).hasOperatorRead()) {
                throw new OrionException("Access denied");
            }
            sql = req.getString("sql", null);
            paramValues = this.channel.decodeParameters(req);
            OrionCursor result = session.select(type, sql, paramValues);
            OrionOutput out = new OrionOutput(circuit.getOutputStream(), this.channel.makeOrionEncryptionContext(null, true));
            out.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            out.writeType(result.getOrionType());
            while (result.next()) {
                out.writeObject((BIOrionObject)result.get());
            }
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            circuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitSyncBuffer(SyncBuffer sync) throws Exception {
        try (FoxCircuit circuit = this.channel.openCircuit("commitSyncBuffer");){
            SyncEncoder out = new SyncEncoder(circuit.getOutputStream(), null);
            sync.encode(out);
            out.flush();
            FoxMessage resp = circuit.readMessage();
            FoxMessage error = (FoxMessage)resp.getOptional("error");
            if (error != null) {
                throw Fox.exceptionTranslator.messageToException(error);
            }
            SyncBuffer catOps = OrionSyncBuffer.getCategoryOps(sync);
            catOps.commit();
        }
    }

    private void commitSyncBuffer(FoxCircuit circuit) throws Exception {
        try {
            BOrionService service = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
            BOrionSpace space = service.getOrionSpace();
            SyncDecoder in = new SyncDecoder(circuit.getInputStream());
            SyncBuffer buf = space.makeSyncBuffer(false);
            buf.decode(in);
            Context cx = this.channel.getSessionContext();
            buf.commit(cx);
            FoxMessage resp = new FoxMessage();
            circuit.writeMessage(resp);
        }
        catch (Exception e) {
            e.printStackTrace();
            circuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSyncBufferToClient(SyncBuffer buffer) throws Exception {
        try (FoxCircuit circuit = this.channel.openCircuit("sendSyncBufferToClient");){
            SyncEncoder out = new SyncEncoder(circuit.getOutputStream(), null);
            buffer.encode(out);
            out.flush();
            FoxMessage resp = circuit.readMessage();
            FoxMessage error = (FoxMessage)resp.getOptional("error");
            if (error != null) {
                throw Fox.exceptionTranslator.messageToException(error);
            }
        }
    }

    private void receiveSyncBufferFromServer(FoxCircuit circuit) throws Exception {
        BFoxSession foxSession = this.channel.getFoxSession();
        BOrionSpace space = (BOrionSpace)BOrd.make((String)"orion:").get((BObject)foxSession);
        SyncDecoder in = new SyncDecoder(circuit.getInputStream());
        SyncBuffer buf = space.makeSyncBuffer(false);
        buf.decode(in);
        buf.commit(Context.commit);
        FoxMessage resp = new FoxMessage();
        circuit.writeMessage(resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchInsert(FoxOrionSession session, BatchStatement batch) throws Exception {
        try (FoxCircuit circuit = this.channel.openCircuit("batchInsert");){
            this.channel.setSession(session, circuit);
            OrionOutput out = new OrionOutput(circuit.getOutputStream(), this.channel.makeOrionEncryptionContext(null, true));
            out.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            out.writeType(batch.getOrionType());
            out.writeIntElem("chunkSize", "size", batch.getChunkSize());
            out.writeIntElem("batchSize", "size", batch.size());
            for (int i = 0; i < batch.size(); ++i) {
                out.writeObject(batch.get(i));
            }
            out.flush();
            FoxMessage resp = circuit.readMessage();
            if (resp.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(resp);
            }
            this.channel.assignSessionId(session, resp);
            OrionInput in = new OrionInput(session, circuit.getInputStream(), this.channel.makeOrionEncryptionContext(null, false));
            in.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            for (int i = 0; i < batch.size(); ++i) {
                BIOrionObject obj = batch.get(i);
                this.readClientInsert(in, session.getOrionDatabase(), obj);
            }
        }
    }

    private void batchInsert(FoxCircuit circuit) throws Exception {
        try {
            FoxMessage resp = new FoxMessage();
            OrionSession session = this.channel.getSession(circuit, resp, true);
            OrionInput in = new OrionInput(circuit.getInputStream(), this.channel.makeOrionEncryptionContext(null, false));
            in.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            OrionType orionType = in.readType();
            int chunkSize = in.readIntElem("chunkSize", "size");
            int size = in.readIntElem("batchSize", "size");
            BatchStatement batch = session.batchInsert(orionType);
            batch.setChunkSize(chunkSize);
            BIOrionObject[] arr = new BIOrionObject[size];
            for (int i = 0; i < size; ++i) {
                BIOrionObject obj;
                arr[i] = obj = in.readObject();
                batch.add(obj);
            }
            BPermissions permissions = this.channel.getPermissionsFor(orionType);
            if (!permissions.hasAdminWrite()) {
                throw new PermissionException("Insufficient Permission");
            }
            batch.execute();
            circuit.writeMessage(resp);
            OrionOutput out = new OrionOutput(circuit.getOutputStream(), this.channel.makeOrionEncryptionContext(null, true));
            out.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            for (int i = 0; i < size; ++i) {
                out.writeObject(arr[i]);
            }
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            circuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchUpdate(FoxOrionSession session, BatchStatement batch) throws Exception {
        try (FoxCircuit circuit = this.channel.openCircuit("batchUpdate");){
            this.channel.setSession(session, circuit);
            OrionOutput out = new OrionOutput(circuit.getOutputStream(), this.channel.makeOrionEncryptionContext(null, true));
            out.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            out.writeType(batch.getOrionType());
            out.writeIntElem("chunkSize", "size", batch.getChunkSize());
            out.writeIntElem("batchSize", "size", batch.size());
            for (int i = 0; i < batch.size(); ++i) {
                out.writeUpdate(batch.get(i));
            }
            out.flush();
            FoxMessage resp = circuit.readMessage();
            if (resp.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(resp);
            }
            this.channel.assignSessionId(session, resp);
        }
    }

    private void batchUpdate(FoxCircuit circuit) throws Exception {
        try {
            FoxMessage resp = new FoxMessage();
            OrionSession session = this.channel.getSession(circuit, resp, true);
            OrionInput in = new OrionInput(circuit.getInputStream(), this.channel.makeOrionEncryptionContext(null, false));
            in.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            OrionType orionType = in.readType();
            int chunkSize = in.readIntElem("chunkSize", "size");
            int size = in.readIntElem("batchSize", "size");
            BatchStatement batch = session.batchUpdate(orionType);
            batch.setChunkSize(chunkSize);
            for (int i = 0; i < size; ++i) {
                BIOrionObject obj = in.readUpdate();
                batch.add(obj);
                OrionType type = obj.getOrionType();
                Property[] keys = type.getKey();
                for (int j = 0; j < keys.length; ++j) {
                    obj.setModified(keys[j], false);
                }
            }
            BPermissions permissions = this.channel.getPermissionsFor(orionType);
            if (!permissions.hasAdminWrite()) {
                throw new PermissionException("Insufficient Permission");
            }
            batch.execute();
            circuit.writeMessage(resp);
        }
        catch (Exception e) {
            e.printStackTrace();
            circuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchPersist(FoxOrionSession session, BatchStatement batch) throws Exception {
        try (FoxCircuit circuit = this.channel.openCircuit("batchPersist");){
            this.channel.setSession(session, circuit);
            OrionOutput out = new OrionOutput(circuit.getOutputStream(), this.channel.makeOrionEncryptionContext(null, true));
            out.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            out.writeType(batch.getOrionType());
            out.writeIntElem("chunkSize", "size", batch.getChunkSize());
            out.writeIntElem("batchSize", "size", batch.size());
            for (int i = 0; i < batch.size(); ++i) {
                out.writeObject(batch.get(i));
            }
            out.flush();
            FoxMessage resp = circuit.readMessage();
            if (resp.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(resp);
            }
            this.channel.assignSessionId(session, resp);
            OrionInput in = new OrionInput(session, circuit.getInputStream(), this.channel.makeOrionEncryptionContext(null, false));
            in.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            for (int i = 0; i < batch.size(); ++i) {
                BIOrionObject obj = batch.get(i);
                this.readClientInsert(in, session.getOrionDatabase(), obj);
            }
        }
    }

    private void batchPersist(FoxCircuit circuit) throws Exception {
        try {
            FoxMessage resp = new FoxMessage();
            OrionSession session = this.channel.getSession(circuit, resp, true);
            OrionInput in = new OrionInput(circuit.getInputStream(), this.channel.makeOrionEncryptionContext(null, false));
            in.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            OrionType orionType = in.readType();
            int chunkSize = in.readIntElem("chunkSize", "size");
            int size = in.readIntElem("batchSize", "size");
            BatchStatement batch = session.batchPersist(orionType);
            batch.setChunkSize(chunkSize);
            BIOrionObject[] arr = new BIOrionObject[size];
            for (int i = 0; i < size; ++i) {
                BIOrionObject obj;
                arr[i] = obj = in.readObject();
                batch.add(obj);
            }
            BPermissions permissions = this.channel.getPermissionsFor(orionType);
            if (!permissions.hasAdminWrite()) {
                throw new PermissionException("Insufficient Permission");
            }
            batch.execute();
            circuit.writeMessage(resp);
            OrionOutput out = new OrionOutput(circuit.getOutputStream(), this.channel.makeOrionEncryptionContext(null, true));
            out.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            for (int i = 0; i < size; ++i) {
                out.writeObject(arr[i]);
            }
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            circuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchDelete(FoxOrionSession session, BatchStatement batch) throws Exception {
        try (FoxCircuit circuit = this.channel.openCircuit("batchDelete");){
            this.channel.setSession(session, circuit);
            OrionOutput out = new OrionOutput(circuit.getOutputStream(), this.channel.makeOrionEncryptionContext(null, true));
            out.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            out.writeType(batch.getOrionType());
            out.writeIntElem("chunkSize", "size", batch.getChunkSize());
            out.writeIntElem("batchSize", "size", batch.size());
            for (int i = 0; i < batch.size(); ++i) {
                out.writeObject(batch.get(i));
            }
            out.flush();
            FoxMessage resp = circuit.readMessage();
            if (resp.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(resp);
            }
            this.channel.assignSessionId(session, resp);
        }
    }

    private void batchDelete(FoxCircuit circuit) throws Exception {
        try {
            FoxMessage resp = new FoxMessage();
            OrionSession session = this.channel.getSession(circuit, resp, true);
            OrionInput in = new OrionInput(circuit.getInputStream(), this.channel.makeOrionEncryptionContext(null, false));
            in.setLegacyConnection(this.channel.getConnection().session().isLegacyConnection());
            OrionType orionType = in.readType();
            int chunkSize = in.readIntElem("chunkSize", "size");
            int size = in.readIntElem("batchSize", "size");
            BatchStatement batch = session.batchDelete(orionType);
            batch.setChunkSize(chunkSize);
            for (int i = 0; i < size; ++i) {
                batch.add(in.readObject());
            }
            BPermissions permissions = this.channel.getPermissionsFor(orionType);
            if (!permissions.hasAdminWrite()) {
                throw new PermissionException("Insufficient Permission");
            }
            batch.execute();
            circuit.writeMessage(resp);
        }
        catch (Exception e) {
            e.printStackTrace();
            circuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)e));
        }
    }
}

