/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.util;

import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.model.BDynamicOrionObject;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.SqlColumns;
import javax.baja.query.BExpression;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.query.util.Funcs;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BComplex;
import javax.baja.sys.BInteger;
import javax.baja.sys.BSimple;
import javax.baja.sys.Property;

public abstract class CountingUtil {
    public static int getCount(OrionType orionType, OrionSession session) {
        BSqlQuery q = BSqlQuery.make(orionType);
        return CountingUtil.getCount(q, session);
    }

    public static int getCount(OrionType orionType, Property p, BSimple value, OrionSession session) {
        BSqlField recField = new BSqlField(orionType, p);
        BExpression e = Predicates.eq((BExpression)recField, (BSimple)value);
        return CountingUtil.getCount(orionType, e, session);
    }

    public static int getCount(OrionType orionType, BExpression e, OrionSession session) {
        BSqlQuery q = BSqlQuery.make(orionType);
        q.where(e);
        return CountingUtil.getCount(q, session);
    }

    public static int getCount(BQuery q, OrionSession session) {
        q.select(SqlColumns.projection((BProjectionColumn)SqlColumns.make((BExpression)Funcs.count((String)"*"))));
        if (q.hasOrdering()) {
            q.remove((BComplex)q.getOrdering());
        }
        int count = 0;
        try (OrionCursor c = session.select(q);){
            if (c.next()) {
                BDynamicOrionObject result = (BDynamicOrionObject)c.get();
                OrionType type = result.getOrionType();
                Property[] dps = type.getProperties();
                count = ((BInteger)result.get(dps[0])).getInt();
            }
        }
        return count;
    }
}

