/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.util;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.fox.OrionInput;
import com.tridium.orion.priv.util.CursorUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;

public class OrionObjectCursor
implements OrionCursor {
    private OrionSession session;
    private OrionInput in;
    private Context cx;
    private BIOrionObject current;
    private OrionType type;

    public OrionObjectCursor(OrionSession session, OrionInput in, Context cx, boolean legacyConnection) {
        this.session = session;
        this.in = in;
        this.cx = cx;
        in.setLegacyConnection(legacyConnection);
        try {
            this.type = in.readType();
        }
        catch (Exception x) {
            x.printStackTrace();
            this.type = null;
        }
    }

    public Context getContext() {
        return this.cx;
    }

    public void close() {
        this.in.close();
    }

    @Override
    public OrionSession getSession() {
        return this.session;
    }

    @Override
    public OrionType getOrionType() {
        return this.type;
    }

    @Override
    public BIOrionObject[] toArray() {
        return CursorUtil.toArray(this);
    }

    public BObject get() {
        return (BObject)this.current;
    }

    public boolean next() {
        try {
            this.current = this.in.readObject();
            if (this.current != null) {
                if (this.session != null) {
                    this.current.setOrionDatabase(this.session.getOrionDatabase());
                }
            } else {
                this.close();
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            this.current = null;
            this.close();
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.current = null;
            this.close();
            return false;
        }
        return this.current != null;
    }

    @Override
    public boolean next(Class<?> cls) {
        while (this.next()) {
            if (!cls.isInstance(this.get())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean nextComponent() {
        while (this.next()) {
            if (!(this.get() instanceof BComponent)) continue;
            return true;
        }
        return false;
    }
}

