/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.util;

import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.util.BOrionQueueNode;
import com.tridium.orion.priv.util.BQueueItem;
import com.tridium.orion.priv.util.IPersistentQueue;
import com.tridium.orion.priv.util.OrionQueueException;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.PropertyValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.baja.nre.util.IFilter;
import javax.baja.query.BExpression;
import javax.baja.query.BOrderByColumn;
import javax.baja.query.BOrdering;
import javax.baja.query.util.Columns;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;

public final class OrionQueue
implements IPersistentQueue {
    private static final HashMap<OrionType, HashMap<String, IPersistentQueue>> typeToQ = new HashMap();
    protected BOrionDatabase db;
    protected OrionType nodeType;
    protected String queueName;
    protected boolean loaded;
    protected int size;

    public static synchronized IPersistentQueue makeOrionQueue(BOrionDatabase db, OrionType nodeType, String queueName, boolean autoload) {
        if (!nodeType.is(BOrionQueueNode.TYPE)) {
            throw new IllegalArgumentException("nodeType: '" + nodeType + "' is not a " + BOrionQueueNode.TYPE);
        }
        if (queueName.length() > 64) {
            throw new IllegalArgumentException("queueName parameter must be 64 characters or less in length. " + queueName + " is " + queueName.length() + " characters.");
        }
        HashMap<String, IPersistentQueue> nameToQueue = null;
        nameToQueue = typeToQ.get(nodeType);
        if (nameToQueue == null) {
            nameToQueue = new HashMap();
            typeToQ.put(nodeType, nameToQueue);
        }
        IPersistentQueue pq = null;
        pq = nameToQueue.get(queueName);
        if (pq == null) {
            pq = new OrionQueue(db, nodeType, queueName);
            nameToQueue.put(queueName, pq);
        }
        if (autoload) {
            pq.load();
        }
        return pq;
    }

    public static synchronized IPersistentQueue makeOrionQueue(BOrionDatabase db, OrionType nodeType, String queueName) {
        return OrionQueue.makeOrionQueue(db, nodeType, queueName, true);
    }

    protected OrionQueue(BOrionDatabase db, OrionType nodeType, String queueName) {
        this.db = db;
        this.nodeType = nodeType;
        this.queueName = queueName;
        this.loaded = false;
        this.size = 0;
    }

    @Override
    public synchronized void load() {
        if (this.loaded) {
            return;
        }
        OrionSession session = this.getOrionSession();
        OrionCursor cursor = null;
        try {
            cursor = this.selectAll(session);
            while (cursor.next()) {
                ++this.size;
            }
            this.loaded = true;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (session != null) {
                session.close();
            }
        }
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public synchronized void clear() {
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized BValue dequeue() {
        if (this.size == 0) {
            return null;
        }
        BValue returnVal = null;
        try (OrionSession session = this.getOrionSession();){
            BOrionQueueNode dequeuedNode = this.peekNode(session);
            returnVal = dequeuedNode.getQueueItem().getItem();
            if (!session.delete(dequeuedNode)) {
                throw new OrionQueueException("Could not permanently remove the dequeued item.");
            }
            --this.size;
            BValue bValue = returnVal;
            return bValue;
        }
    }

    @Override
    public synchronized BValue dequeue(long timeout) throws InterruptedException {
        if (this.size == 0) {
            this.wait(timeout);
        }
        if (this.size == 0) {
            return null;
        }
        return this.dequeue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void enqueue(BValue value) {
        try (OrionSession session = this.getOrionSession();){
            BOrionQueueNode node = (BOrionQueueNode)this.nodeType.getInstance();
            node.setQueueName(this.queueName);
            node.setQueueItem(new BQueueItem(value));
            session.insert(node);
            ++this.size;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<BValue> filter(IFilter filter, boolean remove) {
        ArrayList<BValue> filteredItems = new ArrayList<BValue>();
        if (this.size == 0) {
            return filteredItems;
        }
        OrionSession session = this.getOrionSession();
        OrionCursor cursor = null;
        try {
            cursor = this.selectAll(session);
            while (cursor.next()) {
                BOrionQueueNode node = (BOrionQueueNode)cursor.get();
                BValue item = node.getQueueItem().getItem();
                if (!filter.accept((Object)item)) continue;
                filteredItems.add(item);
                if (!remove) continue;
                session.delete(node);
                --this.size;
            }
            ArrayList<BValue> arrayList = filteredItems;
            return arrayList;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (session != null) {
                session.close();
            }
        }
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public synchronized BValue peek() {
        try (OrionSession session = this.getOrionSession();){
            BValue bValue = this.peekNode(session).getQueueItem().getItem();
            return bValue;
        }
    }

    @Override
    public synchronized BValue peek(long timeout) throws InterruptedException {
        if (this.size == 0) {
            this.wait(timeout);
        }
        if (this.size == 0) {
            return null;
        }
        return this.peek();
    }

    @Override
    public synchronized int size() {
        return this.size;
    }

    private OrionSession getOrionSession() {
        return this.db.createSession(null);
    }

    private OrionCursor selectAll(OrionSession session) {
        OrionCursor cursor = null;
        cursor = session.select(this.nodeType, new PropertyValue(BOrionQueueNode.queueName, (BValue)BString.make((String)this.queueName)));
        return cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BOrionQueueNode peekNode(OrionSession session) {
        try (OrionCursor cursor = null;){
            BSqlQuery sql = BSqlQuery.make(this.nodeType);
            sql.where(Predicates.eq((Property)BOrionQueueNode.queueName, (BSimple)BString.make((String)this.queueName)));
            sql.orderBy(BOrdering.make((BOrderByColumn)Columns.orderBy((BExpression)new BSqlField(this.nodeType, BOrionQueueNode.id))));
            cursor = session.select(sql);
            if (!cursor.next()) {
                throw new OrionQueueException("Deque returned no items for " + this.queueName + " but size is " + this.size);
            }
            BOrionQueueNode bOrionQueueNode = (BOrionQueueNode)cursor.get();
            return bOrionQueueNode;
        }
    }
}

