/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.util;

import com.tridium.logging.LogSettings;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.sys.Nre;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.TextUtil;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;

public class OrionSessionManager {
    private static Logger logger = Logger.getLogger("orion.sessionManager");
    private static Map<String, TimedStackTrace> stacks = Collections.synchronizedMap(new HashMap());
    private static long count = 0L;
    private static long totalCount = 0L;
    private static int CLOSED_MAX_ENTRIES = 10;
    private static long peakActiveCount = 0L;
    private static Map<String, TimedStackTrace> peakStacks = Collections.synchronizedMap(new HashMap());
    private static BAbsTime peakActiveTime = BAbsTime.DEFAULT;
    private static Map<String, TimedStackTrace> closedStacks = Collections.synchronizedMap(new StackMap());
    private static List<TimedStackTrace> longestStacks = Collections.synchronizedList(new ArrayList());

    public OrionSessionManager() {
        SummaryPage summary = new SummaryPage();
        Nre.spySysManagers.add("orionSessionManager", (Spy)summary);
    }

    public static String getSessionId(DbOrionSession session) {
        return "" + System.identityHashCode(session);
    }

    public void openSpy(DbOrionSession session) {
        if (!logger.isLoggable(Level.FINE)) {
            return;
        }
        totalCount = Long.MAX_VALUE > totalCount ? ++totalCount : ++count;
        try {
            throw new Exception("OpenStackTrace");
        }
        catch (Exception e) {
            stacks.put(OrionSessionManager.getSessionId(session), new TimedStackTrace(e));
            if (count > peakActiveCount) {
                peakActiveTime = BAbsTime.now();
                peakActiveCount = count;
                peakStacks.clear();
                peakStacks.putAll(stacks);
            }
            return;
        }
    }

    public void closeSpy(DbOrionSession session) {
        if (!logger.isLoggable(Level.FINE)) {
            return;
        }
        String sessionId = OrionSessionManager.getSessionId(session);
        TimedStackTrace timedTrace = stacks.remove(sessionId);
        if (timedTrace != null) {
            --count;
        } else {
            timedTrace = new TimedStackTrace(null);
        }
        try {
            throw new Exception("ClosedStackTrace");
        }
        catch (Exception e) {
            BRelTime relTime;
            timedTrace.setClose(e);
            closedStacks.put(sessionId, timedTrace);
            if (peakStacks.get(sessionId) != null) {
                peakStacks.put(sessionId, timedTrace);
            }
            if ((relTime = timedTrace.delta()).getMillis() > 0L) {
                longestStacks.add(timedTrace);
                Collections.sort(longestStacks);
                if (longestStacks.size() >= CLOSED_MAX_ENTRIES) {
                    longestStacks.remove(CLOSED_MAX_ENTRIES - 1);
                }
            }
            return;
        }
    }

    public static long getPeakActiveCount() {
        return peakActiveCount;
    }

    private static class StackMap<K, V>
    extends LinkedHashMap<K, V> {
        private StackMap() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > CLOSED_MAX_ENTRIES;
        }
    }

    static class TimedStackTrace
    implements Comparable<TimedStackTrace> {
        BAbsTime openTime = BAbsTime.now();
        BAbsTime closeTime;
        Exception openTrace;
        Exception closeTrace;

        TimedStackTrace(Exception openTrace) {
            this.openTrace = openTrace;
        }

        void setClose(Exception trace) {
            this.closeTime = BAbsTime.now();
            this.closeTrace = trace;
        }

        @Override
        public int compareTo(TimedStackTrace o) {
            return o.delta().compareTo((Object)this.delta());
        }

        BRelTime delta() {
            if (this.closeTime != null) {
                return this.openTime.delta(this.closeTime);
            }
            return this.openTime.delta(BAbsTime.now());
        }
    }

    private static final class MessageSpy
    extends SpyDir {
        String message;

        private MessageSpy(String message) {
            this.message = message;
        }

        public void write(SpyWriter out) throws Exception {
            out.startProps();
            out.propValueLink((Object)this.message, (Object)"..", (Object)"Return to Orion Session Manager");
            out.endProps();
        }
    }

    public static class SummaryPage
    extends SpyDir {
        public SummaryPage() {
            this.add("closed", (Spy)new ClosedSpy());
            this.add("peakStacks", (Spy)new PeakStacksSpy());
            this.add("longestClosed", (Spy)new LongestClosedSpy());
        }

        public Spy find(String name) {
            if (name.equals("closed") || name.equals("peakStacks") || name.equals("longestClosed")) {
                return super.find(name);
            }
            if (SpyWriter.verifyNameAndCsrfToken((String)name, (String)"fine")) {
                if (!logger.isLoggable(Level.FINE)) {
                    try {
                        LogSettings logSettings = new LogSettings();
                        logSettings.setLogLevel("orion.sessionManager", Level.FINE);
                        LogSettings.reload((Properties)logSettings.getRawProperties());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return new MessageSpy("Cannot set the log level:" + e.toString());
                    }
                }
                return new MessageSpy("Orion Session Manager is now active");
            }
            String namePart = SpyWriter.getNameWithoutCsrfToken((String)name);
            if (SpyWriter.verifyNameAndCsrfToken((String)name, (String)namePart)) {
                return super.find(namePart);
            }
            return super.find(name);
        }

        public void write(SpyWriter out) throws Exception {
            BFacets facets = BFacets.make((String)"showMilliseconds", (boolean)true);
            out.startProps("Closed Stats");
            if (!logger.isLoggable(Level.FINE)) {
                out.prop((Object)"Orion Session Manager Not Active", () -> out.mutatorButton("spy:/sysManagers/orionSessionManager/fine", "Click here to save the orion.sessionManager Log Level as 'fine' "));
                out.endProps();
                return;
            }
            out.prop((Object)"Closed Count", (Object)("" + (totalCount - count)));
            out.propValueLink((Object)"Recently Closed Stack Traces", (Object)"closed", (Object)"View");
            out.propValueLink((Object)"Longest Closed Stack Traces", (Object)"longestClosed", (Object)"View");
            out.endProps();
            out.startProps("Peak Open Stats");
            out.prop((Object)"Peak Open Count", (Object)("" + peakActiveCount));
            out.prop((Object)"Peak Open Time", (Object)("" + peakActiveTime.toString((Context)BFacets.make((String)"showMilliseconds", (boolean)true))));
            out.propValueLink((Object)"Peak Open Stack Traces", (Object)"peakStacks", (Object)"View");
            out.endProps();
            out.startProps("Currently Open Stats");
            out.prop((Object)"Open Count", (Object)("" + count));
            Collection collection = stacks.values();
            Set keySet = stacks.keySet();
            Object[] array = collection.toArray();
            Object[] keys = keySet.toArray();
            if (count != (long)keys.length) {
                out.prop((Object)"Acknowledged Open Count", (Object)("" + (count - (long)keys.length)));
            }
            for (int j = array.length - 1; j >= 0; --j) {
                String name = "" + j;
                RemoveSpy removeSpy = new RemoveSpy(keys[j], name, stacks);
                this.add(name, (Spy)removeSpy);
                out.prop((Object)("Open Session " + keys[j]), () -> out.mutatorButton(name, "Acknowledge"));
                TimedStackTrace timedTrace = (TimedStackTrace)array[j];
                out.prop((Object)"Open Time ", (Object)timedTrace.delta());
                Exception lastStack = timedTrace.openTrace;
                StringWriter result = new StringWriter();
                PrintWriter printWriter = new PrintWriter(result);
                lastStack.printStackTrace(printWriter);
                String[] lines = TextUtil.split((String)((Object)result).toString(), (char)'\n');
                for (int i = 0; i < lines.length; ++i) {
                    if (i == 0) {
                        out.prop((Object)"", (Object)lines[i].toString());
                        continue;
                    }
                    out.prop((Object)"", (Object)lines[i].toString());
                }
            }
            out.endProps();
        }
    }

    public static class PeakStacksSpy
    extends SpyDir {
        public PeakStacksSpy() {
            this.add("resetStats", (Spy)new RemoveAllSpy("resetStats", "Peak Stats Reset", "Return to Peak Stats", peakStacks));
        }

        public Spy find(String name) {
            if (SpyWriter.verifyNameAndCsrfToken((String)name, (String)"resetStats")) {
                return super.find("resetStats");
            }
            return super.find(name);
        }

        public void write(SpyWriter out) {
            out.startProps();
            Collection collection = peakStacks.values();
            Set keySet = peakStacks.keySet();
            Object[] array = collection.toArray();
            Object[] keys = keySet.toArray();
            out.prop((Object)"Peak Open Time", (Object)("" + peakActiveTime.toString((Context)BFacets.make((String)"showMilliseconds", (boolean)true))));
            out.prop((Object)"Peak Open Stacks Count", (Object)("" + keys.length));
            if (peakActiveCount != (long)keys.length) {
                peakActiveCount = keys.length;
            }
            if (array.length > 1) {
                out.prop((Object)"", () -> out.mutatorButton("resetStats", "Reset Stats"));
            }
            for (int j = array.length - 1; j >= 0; --j) {
                TimedStackTrace timeTrace = (TimedStackTrace)array[j];
                if (timeTrace.closeTrace == null) {
                    out.prop((Object)("Open Session " + keys[j]), (Object)"");
                } else {
                    out.prop((Object)("Closed Session " + keys[j]), (Object)"");
                }
                if (timeTrace.closeTrace == null) {
                    out.prop((Object)"Time Session has been Open ", (Object)timeTrace.delta());
                } else {
                    out.prop((Object)"Time Session was Open ", (Object)timeTrace.delta());
                }
                Exception lastStack = timeTrace.openTrace;
                StringWriter result = new StringWriter();
                PrintWriter printWriter = new PrintWriter(result);
                lastStack.printStackTrace(printWriter);
                String[] lines = TextUtil.split((String)((Object)result).toString(), (char)'\n');
                for (int i = 0; i < lines.length; ++i) {
                    if (i == 0) {
                        out.prop((Object)"", (Object)lines[i].toString());
                        continue;
                    }
                    out.prop((Object)"", (Object)lines[i].toString());
                }
            }
            out.endProps();
        }

        public String getTitle() {
            return "peakStacks";
        }
    }

    public static class LongestClosedSpy
    extends SpyDir {
        public LongestClosedSpy() {
            this.add("removeAllLongest", (Spy)new RemoveAllLongSpy("removeAllLongest", "Longest Stack Traces Reset", "Return"));
        }

        public Spy find(String name) {
            if (SpyWriter.verifyNameAndCsrfToken((String)name, (String)"removeAllLongest")) {
                return super.find("removeAllLongest");
            }
            return super.find(name);
        }

        public void write(SpyWriter out) {
            out.startProps();
            out.prop((Object)"", () -> out.mutatorButton("removeAllLongest", "Reset Longest"));
            Object[] array = longestStacks.toArray();
            for (int j = 0; j < array.length; ++j) {
                out.prop((Object)("Closed Session " + j), (Object)"");
                TimedStackTrace timeTrace = (TimedStackTrace)array[j];
                out.prop((Object)"Time Session was Open ", (Object)timeTrace.delta());
                out.prop((Object)"Close Time", (Object)timeTrace.closeTime.toString((Context)BFacets.make((String)"showMilliseconds", (boolean)true)));
                Exception lastStack = timeTrace.closeTrace;
                StringWriter result = new StringWriter();
                PrintWriter printWriter = new PrintWriter(result);
                lastStack.printStackTrace(printWriter);
                String[] lines = TextUtil.split((String)((Object)result).toString(), (char)'\n');
                for (int i = 0; i < lines.length; ++i) {
                    if (i == 0) {
                        out.prop((Object)"", (Object)lines[i].toString());
                        continue;
                    }
                    out.prop((Object)"", (Object)lines[i].toString());
                }
            }
            out.endProps();
        }

        public String getTitle() {
            return "longestClosed";
        }
    }

    public static class ClosedSpy
    extends SpyDir {
        public ClosedSpy() {
            this.add("removeAll", (Spy)new RemoveAllSpy("removeAll", "All Closed Stack Traces Acknowledged", "Return to Closed Traces Summary", closedStacks));
        }

        public Spy find(String name) {
            if (SpyWriter.verifyNameAndCsrfToken((String)name, (String)"removeAll")) {
                return super.find("removeAll");
            }
            String namePart = SpyWriter.getNameWithoutCsrfToken((String)name);
            if (SpyWriter.verifyNameAndCsrfToken((String)name, (String)namePart)) {
                return super.find(namePart);
            }
            return super.find(name);
        }

        public void write(SpyWriter out) {
            out.startProps();
            Collection collection = closedStacks.values();
            Set keySet = closedStacks.keySet();
            Object[] array = collection.toArray();
            Object[] keys = keySet.toArray();
            out.prop((Object)"Recently Closed Stack Traces Count", (Object)("" + keys.length));
            if (array.length > 1) {
                out.prop((Object)"", (Object)out.mutatorButton("removeAll", "Acknowledge All"));
            }
            for (int j = array.length - 1; j >= 0; --j) {
                RemoveSpy removeSpy = new RemoveSpy(keys[j], "" + j, closedStacks);
                String name = "" + j;
                this.add(name, (Spy)removeSpy);
                out.prop((Object)("Closed Session " + keys[j]), () -> out.mutatorButton(name, "Acknowledge"));
                TimedStackTrace timeTrace = (TimedStackTrace)array[j];
                out.prop((Object)"Time Session was Open ", (Object)timeTrace.delta());
                out.prop((Object)"Close Time", (Object)timeTrace.closeTime.toString((Context)BFacets.make((String)"showMilliseconds", (boolean)true)));
                Exception lastStack = timeTrace.closeTrace;
                StringWriter result = new StringWriter();
                PrintWriter printWriter = new PrintWriter(result);
                lastStack.printStackTrace(printWriter);
                String[] lines = TextUtil.split((String)((Object)result).toString(), (char)'\n');
                for (int i = 0; i < lines.length; ++i) {
                    if (i == 0) {
                        out.prop((Object)"", (Object)lines[i].toString());
                        continue;
                    }
                    out.prop((Object)"", (Object)lines[i].toString());
                }
            }
            out.endProps();
        }

        public String getTitle() {
            return "closed";
        }
    }

    public static class RemoveAllSpy
    extends SpyDir {
        private Object key;
        private String title;
        private Map<String, TimedStackTrace> hashMap;
        private String ackMsg;
        private String navMsg;

        public RemoveAllSpy(String title, String ackMsg, String navMsg, Map<String, TimedStackTrace> hashMap) {
            this.title = title;
            this.hashMap = hashMap;
            this.ackMsg = ackMsg;
            this.navMsg = navMsg;
        }

        public void write(SpyWriter out) {
            this.hashMap.clear();
            if (peakStacks == this.hashMap) {
                peakActiveCount = 0L;
            }
            out.startProps();
            out.propValueLink((Object)this.ackMsg, (Object)"..", (Object)this.navMsg);
            out.endProps();
        }

        public String getTitle() {
            return this.title;
        }
    }

    public static class RemoveAllLongSpy
    extends SpyDir {
        private Object key;
        private String title;
        private Map<String, TimedStackTrace> hashMap;
        private String ackMsg;
        private String navMsg;

        public RemoveAllLongSpy(String title, String ackMsg, String navMsg) {
            this.title = title;
            this.ackMsg = ackMsg;
            this.navMsg = navMsg;
        }

        public void write(SpyWriter out) {
            longestStacks.clear();
            out.startProps();
            out.propValueLink((Object)this.ackMsg, (Object)"..", (Object)this.navMsg);
            out.endProps();
        }

        public String getTitle() {
            return this.title;
        }
    }

    public static class RemoveSpy
    extends SpyDir {
        private Object key;
        private String title;
        private Map<String, TimedStackTrace> hashMap;

        public RemoveSpy(Object key, String title, Map<String, TimedStackTrace> hashMap) {
            this.key = key;
            this.title = title;
            this.hashMap = hashMap;
        }

        public void write(SpyWriter out) {
            this.hashMap.remove(this.key);
            out.startProps();
            if (this.hashMap instanceof LinkedHashMap) {
                out.propValueLink((Object)"Stack Trace Acknowledged", (Object)"..", (Object)"Return to Closed Traces Summary");
            } else {
                out.propValueLink((Object)"Stack Trace Acknowledged", (Object)"..", (Object)"Return to Orion Session Manager");
            }
            out.endProps();
        }

        public String getTitle() {
            return this.title;
        }
    }
}

