/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.integration.service;

import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.LicenseCounter;
import com.tridiumx.integration.model.BVisitorTable;
import com.tridiumx.integration.utils.IntegrationUtils;
import com.tridiumx.integration.utils.VisitorIntegrationServiceUpgrade;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.BStringPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.BUuid;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="apiKey", type="BUuid", defaultValue="BUuid.DEFAULT", flags=1), @NiagaraProperty(name="purgeVisitorsOnCheckout", type="BBoolean", defaultValue="BBoolean.TRUE"), @NiagaraProperty(name="retryInterval", type="BInteger", defaultValue="BInteger.make(0)", flags=4), @NiagaraProperty(name="mqttSubscribePoint", type="BOrd", defaultValue="BOrd.NULL"), @NiagaraProperty(name="visitorTable", type="BVisitorTable", defaultValue="BVisitorTable.DEFAULT")})
@NiagaraActions(value={@NiagaraAction(name="loadValues"), @NiagaraAction(name="refreshApiKey"), @NiagaraAction(name="purgeVisitors")})
public class BVisitorIntegrationService
extends BAbstractService
implements BIRestrictedComponent {
    @Generated
    public static final Property apiKey = BVisitorIntegrationService.newProperty((int)1, (BValue)BUuid.DEFAULT, null);
    @Generated
    public static final Property purgeVisitorsOnCheckout = BVisitorIntegrationService.newProperty((int)0, (boolean)((BBoolean)BBoolean.TRUE.as(BBoolean.class)).getBoolean(), null);
    @Generated
    public static final Property retryInterval = BVisitorIntegrationService.newProperty((int)4, (int)((BInteger)BInteger.make((int)0).as(BInteger.class)).getInt(), null);
    @Generated
    public static final Property mqttSubscribePoint = BVisitorIntegrationService.newProperty((int)0, (BValue)BOrd.NULL, null);
    @Generated
    public static final Property visitorTable = BVisitorIntegrationService.newProperty((int)0, (BValue)BVisitorTable.DEFAULT, null);
    @Generated
    public static final Action loadValues = BVisitorIntegrationService.newAction((int)0, null);
    @Generated
    public static final Action refreshApiKey = BVisitorIntegrationService.newAction((int)0, null);
    @Generated
    public static final Action purgeVisitors = BVisitorIntegrationService.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BVisitorIntegrationService.class);
    private static Logger LOGGER = IntegrationUtils.LOGGER;
    private ScheduledExecutorService scheduler;
    private BAbsTime lastActiveTimerTimestamp = BAbsTime.DEFAULT;

    @Generated
    public BUuid getApiKey() {
        return (BUuid)this.get(apiKey);
    }

    @Generated
    public void setApiKey(BUuid v) {
        this.set(apiKey, (BValue)v, null);
    }

    @Generated
    public boolean getPurgeVisitorsOnCheckout() {
        return this.getBoolean(purgeVisitorsOnCheckout);
    }

    @Generated
    public void setPurgeVisitorsOnCheckout(boolean v) {
        this.setBoolean(purgeVisitorsOnCheckout, v, null);
    }

    @Generated
    public int getRetryInterval() {
        return this.getInt(retryInterval);
    }

    @Generated
    public void setRetryInterval(int v) {
        this.setInt(retryInterval, v, null);
    }

    @Generated
    public BOrd getMqttSubscribePoint() {
        return (BOrd)this.get(mqttSubscribePoint);
    }

    @Generated
    public void setMqttSubscribePoint(BOrd v) {
        this.set(mqttSubscribePoint, (BValue)v, null);
    }

    @Generated
    public BVisitorTable getVisitorTable() {
        return (BVisitorTable)this.get(visitorTable);
    }

    @Generated
    public void setVisitorTable(BVisitorTable v) {
        this.set(visitorTable, (BValue)v, null);
    }

    @Generated
    public void loadValues() {
        this.invoke(loadValues, null, null);
    }

    @Generated
    public void refreshApiKey() {
        this.invoke(refreshApiKey, null, null);
    }

    @Generated
    public void purgeVisitors() {
        this.invoke(purgeVisitors, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void doLoadValues(Context cx) {
        this.getVisitorTable().loadEnums(cx);
    }

    public void doRefreshApiKey() {
        this.setApiKey(BUuid.make());
    }

    public void doPurgeVisitors() {
        IntegrationUtils.purgeVisitors();
    }

    public Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "sineVisitorManagement");
    }

    public void started() throws Exception {
        LicenseCounter.checkLicense((Feature)this.getLicenseFeature(), (BAbstractService)this);
        if (!BEnterpriseSecurityService.isWorkstation()) {
            IntegrationUtils.LOGGER.log(Level.WARNING, "Visitor Integration Service starts on supervisor only.");
            throw new Exception("Visitor Integration Service starts on supervisor only.");
        }
        super.started();
        if (this.getApiKey().equals((Object)BUuid.DEFAULT)) {
            this.doRefreshApiKey();
        }
        if (this.isRunning()) {
            this.initRetryTimer();
        }
    }

    private void initRetryTimer() {
        try {
            this.killTimer();
            int retryInSeconds = this.getRetryInterval();
            if (retryInSeconds > 0) {
                this.scheduler = Executors.newSingleThreadScheduledExecutor();
                this.scheduler.scheduleAtFixedRate(() -> {
                    LOGGER.log(Level.FINE, "Keep Alive Timer is scheduled to run at every " + retryInSeconds + " second(s).");
                    this.lastActiveTimerTimestamp = BAbsTime.now();
                    this.keepDevicesAlive();
                }, 0L, retryInSeconds, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception while initiating retry timer to keep alive timeout.", e);
        }
    }

    private void killTimer() {
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.lastActiveTimerTimestamp = BAbsTime.DEFAULT;
            LOGGER.log(Level.INFO, "Stopped Schedule for Keep Alive Task at: " + new Date());
            this.scheduler.shutdown();
        }
    }

    private void keepDevicesAlive() {
        LOGGER.log(Level.FINE, String.format("Started Keep Alive Task at %s", new Date()));
        try {
            BObject mqttSubscribePoint;
            if (!this.getMqttSubscribePoint().isNull() && (mqttSubscribePoint = this.getMqttSubscribePoint().get()) instanceof BStringPoint) {
                BAbstractProxyExt proxyExt = ((BStringPoint)mqttSubscribePoint).getProxyExt();
                if (proxyExt != null) {
                    proxyExt.invoke(proxyExt.getAction("subscribe"), null);
                    LOGGER.log(Level.FINE, String.format("Subscribe action is invoked on %s.", this.getMqttSubscribePoint()));
                } else {
                    LOGGER.log(Level.WARNING, String.format("ProxyExt is not available on %s.", this.getMqttSubscribePoint()));
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, String.format("Failed to invoke subscribe action on %s.", this.getMqttSubscribePoint()), e);
        }
    }

    public boolean isSchedulerRunning() {
        return this.scheduler == null || !this.scheduler.isShutdown();
    }

    public void changed(Property property, Context context) {
        LicenseCounter.checkLicense((Feature)this.getLicenseFeature(), (BAbstractService)this);
        if (!BEnterpriseSecurityService.isWorkstation()) {
            IntegrationUtils.LOGGER.log(Level.WARNING, "Visitor Integration Service starts on supervisor only.");
            return;
        }
        if (this.isRunning()) {
            if (property.equals(enabled)) {
                if (this.getEnabled()) {
                    this.initRetryTimer();
                } else {
                    this.killTimer();
                }
            }
            if (property.equals(retryInterval) && this.getEnabled()) {
                if (this.getRetryInterval() > 0) {
                    this.initRetryTimer();
                } else {
                    this.killTimer();
                }
            }
        }
        super.changed(property, context);
    }

    public void stationStarted() throws Exception {
        super.stationStarted();
        this.asyncStationStarted();
    }

    public BAbsTime getLastActiveTimerTimestamp() {
        return this.lastActiveTimerTimestamp;
    }

    public void asyncStationStarted() {
        VisitorIntegrationServiceUpgrade.upgrade();
    }
}

