/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.integration.transpiler.sine;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.orion.BAuditMode;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionService;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.audit.BOrionAudit;
import com.tridium.orion.priv.audit.BOrionAuditType;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.sys.Nre;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BBadgeStatus;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonInfo;
import com.tridiumx.entsec.isom.BEntsecISOMConfigImpl;
import com.tridiumx.integration.model.BVisitorEnum;
import com.tridiumx.integration.model.BVisitorInput;
import com.tridiumx.integration.service.BVisitorIntegrationService;
import com.tridiumx.integration.transpiler.contract.BITranspiler;
import com.tridiumx.integration.utils.IntegrationConstants;
import com.tridiumx.integration.utils.IntegrationUtils;
import com.tridiumx.isom.BISOMConfig;
import com.tridiumx.isom.validation.validators.ValidatorsManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.util.Predicates;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BSingleton;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.user.BUserService;
import javax.baja.util.BUuid;

@NiagaraType
@NiagaraSingleton
public class BSineTranspiler
extends BSingleton
implements BITranspiler {
    @Generated
    public static final BSineTranspiler INSTANCE = new BSineTranspiler();
    @Generated
    public static final Type TYPE = Sys.loadType(BSineTranspiler.class);
    private static final String UPDATE_CREDENTIAL_HOLDER = "updateCredentialHolder";
    private static final String CREATE_CREDENTIAL_HOLDER = "createCredentialHolder";
    private static final HashMap<String, ValidatorsManager> POST_REQUEST_JSON_DATA_PROPERTIES;
    private static final Map<String, ValidatorsManager> PUT_REQUEST_JSON_DATA_PROPERTIES;
    private static final BISOMConfig config;

    @Generated
    public Type getType() {
        return TYPE;
    }

    private BSineTranspiler() {
    }

    @Override
    public JSONObject transpile(JSONObject jsonObject) {
        BVisitorInput visitorInput = null;
        try {
            if (jsonObject != null && !jsonObject.isEmpty()) {
                String eventType = (String)jsonObject.get("event");
                if ("signin_pending".equals(eventType)) {
                    JSONObject responseJson;
                    visitorInput = this.getVisitorInput(this.getPersonType(jsonObject, null));
                    if (visitorInput == null) {
                        throw new Exception("Visitor specs not defined for this type");
                    }
                    if (this.doSignIn(jsonObject, visitorInput) && (responseJson = this.getResponseJson(jsonObject, visitorInput, "SUCCESS", null)) != null && !responseJson.isEmpty()) {
                        IntegrationUtils.LOGGER.log(Level.FINE, "Sign in pending processed successfully");
                        return responseJson;
                    }
                    throw new Exception("SignIn Failed");
                }
                if ("signin_after".equals(eventType)) {
                    if (!this.isHostAvailable(jsonObject)) {
                        JSONObject responseJson;
                        visitorInput = this.getVisitorInput(this.getPersonType(jsonObject, null));
                        if (visitorInput == null) {
                            throw new Exception("Visitor specs not defined for this type");
                        }
                        if (this.doSignIn(jsonObject, visitorInput) && (responseJson = this.getResponseJson(jsonObject, visitorInput, "SUCCESS", null)) != null && !responseJson.isEmpty()) {
                            IntegrationUtils.LOGGER.log(Level.FINE, "Sign in after processed successfully");
                            return responseJson;
                        }
                        throw new Exception("SignIn Failed");
                    }
                    JSONObject responseJson = this.getResponseJson(jsonObject, null, "SUCCESS", null);
                    if (responseJson != null && !responseJson.isEmpty()) {
                        IntegrationUtils.LOGGER.log(Level.FINE, "Sign in after processed successfully");
                        return responseJson;
                    }
                } else if ("signout_after".equals(eventType)) {
                    JSONObject responseJson;
                    if (this.doSignOut(jsonObject) && (responseJson = this.getResponseJson(jsonObject, null, "SUCCESS", null)) != null && !responseJson.isEmpty()) {
                        IntegrationUtils.LOGGER.log(Level.FINE, "Sign out processed successfully");
                        return responseJson;
                    }
                    throw new Exception("SignOut Failed");
                }
            }
        }
        catch (Exception e) {
            IntegrationUtils.LOGGER.log(Level.WARNING, "Error while transpiling", e);
            return this.getResponseJson(jsonObject, visitorInput, "REJECTED", e.getMessage());
        }
        return null;
    }

    private boolean isHostAvailable(JSONObject jsonObject) {
        JSONObject dataJson = (JSONObject)jsonObject.get("data");
        return !dataJson.isNull("host");
    }

    @Override
    public boolean isIntegrationIdValid(JSONObject jsonObject) {
        BVisitorIntegrationService visitorIntegrationService = (BVisitorIntegrationService)Sys.getService((Type)BVisitorIntegrationService.TYPE);
        return this.getApiKey(jsonObject).equals(visitorIntegrationService.getApiKey().toString());
    }

    @Override
    public JSONObject getResponseJson(JSONObject sineJson, BVisitorInput visitorInput, String responseType, String rejectionMessage) {
        if (sineJson != null && !sineJson.isEmpty()) {
            JSONObject jsonResponse = new JSONObject();
            jsonResponse.put("timestamp", (Object)String.valueOf(BAbsTime.now().getMillis()));
            jsonResponse.put("code", (Object)responseType);
            jsonResponse.put("AWSId", sineJson.get("AWSId"));
            if ("signin_pending".equals(sineJson.get("event"))) {
                jsonResponse.put("notes", (Object)this.getNotes(sineJson, responseType, rejectionMessage));
                String callbackUrl = this.getCallbackUrl(sineJson, responseType);
                if (callbackUrl != null) {
                    jsonResponse.put("callback", (Object)callbackUrl);
                }
                jsonResponse.put("team_api_key", sineJson.get("externalId"));
            }
            return jsonResponse;
        }
        return new JSONObject();
    }

    @Override
    public void purgeVisitors() {
        int purgedVisitorsCount = 0;
        try (OrionSession orionSession = this.getOrionSession(null);){
            BString personType = BString.make((String)"sine_%");
            OrionCursor cursor = orionSession.select(BSqlQuery.make((OrionType)BPerson.ORION_TYPE).where(Predicates.like((Property)BPerson.personType, (BString)personType)));
            while (cursor.next()) {
                BPerson person = (BPerson)cursor.get();
                if (this.isVisitorSignedIn(person) || !orionSession.delete((BIOrionObject)person)) continue;
                ++purgedVisitorsCount;
                this.selfAudit((BOrionObject)person, "", "", "", "Removed", BOrionAuditType.deleted);
                IntegrationUtils.LOGGER.log(Level.FINEST, "Sine user purged : " + person.getFirstName() + " " + person.getLastName());
            }
        }
        catch (Exception e) {
            IntegrationUtils.LOGGER.log(Level.SEVERE, "Purge visitors action failed for Sine Integration.", e);
        }
        IntegrationUtils.LOGGER.log(Level.FINEST, "Purged " + purgedVisitorsCount + " checked out Sine visitor from database.");
    }

    private boolean isVisitorSignedIn(BPerson person) {
        try (OrionSession orionSession = this.getOrionSession(null);){
            BPerson.BadgesCursor cursor = person.getBadges(orionSession);
            while (cursor.next()) {
                if (!BBadgeStatus.active.equals((Object)((BBadge)cursor.get()).getStatus())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private String getNotes(JSONObject sineJson, String responseType, String rejectionMessage) {
        JSONObject jsonObject = new JSONObject();
        if ("SUCCESS".equals(responseType)) {
            try {
                jsonObject.put("badgeNumber", this.getCurrentBadgeNumber(sineJson));
            }
            catch (Exception ignored) {
                IntegrationUtils.LOGGER.log(Level.WARNING, "Unable to retrieve badge number for notes");
            }
        } else {
            jsonObject.put("rejectionMessage", (Object)rejectionMessage);
        }
        return jsonObject.toString();
    }

    private String getCallbackUrl(JSONObject sineJson, String responseType) {
        if (sineJson != null && !sineJson.isEmpty()) {
            JSONObject dataJson = (JSONObject)sineJson.get("data");
            JSONObject callbackJson = (JSONObject)dataJson.get("callbacks");
            if (callbackJson == null) {
                return null;
            }
            if ("SUCCESS".equals(responseType)) {
                return (String)callbackJson.get("accept");
            }
            return (String)callbackJson.get("reject");
        }
        return "";
    }

    private String getApiKey(JSONObject sineJson) {
        if (sineJson != null) {
            return (String)sineJson.get("apiKey");
        }
        return "";
    }

    private boolean doSignIn(JSONObject sineJson, BVisitorInput visitorInput) throws Exception {
        String accessRightsId;
        if (this.isDuplicate(sineJson)) {
            throw new Exception("Duplicate Person");
        }
        String badgeId = this.getOrionBadge(sineJson, visitorInput);
        String personId = this.addOrionPerson(sineJson);
        if (personId != null && this.associateAccessRightsToPerson(sineJson, accessRightsId = this.getAccessRightsId(visitorInput), personId)) {
            return this.associateBadgeToPerson(sineJson, badgeId, personId);
        }
        return false;
    }

    private String getOrionBadge(JSONObject sineJson, BVisitorInput visitorInput) throws Exception {
        String badgeId = this.getBadgeId(sineJson, visitorInput);
        if (badgeId == null) {
            JSONObject newCredentialJson = this.getNewCredentialJson(sineJson, visitorInput);
            if (newCredentialJson != null && !newCredentialJson.isEmpty()) {
                String response = IntegrationUtils.createOrionObjects(POST_REQUEST_JSON_DATA_PROPERTIES.get("Credentials"), config, newCredentialJson, "Credentials");
                JSONObject responseJson = new JSONObject(response);
                badgeId = (String)responseJson.get("id");
            }
        } else {
            try (OrionSession orionSession = this.getOrionSession(null);){
                BBadge badge;
                OrionCursor cursor = orionSession.select(BSqlQuery.make((OrionType)BBadge.ORION_TYPE).where(Predicates.eq((Property)BBadge.badgeId, (BSimple)BString.make((String)badgeId))));
                if (cursor.next() && !BBadgeStatus.issueable.equals((Object)(badge = (BBadge)cursor.get()).getStatus())) {
                    throw new Exception("Badge is already in use");
                }
            }
        }
        return badgeId;
    }

    private JSONObject getNewCredentialJson(JSONObject sineJson, BVisitorInput visitorInput) throws Exception {
        if (sineJson != null) {
            JSONObject newCredentialJson = new JSONObject();
            JSONObject dataJson = (JSONObject)sineJson.get("data");
            newCredentialJson.put("CredentialNumber", (Object)String.format("%05d", this.getCurrentBadgeNumber(sineJson)));
            newCredentialJson.put("FacilityCode", visitorInput.getFacilityCode());
            newCredentialJson.put("WiegandFormatName", (Object)visitorInput.getWiegandFormat().getDisplayTag(null));
            JSONObject validityJson = new JSONObject();
            validityJson.put("ValidFrom", dataJson.get("startDate"));
            validityJson.put("ValidTo", dataJson.get("expiresDate"));
            newCredentialJson.put("Validity", (Object)validityJson);
            return newCredentialJson;
        }
        return new JSONObject();
    }

    private String addOrionPerson(JSONObject sineJson) throws Exception {
        JSONObject credentialHolderJson = this.getCredentialHolderJson(sineJson, null, CREATE_CREDENTIAL_HOLDER);
        if (credentialHolderJson != null && !credentialHolderJson.isEmpty()) {
            String response = IntegrationUtils.createOrionObjects(POST_REQUEST_JSON_DATA_PROPERTIES.get("CredentialHolders"), config, credentialHolderJson, "CredentialHolders");
            JSONObject responseJson = new JSONObject(response);
            String personId = (String)responseJson.get("id");
            try (OrionSession orionSession = this.getOrionSession(null);){
                OrionCursor cursor = orionSession.select(BSqlQuery.make((OrionType)BPerson.ORION_TYPE).where(Predicates.eq((Property)BPerson.personId, (BSimple)BUuid.make((String)personId))));
                if (cursor.next()) {
                    BPerson person = (BPerson)cursor.get();
                    person.setPersonType(this.getPersonType(sineJson, "sine_"));
                    orionSession.update((BIOrionObject)person);
                    this.selfAudit((BOrionObject)person, "", "", "", "Added", BOrionAuditType.created);
                    IntegrationUtils.LOGGER.log(Level.FINEST, "Sine user signed in : " + person.getFirstName() + " " + person.getLastName());
                }
                String string = personId;
                return string;
            }
        }
        return null;
    }

    private boolean associateAccessRightsToPerson(JSONObject sineJson, String accessRightsId, String personId) throws Exception {
        String response = null;
        try {
            JSONObject credentialHolderJson = this.getCredentialHolderJson(sineJson, accessRightsId, UPDATE_CREDENTIAL_HOLDER);
            if (credentialHolderJson != null && !credentialHolderJson.isEmpty()) {
                ArrayList<String> uriItems = new ArrayList<String>(Arrays.asList(IntegrationConstants.URI_PARAMETERS));
                uriItems.add(2, "CredentialHolders");
                uriItems.add(3, personId);
                response = IntegrationUtils.updateOrionObjects(PUT_REQUEST_JSON_DATA_PROPERTIES.get("CredentialHolders"), config, credentialHolderJson, uriItems, null);
            }
        }
        catch (TypeNotFoundException tnfe) {
            IntegrationUtils.LOGGER.log(Level.WARNING, String.format("Incorrect Json Provided %s, could not associate access right.", sineJson.toString()), tnfe);
        }
        return response != null && !response.isEmpty();
    }

    private boolean associateBadgeToPerson(JSONObject sineJson, String badgeId, String personId) throws Exception {
        String response = null;
        try {
            JSONObject credentialJson = this.getCredentialJson(sineJson, personId, "signin_after");
            if (credentialJson != null && !credentialJson.isEmpty()) {
                ArrayList<String> uriItems = new ArrayList<String>(Arrays.asList(IntegrationConstants.URI_PARAMETERS));
                uriItems.add(2, "Credentials");
                uriItems.add(3, badgeId);
                response = IntegrationUtils.updateOrionObjects(PUT_REQUEST_JSON_DATA_PROPERTIES.get("Credentials"), config, credentialJson, uriItems, null);
            }
        }
        catch (TypeNotFoundException tnfe) {
            IntegrationUtils.LOGGER.log(Level.WARNING, String.format("Incorrect Json Provided %s, could not associate badge.", sineJson.toString()), tnfe);
        }
        return response != null && !response.isEmpty();
    }

    private boolean isDuplicate(JSONObject sineJson) {
        if (sineJson != null) {
            try (OrionSession orionSession = this.getOrionSession(null);){
                JSONObject dataJson = (JSONObject)sineJson.get("data");
                BString dataId = BString.make((String)((String)dataJson.get("id")));
                OrionCursor cursor = orionSession.select(BSqlQuery.make((OrionType)BPersonInfo.ORION_TYPE).where(Predicates.eq((Property)BPersonInfo.info3, (BSimple)dataId)));
                boolean bl = cursor.next();
                return bl;
            }
        }
        return false;
    }

    private String getBadgeId(JSONObject sineJson, BVisitorInput visitorInput) throws Exception {
        String facilityCode = String.valueOf(visitorInput.getFacilityCode());
        String wiegandFormat = visitorInput.getWiegandFormat().getDisplayTag(null);
        String currentBadgeNumber = String.format("%05d", this.getCurrentBadgeNumber(sineJson));
        HashMap<String, String[]> queryStringMap = new HashMap<String, String[]>();
        queryStringMap.put("FacilityCode", new String[]{facilityCode});
        queryStringMap.put("WiegandFormatName", new String[]{wiegandFormat});
        queryStringMap.put("CredentialNumber", new String[]{currentBadgeNumber});
        ArrayList<String> uriItems = new ArrayList<String>(Arrays.asList(IntegrationConstants.URI_PARAMETERS));
        uriItems.add(2, "Credentials");
        try {
            String response = IntegrationUtils.getOrionObjects(config, uriItems, queryStringMap);
            JSONObject responseJson = new JSONObject(response);
            return (String)responseJson.get("id");
        }
        catch (Exception e) {
            return null;
        }
    }

    private int getCurrentBadgeNumber(JSONObject sineJson) throws Exception {
        JSONObject dataJson = (JSONObject)sineJson.get("data");
        JSONObject formResponsesJson = (JSONObject)dataJson.get("formResponses");
        JSONArray responses = (JSONArray)formResponsesJson.get("responses");
        if (!responses.isEmpty()) {
            for (Object response : responses) {
                String responseValue = ((String)((JSONObject)response).get("value")).toLowerCase();
                if (!responseValue.startsWith("b-")) continue;
                return Integer.parseInt(responseValue.replace("b-", ""));
            }
            throw new Exception("Form Response for badge number not present");
        }
        throw new Exception("Form Response not present");
    }

    private boolean doSignOut(JSONObject sineJson) throws Exception {
        String personId = this.getPersonIdFromDataId(sineJson);
        if (personId != null) {
            BVisitorIntegrationService visitorIntegrationService = (BVisitorIntegrationService)Sys.getService((Type)BVisitorIntegrationService.TYPE);
            if (visitorIntegrationService.getPurgeVisitorsOnCheckout()) {
                return this.deleteOrionPerson(personId);
            }
            return this.disableBadges(sineJson, personId);
        }
        return false;
    }

    private boolean disableBadges(JSONObject sineJson, String personId) throws Exception {
        String response = null;
        try (OrionSession orionSession = this.getOrionSession(null);){
            JSONObject credentialJson;
            OrionCursor cursor = orionSession.select(BSqlQuery.make((OrionType)BPerson.ORION_TYPE).where(Predicates.eq((Property)BPerson.personId, (BSimple)BUuid.make((String)personId))));
            if (cursor.next() && (credentialJson = this.getCredentialJson(sineJson, null, "signout_after")) != null && !credentialJson.isEmpty()) {
                BPerson person = (BPerson)cursor.get();
                BPerson.BadgesCursor badgesCursor = person.getBadges(orionSession);
                while (badgesCursor.next()) {
                    BBadge badge = (BBadge)badgesCursor.get();
                    String badgeId = badge.getBadgeId();
                    ArrayList<String> uriItems = new ArrayList<String>(Arrays.asList(IntegrationConstants.URI_PARAMETERS));
                    uriItems.add(2, "Credentials");
                    uriItems.add(3, badgeId);
                    response = IntegrationUtils.updateOrionObjects(PUT_REQUEST_JSON_DATA_PROPERTIES.get("Credentials"), config, credentialJson, uriItems, null);
                    this.selfAudit((BOrionObject)badge, BBadge.status.getName(), BBadgeStatus.active.getTag(), BBadgeStatus.disabled.getTag(), "Changed", BOrionAuditType.modified);
                }
                IntegrationUtils.LOGGER.log(Level.FINEST, "Sine user signed out and associated badges disabled : " + person.getFirstName() + " " + person.getLastName());
            }
        }
        catch (TypeNotFoundException tnfe) {
            IntegrationUtils.LOGGER.log(Level.WARNING, String.format("Incorrect Json Provided %s, could not disable badge.", sineJson.toString()), tnfe);
        }
        return response != null && !response.isEmpty();
    }

    private boolean deleteOrionPerson(String personId) {
        String response = null;
        try (OrionSession orionSession = this.getOrionSession(null);){
            OrionCursor cursor = orionSession.select(BSqlQuery.make((OrionType)BPerson.ORION_TYPE).where(Predicates.eq((Property)BPerson.personId, (BSimple)BUuid.make((String)personId))));
            if (cursor.next()) {
                BPerson person = (BPerson)cursor.get();
                this.selfAudit((BOrionObject)person, "", "", "", "Removed", BOrionAuditType.deleted);
                IntegrationUtils.LOGGER.log(Level.FINEST, "Sine user signed out and deleted : " + person.getFirstName() + " " + person.getLastName());
            }
            ArrayList<String> uriItems = new ArrayList<String>(Arrays.asList(IntegrationConstants.URI_PARAMETERS));
            uriItems.add(2, "CredentialHolders");
            uriItems.add(3, personId);
            response = IntegrationUtils.deleteOrionObjects(config, uriItems, null);
        }
        catch (Exception e) {
            IntegrationUtils.LOGGER.log(Level.WARNING, "Unable to delete person.", e);
        }
        return response != null && !response.isEmpty();
    }

    private String getPersonIdFromDataId(JSONObject sineJson) throws Exception {
        String response = null;
        try {
            ArrayList<String> uriItems = new ArrayList<String>(Arrays.asList(IntegrationConstants.URI_PARAMETERS));
            uriItems.add(2, "CredentialHolders");
            HashMap<String, String[]> queryStringMap = new HashMap<String, String[]>();
            JSONObject dataJson = (JSONObject)sineJson.get("data");
            queryStringMap.put("externalSystemID", new String[]{(String)dataJson.get("id")});
            response = IntegrationUtils.getOrionObjects(config, uriItems, queryStringMap);
        }
        catch (TypeNotFoundException tnfe) {
            IntegrationUtils.LOGGER.log(Level.WARNING, "Person with required data id not present.", tnfe);
            return null;
        }
        JSONObject responseJson = new JSONObject(response);
        return (String)responseJson.get("id");
    }

    private void selfAudit(BOrionObject orionObject, String slotName, String oldValue, String newValue, String auditEvent, BOrionAuditType auditType) {
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        String username = userService.getUser("SineUser").getUsername();
        try (OrionSession orionSession = this.getOrionSession(null);){
            Auditor auditor;
            BOrionService orionService = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
            BAuditMode mode = orionService.getAuditMode();
            if (BAuditMode.both.equals((Object)mode) || BAuditMode.databaseRecord.equals((Object)mode)) {
                BOrionAudit rec = this.makeAuditRecord(orionSession, orionObject, slotName, oldValue, newValue, username, auditType);
                orionSession.insert((BIOrionObject)rec);
            }
            if ((BAuditMode.both.equals((Object)mode) || BAuditMode.auditEvent.equals((Object)mode)) && (auditor = Nre.auditor) != null) {
                auditor.audit(this.makeAuditEvent(orionSession, orionObject, slotName, oldValue, newValue, username, auditEvent));
            }
        }
    }

    private BOrionAudit makeAuditRecord(OrionSession orionSession, BOrionObject orionObject, String slotName, String oldValue, String newValue, String username, BOrionAuditType auditType) {
        BOrionAudit rec = new BOrionAudit();
        rec.setTimestamp(BAbsTime.now());
        rec.setUserName(username);
        rec.setObjectTypeSpec(orionObject.getOrionType().getTypeSpec());
        rec.setObjectDisplay(orionObject.toDisplayString((Context)orionSession));
        rec.setOldValue(oldValue);
        rec.setNewValue(newValue);
        rec.setSlotName(slotName);
        rec.setAuditType(auditType);
        return rec;
    }

    private AuditEvent makeAuditEvent(OrionSession orionSession, BOrionObject orionObject, String slotName, String oldValue, String newValue, String username, String auditEvent) {
        String target = "Orion " + orionObject.getOrionType().getDisplayName(null) + ", " + orionObject.toDisplayString((Context)orionSession);
        AuditEvent event = new AuditEvent(auditEvent, target, slotName, oldValue, newValue, username);
        return event;
    }

    private JSONObject getCredentialJson(JSONObject sineJson, String personId, String event) {
        if (sineJson != null) {
            JSONObject credentialJson = new JSONObject();
            JSONObject dataJson = (JSONObject)sineJson.get("data");
            if ("signin_after".equals(event)) {
                credentialJson.put("Enable", true);
                JSONObject validityJson = new JSONObject();
                validityJson.put("ValidFrom", dataJson.get("startDate"));
                validityJson.put("ValidTo", dataJson.get("expiresDate"));
                credentialJson.put("Validity", (Object)validityJson);
                JSONArray relationArray = new JSONArray();
                JSONObject relationJson = new JSONObject();
                relationJson.put("CredentialAssignedToCredentialHolder", (Object)personId);
                relationArray.put((Object)relationJson);
                credentialJson.put("Relation", (Object)relationArray);
            } else if ("signout_after".equals(event)) {
                credentialJson.put("Enable", false);
                JSONObject validityJson = new JSONObject();
                validityJson.put("ValidFrom", dataJson.get("startDate"));
                validityJson.put("ValidTo", dataJson.get("expiresDate"));
                credentialJson.put("Validity", (Object)validityJson);
            }
            return credentialJson;
        }
        return new JSONObject();
    }

    private JSONObject getCredentialHolderJson(JSONObject sineJson, String accessRightsId, String task) {
        if (sineJson != null && !sineJson.isEmpty()) {
            JSONObject credentialHolderJson = new JSONObject();
            if (CREATE_CREDENTIAL_HOLDER.equals(task)) {
                JSONObject dataJson = (JSONObject)sineJson.get("data");
                credentialHolderJson.put("externalSystemID", dataJson.get("id"));
                credentialHolderJson.put("LastName", dataJson.get("lastName"));
                credentialHolderJson.put("Name", dataJson.get("firstName"));
                if (!dataJson.isNull("mobile") && !dataJson.get("mobile").equals("")) {
                    credentialHolderJson.put("ContactNo", dataJson.get("mobile"));
                }
                if (!dataJson.isNull("email") && !dataJson.get("email").equals("")) {
                    if (dataJson.get("email").toString().length() <= 64) {
                        credentialHolderJson.put("EmailId", dataJson.get("email"));
                    } else {
                        IntegrationUtils.LOGGER.log(Level.WARNING, "Email address is longer than 64 characters and not saved in database");
                    }
                }
            } else if (UPDATE_CREDENTIAL_HOLDER.equals(task)) {
                JSONArray relationArray = new JSONArray();
                JSONObject relationJson = new JSONObject();
                relationJson.put("PermissionToCredentialHolder", (Object)accessRightsId);
                relationArray.put((Object)relationJson);
                credentialHolderJson.put("Relation", (Object)relationArray);
            }
            return credentialHolderJson;
        }
        return new JSONObject();
    }

    private String getAccessRightsId(BVisitorInput visitorInput) throws Exception {
        Throwable throwable = null;
        try (OrionSession orionSession = this.getOrionSession(null);){
            String accessRightName = visitorInput.getAccessRights().getDisplayTag(null);
            OrionCursor cursor = orionSession.select(BSqlQuery.make((OrionType)BAccessRight.ORION_TYPE).where(Predicates.eq((Property)BAccessRight.accessRightName, (BSimple)BString.make((String)accessRightName))));
            if (cursor.next()) {
                BAccessRight accessRights = (BAccessRight)cursor.get();
                String string = accessRights.getAccessRightId().toString();
                return string;
            }
            try {
                throw new Exception("Access Rights not found");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private String getPersonType(JSONObject sineJson, String prefix) {
        if (sineJson != null && !sineJson.isEmpty()) {
            JSONObject dataJson = (JSONObject)sineJson.get("data");
            JSONObject visitorTypeJson = (JSONObject)dataJson.get("visitorType");
            String personType = (String)visitorTypeJson.get("name");
            if (prefix != null) {
                personType = prefix + personType;
            }
            return personType;
        }
        return "";
    }

    private BVisitorInput getVisitorInput(String sineVisitorType) {
        BVisitorIntegrationService visitorIntegrationService = (BVisitorIntegrationService)Sys.getService((Type)BVisitorIntegrationService.TYPE);
        BVisitorInput[] visitorInputArray = (BVisitorInput[])visitorIntegrationService.getVisitorTable().getChildren(BVisitorInput.class);
        Predicate<BVisitorInput> hasVisitorType = vi -> sineVisitorType.equalsIgnoreCase(vi.getVisitorType().getTag());
        List viList = Arrays.stream(visitorInputArray).filter(hasVisitorType).collect(Collectors.toList());
        if (viList.isEmpty()) {
            Predicate<BVisitorInput> hasOthersType = vi -> BVisitorEnum.DEFAULT.getTag().equalsIgnoreCase(vi.getVisitorType().getTag());
            viList = Arrays.stream(visitorInputArray).filter(hasOthersType).collect(Collectors.toList());
            if (viList.isEmpty()) {
                return null;
            }
        }
        return (BVisitorInput)((Object)viList.get(0));
    }

    private OrionSession getOrionSession(Context context) {
        BOrionDatabase orionDatabase = BOrionService.getService().getOrionDatabases()[0];
        OrionSession orionSession = orionDatabase.createSession(context);
        orionSession.setAutoCommit(true);
        return orionSession;
    }

    static {
        config = new BEntsecISOMConfigImpl();
        POST_REQUEST_JSON_DATA_PROPERTIES = new HashMap();
        POST_REQUEST_JSON_DATA_PROPERTIES.put("CredentialHolders", new ValidatorsManager("/rc/properties/credentialHoldersJSONPost.properties"));
        POST_REQUEST_JSON_DATA_PROPERTIES.put("Credentials", new ValidatorsManager("/rc/properties/credentialJSONPost.properties"));
        PUT_REQUEST_JSON_DATA_PROPERTIES = new HashMap<String, ValidatorsManager>();
        PUT_REQUEST_JSON_DATA_PROPERTIES.put("CredentialHolders", new ValidatorsManager("/rc/properties/credentialHoldersJSONPut.properties"));
        PUT_REQUEST_JSON_DATA_PROPERTIES.put("Credentials", new ValidatorsManager("/rc/properties/credentialJSONPut.properties"));
    }
}

