/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.integration.utils;

import com.tridium.json.JSONObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionService;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BSqlQuery;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.orion.BWiegandFormat;
import com.tridiumx.integration.service.BVisitorIntegrationService;
import com.tridiumx.integration.transpiler.contract.BITranspiler;
import com.tridiumx.integration.utils.TranspilerFactory;
import com.tridiumx.isom.BISOMConfig;
import com.tridiumx.isom.JSONUtil;
import com.tridiumx.isom.factory.DataObjectFactory;
import com.tridiumx.isom.validation.validators.ValidatorsManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.license.LicenseException;
import javax.baja.naming.SlotPath;
import javax.baja.query.BQuery;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;

public class IntegrationUtils {
    public static final Logger LOGGER = Logger.getLogger("visitorintegration");

    public static JSONObject initIntegration(JSONObject jsonObject) {
        if (!jsonObject.isNull("event")) {
            String event = (String)jsonObject.get("event");
            BITranspiler transpiler = TranspilerFactory.getTranspiler(event);
            if (transpiler != null) {
                if (!transpiler.isIntegrationIdValid(jsonObject)) {
                    LOGGER.log(Level.WARNING, "Integration id unverified");
                    return transpiler.getResponseJson(jsonObject, null, "REJECTED", "Id does not match");
                }
                return transpiler.transpile(jsonObject);
            }
            LOGGER.log(Level.WARNING, "No transpiler present for event : " + event);
        } else {
            LOGGER.log(Level.WARNING, "Event tag not present in json");
        }
        return new JSONObject();
    }

    public static boolean isLicensed() {
        BVisitorIntegrationService visitorIntegrationService = (BVisitorIntegrationService)Sys.getService((Type)BVisitorIntegrationService.TYPE);
        try {
            visitorIntegrationService.getLicenseFeature().check();
        }
        catch (LicenseException ex) {
            LOGGER.log(Level.SEVERE, "Feature sineVisitorManagement has expired", ex);
            return false;
        }
        return true;
    }

    public static String getOrionObjects(BISOMConfig config, List<String> uriItems, Map<String, String[]> queryStringMap) throws Exception {
        BQuery query = DataObjectFactory.createQueryObject(uriItems, queryStringMap, (BISOMConfig)config);
        BOrionObject[] orionObjects = null;
        if (IntegrationUtils.urlHasAssociatedEntity(uriItems)) {
            String associatedOrionObjectInfoInUri = uriItems.get(4);
            orionObjects = config.getRefObject(query, associatedOrionObjectInfoInUri);
            if (orionObjects == null) {
                throw new TypeNotFoundException("ResourceInstanceNotPresent");
            }
        } else {
            orionObjects = config.queryObjects(query);
        }
        if (orionObjects != null && orionObjects.length > 0) {
            return DataObjectFactory.createResponseJSONString((BISOMConfig)config, (BOrionObject[])orionObjects);
        }
        throw new TypeNotFoundException("ResourceInstanceNotPresent");
    }

    public static String createOrionObjects(ValidatorsManager validatorsManager, BISOMConfig config, JSONObject jsonObject, String entityName) throws Exception {
        BOrionObject additionalInfoOrionObjects;
        DataObjectFactory.validateInputJSONObject((ValidatorsManager)validatorsManager, (JSONObject)jsonObject);
        BOrionObject orionObject = config.orionObjectFromJson(jsonObject, entityName);
        BOrionObject[] newOrionObjects = config.createNewObjects(new BOrionObject[]{orionObject});
        if (config.checkIfOrionObjectHasAdditionalInfo(newOrionObjects[0]) && (additionalInfoOrionObjects = config.additionalInfoOrionObjectFromJson(jsonObject, newOrionObjects[0])) != null) {
            config.createAdditionalInfoObjects(new BOrionObject[]{additionalInfoOrionObjects});
        }
        JSONObject response = JSONUtil.getJSONObjectWithIds((BOrionObject[])newOrionObjects, (Property)config.getIdentifierProperty(entityName));
        return response.toString();
    }

    public static String updateOrionObjects(ValidatorsManager validatorsManager, BISOMConfig config, JSONObject jsonObject, List<String> uriItems, Map<String, String[]> queryStringMap) throws Exception {
        DataObjectFactory.validateInputJSONObject((ValidatorsManager)validatorsManager, (JSONObject)jsonObject);
        BQuery query = DataObjectFactory.createQueryObject(uriItems, queryStringMap, (BISOMConfig)config);
        BOrionObject[] orionObjects = config.queryObjects(query);
        if (orionObjects == null || orionObjects.length == 0) {
            throw new TypeNotFoundException("ResourceInstanceNotPresent");
        }
        BOrionObject orionObjectToBeUpdated = config.populateOrionObjectFromJson(jsonObject, orionObjects[0]);
        BOrionObject[] orionObjectsAfterUpdate = config.updateObjects(jsonObject, orionObjectToBeUpdated);
        if (orionObjectsAfterUpdate == null || orionObjectsAfterUpdate.length == 0) {
            throw new TypeNotFoundException("ResourceInstanceNotPresent");
        }
        return IntegrationUtils.prepareAndSendResponse(true, queryStringMap, uriItems);
    }

    public static String deleteOrionObjects(BISOMConfig config, List<String> uriItems, Map<String, String[]> queryStringMap) throws Exception {
        BQuery query = DataObjectFactory.createQueryObject(uriItems, queryStringMap, (BISOMConfig)config);
        boolean result = config.deleteObjects(query);
        return IntegrationUtils.prepareAndSendResponse(result, queryStringMap, uriItems);
    }

    private static boolean urlHasAssociatedEntity(List<String> uriItems) {
        return uriItems.size() > 4 && uriItems.get(4) != null && !uriItems.get(4).equalsIgnoreCase("config");
    }

    private static String prepareAndSendResponse(boolean result, Map<String, String[]> queryStringMap, List<String> uriItems) throws Exception {
        if (result) {
            String externalSystemId = null;
            if (queryStringMap != null) {
                String string = externalSystemId = queryStringMap.get("externalSystemID") == null ? null : queryStringMap.get("externalSystemID")[0];
            }
            if (externalSystemId == null) {
                return DataObjectFactory.createResponseJSONString((String)uriItems.get(3), (String)"id");
            }
            return DataObjectFactory.createResponseJSONString(externalSystemId, (String)"externalSystemID");
        }
        throw new TypeNotFoundException("ResourceInstanceNotPresent");
    }

    public static BDynamicEnum loadAccessRights(Context cx) {
        try (OrionSession orionSession = IntegrationUtils.getOrionSession(cx);){
            OrionCursor cursor = orionSession.select((BQuery)BSqlQuery.make((OrionType)BAccessRight.ORION_TYPE));
            ArrayList<String> tags = new ArrayList<String>();
            while (cursor.next()) {
                tags.add(SlotPath.escape((String)((BAccessRight)cursor.get()).getAccessRightName()));
            }
            String[] tagsArray = new String[tags.size()];
            BDynamicEnum bDynamicEnum = BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((String[])tags.toArray(tagsArray)));
            return bDynamicEnum;
        }
    }

    public static HashMap<String, BDynamicEnum> loadWiegandFormat(Context cx) {
        try (OrionSession orionSession = IntegrationUtils.getOrionSession(cx);){
            OrionCursor cursor = orionSession.select((BQuery)BSqlQuery.make((OrionType)BWiegandFormat.ORION_TYPE));
            ArrayList<String> wiegandFormatTags = new ArrayList<String>();
            ArrayList<String> maxFacilityCodeTags = new ArrayList<String>();
            while (cursor.next()) {
                BWiegandFormat wiegandFormat = (BWiegandFormat)cursor.get();
                wiegandFormatTags.add(SlotPath.escape((String)wiegandFormat.getWiegandFormatName()));
                maxFacilityCodeTags.add(SlotPath.escape((String)(wiegandFormat.getWiegandFormatName() + " FC:" + ((int)Math.pow(2.0, wiegandFormat.getFacilityLength()) - 1))));
            }
            String[] wiegandFormatTagsArray = new String[wiegandFormatTags.size()];
            String[] maxFacilityCodeTagsArray = new String[maxFacilityCodeTags.size()];
            HashMap<String, BDynamicEnum> map = new HashMap<String, BDynamicEnum>();
            map.put("wiegandFormat", BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((String[])wiegandFormatTags.toArray(wiegandFormatTagsArray))));
            map.put("maxFacilityCode", BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((String[])maxFacilityCodeTags.toArray(maxFacilityCodeTagsArray))));
            HashMap<String, BDynamicEnum> hashMap = map;
            return hashMap;
        }
    }

    private static OrionSession getOrionSession(Context cx) {
        BOrionDatabase[] orionDatabases = BOrionService.getService().getOrionDatabases();
        if (orionDatabases.length > 0) {
            OrionSession orionSession = orionDatabases[0].createSession(cx);
            orionSession.setAutoCommit(false);
            return orionSession;
        }
        return null;
    }

    public static void purgeVisitors() {
        TranspilerFactory.getAllTranspilers().forEach(BITranspiler::purgeVisitors);
    }
}

