/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScanJ645;

import com.tridium.platHwScan.BBaseBoard;
import com.tridium.platHwScan.BHardwareScanService;
import com.tridium.platHwScan.enums.BHwScanStatusEnum;
import com.tridium.platHwScan.enums.BPortTypeEnum;
import com.tridium.platHwScan.optionCards.BOptionCard;
import com.tridium.platHwScan.optionCards.BOptionSlot;
import com.tridium.platHwScan.ports.BEthernetPort;
import com.tridium.platHwScan.ports.BPort;
import com.tridium.platHwScan.util.BHardwareRef;
import com.tridium.sys.Nre;
import java.util.Vector;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="LAN1", type="BEthernetPort", defaultValue="new BEthernetPort(\"en0\")", flags=1), @NiagaraProperty(name="LAN2", type="BEthernetPort", defaultValue="new BEthernetPort(\"en1\")", flags=1), @NiagaraProperty(name="COM1", type="BPort", defaultValue="new BPort(BPortTypeEnum.rs232, \"tridium:serial\", HwScanConst.COM)", flags=1), @NiagaraProperty(name="COM2", type="BPort", defaultValue="new BPort(BPortTypeEnum.rs232, \"tridium:serial\", HwScanConst.COM)", flags=1), @NiagaraProperty(name="COM3", type="BPort", defaultValue="new BPort(BPortTypeEnum.rs485, \"tridium:serial\", HwScanConst.COM)", flags=1), @NiagaraProperty(name="COM4", type="BPort", defaultValue="new BPort(BPortTypeEnum.rs485, \"tridium:serial\", HwScanConst.COM)", flags=1), @NiagaraProperty(name="COM5", type="BPort", defaultValue="new BPort(BPortTypeEnum.rs485, \"tridium:serial\", HwScanConst.COM)", flags=1), @NiagaraProperty(name="COM6", type="BPort", defaultValue="new BPort(BPortTypeEnum.rs485, \"tridium:serial\", HwScanConst.COM)", flags=1), @NiagaraProperty(name="LON1", type="BPort", defaultValue="new BPort(BPortTypeEnum.lon, \"tridium:lonworks\")", flags=1), @NiagaraProperty(name="optionSlot1", type="BOptionSlot", defaultValue="new BOptionSlot(1)", flags=1)})
public class BJ645Board
extends BBaseBoard {
    @Generated
    public static final Property LAN1 = BJ645Board.newProperty((int)1, (BValue)new BEthernetPort("en0"), null);
    @Generated
    public static final Property LAN2 = BJ645Board.newProperty((int)1, (BValue)new BEthernetPort("en1"), null);
    @Generated
    public static final Property COM1 = BJ645Board.newProperty((int)1, (BValue)new BPort(BPortTypeEnum.rs232, "tridium:serial", "COM"), null);
    @Generated
    public static final Property COM2 = BJ645Board.newProperty((int)1, (BValue)new BPort(BPortTypeEnum.rs232, "tridium:serial", "COM"), null);
    @Generated
    public static final Property COM3 = BJ645Board.newProperty((int)1, (BValue)new BPort(BPortTypeEnum.rs485, "tridium:serial", "COM"), null);
    @Generated
    public static final Property COM4 = BJ645Board.newProperty((int)1, (BValue)new BPort(BPortTypeEnum.rs485, "tridium:serial", "COM"), null);
    @Generated
    public static final Property COM5 = BJ645Board.newProperty((int)1, (BValue)new BPort(BPortTypeEnum.rs485, "tridium:serial", "COM"), null);
    @Generated
    public static final Property COM6 = BJ645Board.newProperty((int)1, (BValue)new BPort(BPortTypeEnum.rs485, "tridium:serial", "COM"), null);
    @Generated
    public static final Property LON1 = BJ645Board.newProperty((int)1, (BValue)new BPort(BPortTypeEnum.lon, "tridium:lonworks"), null);
    @Generated
    public static final Property optionSlot1 = BJ645Board.newProperty((int)1, (BValue)new BOptionSlot(1), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BJ645Board.class);
    private static final Lexicon lex = Lexicon.make(BJ645Board.class);
    private static final String BASE_BOARD_CODE = "08";
    private static final String VIEW = "pxView";
    private static final String IMAGES_DIR = "imageDir";
    private static final int BASE_LAN_PORT = 3;
    private static final int BASE_LON_PORT = 2;
    private static final int BASE_SERIAL_PORT = 7;
    private static final int HARDWARE_REF_COUNT = 15;

    @Generated
    public BEthernetPort getLAN1() {
        return (BEthernetPort)this.get(LAN1);
    }

    @Generated
    public void setLAN1(BEthernetPort v) {
        this.set(LAN1, (BValue)v, null);
    }

    @Generated
    public BEthernetPort getLAN2() {
        return (BEthernetPort)this.get(LAN2);
    }

    @Generated
    public void setLAN2(BEthernetPort v) {
        this.set(LAN2, (BValue)v, null);
    }

    @Generated
    public BPort getCOM1() {
        return (BPort)this.get(COM1);
    }

    @Generated
    public void setCOM1(BPort v) {
        this.set(COM1, (BValue)v, null);
    }

    @Generated
    public BPort getCOM2() {
        return (BPort)this.get(COM2);
    }

    @Generated
    public void setCOM2(BPort v) {
        this.set(COM2, (BValue)v, null);
    }

    @Generated
    public BPort getCOM3() {
        return (BPort)this.get(COM3);
    }

    @Generated
    public void setCOM3(BPort v) {
        this.set(COM3, (BValue)v, null);
    }

    @Generated
    public BPort getCOM4() {
        return (BPort)this.get(COM4);
    }

    @Generated
    public void setCOM4(BPort v) {
        this.set(COM4, (BValue)v, null);
    }

    @Generated
    public BPort getCOM5() {
        return (BPort)this.get(COM5);
    }

    @Generated
    public void setCOM5(BPort v) {
        this.set(COM5, (BValue)v, null);
    }

    @Generated
    public BPort getCOM6() {
        return (BPort)this.get(COM6);
    }

    @Generated
    public void setCOM6(BPort v) {
        this.set(COM6, (BValue)v, null);
    }

    @Generated
    public BPort getLON1() {
        return (BPort)this.get(LON1);
    }

    @Generated
    public void setLON1(BPort v) {
        this.set(LON1, (BValue)v, null);
    }

    @Generated
    public BOptionSlot getOptionSlot1() {
        return (BOptionSlot)this.get(optionSlot1);
    }

    @Generated
    public void setOptionSlot1(BOptionSlot v) {
        this.set(optionSlot1, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void autoConfig(Array<String> optCardCodes, boolean simulation) {
        this.setSimulation(simulation);
        this.setProductModel(lex.getText(Nre.getHostModel().toUpperCase()));
        this.initializeStandardPorts();
        this.nextSerialPort = 7;
        this.nextLonPort = 2;
        this.nextLanPort = 3;
        this.configureOptionSlot(this.getOptionSlot1(), (String)optCardCodes.get(0), (String)optCardCodes.get(1));
    }

    public String getBoardCode() {
        return BASE_BOARD_CODE;
    }

    public Vector<BHardwareRef> getHardwareRefs() {
        Vector<BHardwareRef> v = new Vector<BHardwareRef>();
        block17: for (int i = 1; i <= 15; ++i) {
            switch (i) {
                case 1: {
                    v.addElement(this.makeBaseboardCommRef(i, this.getLON1()));
                    continue block17;
                }
                case 2: {
                    v.addElement(new BHardwareRef(i, this.getBaseUnitText(), lex.getText("HardwareRef.npm6eBoard")));
                    continue block17;
                }
                case 3: {
                    v.addElement(this.makeBaseboardCommRef(i, (BPort)this.getLAN2()));
                    continue block17;
                }
                case 4: {
                    v.addElement(this.makeBaseboardCommRef(i, (BPort)this.getLAN1()));
                    continue block17;
                }
                case 5: {
                    v.addElement(new BHardwareRef(i, this.getBaseUnitText(), lex.getText("HardwareRef.biasJumpers")));
                    continue block17;
                }
                case 6: {
                    v.addElement(this.makeBaseboardCommRef(i, this.getCOM3()));
                    continue block17;
                }
                case 7: {
                    v.addElement(this.makeBaseboardCommRef(i, this.getCOM4()));
                    continue block17;
                }
                case 8: {
                    v.addElement(this.makeBaseboardCommRef(i, this.getCOM1()));
                    continue block17;
                }
                case 9: {
                    v.addElement(this.makeBaseboardCommRef(i, this.getCOM2()));
                    continue block17;
                }
                case 10: {
                    v.addElement(this.makeBaseboardCommRef(i, this.getCOM5()));
                    continue block17;
                }
                case 11: {
                    v.addElement(this.makeBaseboardCommRef(i, this.getCOM6()));
                    continue block17;
                }
                case 12: {
                    v.addElement(new BHardwareRef(i, this.getBaseUnitText(), lex.getText("HardwareRef.powerConnector")));
                    continue block17;
                }
                case 13: {
                    v.addElement(this.makeJumperRef(i));
                    continue block17;
                }
                case 14: {
                    v.addElement(new BHardwareRef(i, this.getBaseUnitText(), lex.getText("HardwareRef.leds")));
                    continue block17;
                }
                case 15: {
                    BOptionSlot slot = this.getOptionSlot1();
                    v.addElement(this.makeSlotRef(i, slot));
                    if (slot.isEmpty()) continue block17;
                    BOptionCard optionCard = (BOptionCard)slot.getContents();
                    optionCard.lease(1);
                    BPort[] cardPorts = (BPort[])optionCard.getChildren(BPort.class);
                    for (int j = 0; j < cardPorts.length; ++j) {
                        v.addElement(this.makePortRef(i, j + 1, cardPorts[j]));
                    }
                    continue block17;
                }
            }
        }
        return v;
    }

    public String getImagesDirectory() {
        return lex.getText(IMAGES_DIR);
    }

    public String getView(BObject v) {
        return lex.getText(VIEW);
    }

    public void configureOptionSlot(BOptionSlot slot, String functionCode1, String functionCode2) {
        slot.removeAll();
        if (!functionCode1.equalsIgnoreCase("FF") || !functionCode2.equalsIgnoreCase("FF")) {
            BOptionCard cardTemplate = BOptionCard.lookup((String)(functionCode1 + " " + functionCode2));
            if (cardTemplate == null) {
                slot.addCard(new BOptionCard(BHardwareScanService.lex.getText("unknownOptionCard", new Object[]{functionCode1, functionCode2}), functionCode1 + " " + functionCode2));
            } else {
                BOptionCard optionCard = (BOptionCard)cardTemplate.newCopy(true);
                slot.addCard(optionCard);
                BPort[] ports = optionCard.getPorts();
                for (int i = 0; i < ports.length; ++i) {
                    if (ports[i] == null) continue;
                    BPort port = ports[i];
                    if (optionCard.getUsesCom()) {
                        optionCard.rename(optionCard.getProperty(port.getName()), port.getPrefix() + slot.getSlotNumber(), null);
                        if (this.getCOM1().getStatus().equals((Object)BHwScanStatusEnum.serialShell)) {
                            port.setStatus(BHwScanStatusEnum.unavailable);
                            continue;
                        }
                        this.getCOM1().setStatus(BHwScanStatusEnum.unavailable);
                        if (this.simulation) continue;
                        port.initOwnerAndStatus();
                        continue;
                    }
                    optionCard.rename(optionCard.getProperty(port.getName()), this.makePortName(i + 1, port.getPrefix()), null);
                    if (this.simulation) continue;
                    port.initOwnerAndStatus();
                }
            }
        }
        if (slot.isEmpty()) {
            slot.add("Contents", (BValue)BHwScanStatusEnum.empty, 3);
        }
    }

    private void initializeStandardPorts() {
        this.setDisplayName(COM1, BFormat.make((String)("COM".toUpperCase() + "1")), null);
        this.setDisplayName(COM2, BFormat.make((String)("COM".toUpperCase() + "2")), null);
        this.setDisplayName(COM3, BFormat.make((String)("COM".toUpperCase() + "3")), null);
        this.setDisplayName(COM4, BFormat.make((String)("COM".toUpperCase() + "4")), null);
        this.setDisplayName(COM5, BFormat.make((String)("COM".toUpperCase() + "5")), null);
        this.setDisplayName(COM6, BFormat.make((String)("COM".toUpperCase() + "6")), null);
        this.setDisplayName(LAN1, BFormat.make((String)("LAN".toUpperCase() + "1")), null);
        this.setDisplayName(LAN2, BFormat.make((String)("LAN".toUpperCase() + "2")), null);
        this.setDisplayName(LON1, BFormat.make((String)("LON".toUpperCase() + "1")), null);
        if (!this.simulation) {
            this.getCOM1().initOwnerAndStatus();
            this.getCOM2().initOwnerAndStatus();
            this.getCOM3().initOwnerAndStatus();
            this.getCOM4().initOwnerAndStatus();
            this.getCOM5().initOwnerAndStatus();
            this.getCOM6().initOwnerAndStatus();
            this.getLAN1().initStatus();
            this.getLAN2().initStatus();
            this.getLON1().initOwnerAndStatus();
        }
    }
}

