/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.conversion;

import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="inFacets", type="BFacets", defaultValue="BFacets.make(BFacets.UNITS, UnitDatabase.getUnit(\"null\"))"), @NiagaraProperty(name="in", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=10), @NiagaraProperty(name="outFacets", type="BFacets", defaultValue="BFacets.make(BFacets.UNITS, UnitDatabase.getUnit(\"null\"))"), @NiagaraProperty(name="out", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=11)})
@NiagaraAction(name="refresh")
public class BNumericUnitConverter
extends BComponent
implements BIStatus,
BINumeric {
    @Generated
    public static final Property inFacets = BNumericUnitConverter.newProperty((int)0, (BValue)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"null")), null);
    @Generated
    public static final Property in = BNumericUnitConverter.newProperty((int)10, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property outFacets = BNumericUnitConverter.newProperty((int)0, (BValue)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"null")), null);
    @Generated
    public static final Property out = BNumericUnitConverter.newProperty((int)11, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Action refresh = BNumericUnitConverter.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNumericUnitConverter.class);
    private static final BIcon icon = BIcon.std((String)"control/control.png");
    private boolean linked = false;
    public static Log log = Log.getLog((String)"kitControl");

    @Generated
    public BFacets getInFacets() {
        return (BFacets)this.get(inFacets);
    }

    @Generated
    public void setInFacets(BFacets v) {
        this.set(inFacets, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getIn() {
        return (BStatusNumeric)this.get(in);
    }

    @Generated
    public void setIn(BStatusNumeric v) {
        this.set(in, (BValue)v, null);
    }

    @Generated
    public BFacets getOutFacets() {
        return (BFacets)this.get(outFacets);
    }

    @Generated
    public void setOutFacets(BFacets v) {
        this.set(outFacets, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getOut() {
        return (BStatusNumeric)this.get(out);
    }

    @Generated
    public void setOut(BStatusNumeric v) {
        this.set(out, (BValue)v, null);
    }

    @Generated
    public void refresh() {
        this.invoke(refresh, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.convert();
    }

    public void added(Property p, Context cx) {
        super.added(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (this.checkLinkAdded()) {
            this.syncSourceUnits();
        }
    }

    public void removed(Property p, BValue ov, Context cx) {
        super.removed(p, ov, cx);
        if (!this.isRunning()) {
            return;
        }
        this.checkLinkRemoved();
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p == in || p == inFacets || p == outFacets) {
            this.convert();
        }
    }

    public void doRefresh() {
        this.syncSourceUnits();
    }

    public String toString(Context cx) {
        return this.getOut().toString(cx);
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == in) {
            return this.getInFacets();
        }
        if (slot == out) {
            return this.getOutFacets();
        }
        return super.getSlotFacets(slot);
    }

    private synchronized boolean checkLinkRemoved() {
        BLink[] links = this.getLinks((Slot)in);
        if (links.length <= 0 && this.linked) {
            this.linked = false;
            return true;
        }
        return false;
    }

    private synchronized boolean checkLinkAdded() {
        BLink[] links = this.getLinks((Slot)in);
        if (links.length > 0 && !this.linked) {
            this.linked = true;
            return true;
        }
        return false;
    }

    private synchronized void syncSourceUnits() {
        BLink[] links;
        this.checkLinkAdded();
        if (this.linked && (links = this.getLinks((Slot)in)).length > 0) {
            BFacets srcFacets;
            Slot srcSlot = links[0].getSourceSlot();
            BComponent srcComponent = links[0].getSourceComponent();
            if (srcSlot != null && srcComponent != null && (srcFacets = srcComponent.getSlotFacets(srcSlot)) != null) {
                this.setInFacets(srcFacets);
                this.setOutFacets(srcFacets);
            }
        }
    }

    private void convert() {
        this.getOut().setStatus(this.getIn().getStatus());
        try {
            BUnit inUnit = (BUnit)this.getInFacets().get("units", (BObject)BUnit.NULL);
            BUnit outUnit = (BUnit)this.getOutFacets().get("units", (BObject)BUnit.NULL);
            double inValue = this.getIn().getValue();
            double outValue = inUnit.isNull() || outUnit.isNull() || inUnit == outUnit ? inValue : inUnit.convertTo(outUnit, inValue);
            this.getOut().setValue(outValue);
        }
        catch (Exception e) {
            this.getOut().setValue(this.getIn().getValue());
            this.getOut().setStatusFault(true);
        }
    }

    public BStatus getStatus() {
        return this.getOut().getStatus();
    }

    public double getNumeric() {
        return this.getOut().getValue();
    }

    public final BFacets getNumericFacets() {
        return this.getOutFacets();
    }

    public BIcon getIcon() {
        return icon;
    }
}

